<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchAbonnementResultV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Resultaat van zoeken abonnementen
 * @subpackage Structs
 */
class SearchAbonnementResultV4 extends AbstractStructBase
{
    /**
     * The aantal
     * Meta informations extracted from the WSDL
     * - documentation: Het aantal abonnees, in de lijst hieronder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aantal;
    /**
     * The abonnees
     * Meta informations extracted from the WSDL
     * - documentation: De resultaat lijst met gevonden abonnees.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AbonnementInfoV4
     */
    public $abonnees;
    /**
     * Constructor method for SearchAbonnementResultV4
     * @uses SearchAbonnementResultV4::setAantal()
     * @uses SearchAbonnementResultV4::setAbonnees()
     * @param int $aantal
     * @param \StructType\AbonnementInfoV4 $abonnees
     */
    public function __construct($aantal = null, \StructType\AbonnementInfoV4 $abonnees = null)
    {
        $this
            ->setAantal($aantal)
            ->setAbonnees($abonnees);
    }
    /**
     * Get aantal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantal()
    {
        return isset($this->aantal) ? $this->aantal : null;
    }
    /**
     * Set aantal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantal
     * @return \StructType\SearchAbonnementResultV4
     */
    public function setAantal($aantal = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aantal) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aantal)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aantal, strpos($aantal, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aantal) && !is_numeric($aantal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aantal)), __LINE__);
        }
        if (is_null($aantal) || (is_array($aantal) && empty($aantal))) {
            unset($this->aantal);
        } else {
            $this->aantal = $aantal;
        }
        return $this;
    }
    /**
     * Get abonnees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AbonnementInfoV4|null
     */
    public function getAbonnees()
    {
        return isset($this->abonnees) ? $this->abonnees : null;
    }
    /**
     * Set abonnees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AbonnementInfoV4 $abonnees
     * @return \StructType\SearchAbonnementResultV4
     */
    public function setAbonnees(\StructType\AbonnementInfoV4 $abonnees = null)
    {
        if (is_null($abonnees) || (is_array($abonnees) && empty($abonnees))) {
            unset($this->abonnees);
        } else {
            $this->abonnees = $abonnees;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchAbonnementResultV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
