<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RolInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst rollen.
 * @subpackage Structs
 */
class RolInfoV4 extends AbstractStructBase
{
    /**
     * The rol
     * Meta informations extracted from the WSDL
     * - documentation: Lijst rollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\RolV4[]
     */
    public $rol;
    /**
     * Constructor method for RolInfoV4
     * @uses RolInfoV4::setRol()
     * @param \StructType\RolV4[] $rol
     */
    public function __construct(array $rol = array())
    {
        $this
            ->setRol($rol);
    }
    /**
     * Get rol value
     * @return \StructType\RolV4[]|null
     */
    public function getRol()
    {
        return $this->rol;
    }
    /**
     * Set rol value
     * @throws \InvalidArgumentException
     * @param \StructType\RolV4[] $rol
     * @return \StructType\RolInfoV4
     */
    public function setRol(array $rol = array())
    {
        foreach ($rol as $rolInfoV4RolItem) {
            // validation for constraint: itemType
            if (!$rolInfoV4RolItem instanceof \StructType\RolV4) {
                throw new \InvalidArgumentException(sprintf('The rol property can only contain items of \StructType\RolV4, "%s" given', is_object($rolInfoV4RolItem) ? get_class($rolInfoV4RolItem) : gettype($rolInfoV4RolItem)), __LINE__);
            }
        }
        $this->rol = $rol;
        return $this;
    }
    /**
     * Add item to rol value
     * @throws \InvalidArgumentException
     * @param \StructType\RolV4 $item
     * @return \StructType\RolInfoV4
     */
    public function addToRol(\StructType\RolV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RolV4) {
            throw new \InvalidArgumentException(sprintf('The rol property can only contain items of \StructType\RolV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->rol[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RolInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
