<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieNummerObjectV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met relatie nummers.
 * @subpackage Structs
 */
class RelatieNummerObjectV4 extends AbstractStructBase
{
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met relatie nummers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * - totalDigits: 15
     * @var int[]
     */
    public $number;
    /**
     * Constructor method for RelatieNummerObjectV4
     * @uses RelatieNummerObjectV4::setNumber()
     * @param int[] $number
     */
    public function __construct(array $number = array())
    {
        $this
            ->setNumber($number);
    }
    /**
     * Get number value
     * @return int[]|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @throws \InvalidArgumentException
     * @param int[] $number
     * @return \StructType\RelatieNummerObjectV4
     */
    public function setNumber(array $number = array())
    {
        // validation for constraint: totalDigits
        if (is_float($number) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $number)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($number, strpos($number, '.')))), __LINE__);
        }
        foreach ($number as $relatieNummerObjectV4NumberItem) {
            // validation for constraint: itemType
            if (!is_numeric($relatieNummerObjectV4NumberItem)) {
                throw new \InvalidArgumentException(sprintf('The number property can only contain items of integer, "%s" given', is_object($relatieNummerObjectV4NumberItem) ? get_class($relatieNummerObjectV4NumberItem) : gettype($relatieNummerObjectV4NumberItem)), __LINE__);
            }
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Add item to number value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\RelatieNummerObjectV4
     */
    public function addToNumber($item)
    {
        // validation for constraint: totalDigits
        if (is_float($item) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $item)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($item, strpos($item, '.')))), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The number property can only contain items of integer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->number[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelatieNummerObjectV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
