<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositieTabV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met proposities.
 * @subpackage Structs
 */
class PropositieTabV4 extends AbstractStructBase
{
    /**
     * The propositie
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met proposities.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\PropositieObjectV4[]
     */
    public $propositie;
    /**
     * Constructor method for PropositieTabV4
     * @uses PropositieTabV4::setPropositie()
     * @param \StructType\PropositieObjectV4[] $propositie
     */
    public function __construct(array $propositie = array())
    {
        $this
            ->setPropositie($propositie);
    }
    /**
     * Get propositie value
     * @return \StructType\PropositieObjectV4[]|null
     */
    public function getPropositie()
    {
        return $this->propositie;
    }
    /**
     * Set propositie value
     * @throws \InvalidArgumentException
     * @param \StructType\PropositieObjectV4[] $propositie
     * @return \StructType\PropositieTabV4
     */
    public function setPropositie(array $propositie = array())
    {
        foreach ($propositie as $propositieTabV4PropositieItem) {
            // validation for constraint: itemType
            if (!$propositieTabV4PropositieItem instanceof \StructType\PropositieObjectV4) {
                throw new \InvalidArgumentException(sprintf('The propositie property can only contain items of \StructType\PropositieObjectV4, "%s" given', is_object($propositieTabV4PropositieItem) ? get_class($propositieTabV4PropositieItem) : gettype($propositieTabV4PropositieItem)), __LINE__);
            }
        }
        $this->propositie = $propositie;
        return $this;
    }
    /**
     * Add item to propositie value
     * @throws \InvalidArgumentException
     * @param \StructType\PropositieObjectV4 $item
     * @return \StructType\PropositieTabV4
     */
    public function addToPropositie(\StructType\PropositieObjectV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropositieObjectV4) {
            throw new \InvalidArgumentException(sprintf('The propositie property can only contain items of \StructType\PropositieObjectV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->propositie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropositieTabV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
