<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositieObjectV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: PropositieObject t.b.v. switch proposities.
 * @subpackage Structs
 */
class PropositieObjectV4 extends AbstractStructBase
{
    /**
     * The aboSoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboSoortCode;
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het (abonnements)pakket.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $pakketCode;
    /**
     * Constructor method for PropositieObjectV4
     * @uses PropositieObjectV4::setAboSoortCode()
     * @uses PropositieObjectV4::setPakketCode()
     * @param string $aboSoortCode
     * @param string $pakketCode
     */
    public function __construct($aboSoortCode = null, $pakketCode = null)
    {
        $this
            ->setAboSoortCode($aboSoortCode)
            ->setPakketCode($pakketCode);
    }
    /**
     * Get aboSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortCode()
    {
        return isset($this->aboSoortCode) ? $this->aboSoortCode : null;
    }
    /**
     * Set aboSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortCode
     * @return \StructType\PropositieObjectV4
     */
    public function setAboSoortCode($aboSoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortCode) && strlen($aboSoortCode) > 4000) || (is_array($aboSoortCode) && count($aboSoortCode) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboSoortCode) ? strlen($aboSoortCode) : count($aboSoortCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortCode) && !is_string($aboSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortCode)), __LINE__);
        }
        if (is_null($aboSoortCode) || (is_array($aboSoortCode) && empty($aboSoortCode))) {
            unset($this->aboSoortCode);
        } else {
            $this->aboSoortCode = $aboSoortCode;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \StructType\PropositieObjectV4
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketCode) && strlen($pakketCode) > 4000) || (is_array($pakketCode) && count($pakketCode) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($pakketCode) ? strlen($pakketCode) : count($pakketCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropositieObjectV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
