<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositieInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gevonden proposities.
 * @subpackage Structs
 */
class PropositieInfoV4 extends AbstractStructBase
{
    /**
     * The proposities
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden proposities.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\PropositiesV4[]
     */
    public $proposities;
    /**
     * Constructor method for PropositieInfoV4
     * @uses PropositieInfoV4::setProposities()
     * @param \StructType\PropositiesV4[] $proposities
     */
    public function __construct(array $proposities = array())
    {
        $this
            ->setProposities($proposities);
    }
    /**
     * Get proposities value
     * @return \StructType\PropositiesV4[]|null
     */
    public function getProposities()
    {
        return $this->proposities;
    }
    /**
     * Set proposities value
     * @throws \InvalidArgumentException
     * @param \StructType\PropositiesV4[] $proposities
     * @return \StructType\PropositieInfoV4
     */
    public function setProposities(array $proposities = array())
    {
        foreach ($proposities as $propositieInfoV4PropositiesItem) {
            // validation for constraint: itemType
            if (!$propositieInfoV4PropositiesItem instanceof \StructType\PropositiesV4) {
                throw new \InvalidArgumentException(sprintf('The proposities property can only contain items of \StructType\PropositiesV4, "%s" given', is_object($propositieInfoV4PropositiesItem) ? get_class($propositieInfoV4PropositiesItem) : gettype($propositieInfoV4PropositiesItem)), __LINE__);
            }
        }
        $this->proposities = $proposities;
        return $this;
    }
    /**
     * Add item to proposities value
     * @throws \InvalidArgumentException
     * @param \StructType\PropositiesV4 $item
     * @return \StructType\PropositieInfoV4
     */
    public function addToProposities(\StructType\PropositiesV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropositiesV4) {
            throw new \InvalidArgumentException(sprintf('The proposities property can only contain items of \StructType\PropositiesV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->proposities[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropositieInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
