<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeverbareProductenInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met leverbare producten (uitgaven).
 * @subpackage Structs
 */
class LeverbareProductenInfoV4 extends AbstractStructBase
{
    /**
     * The uitgave
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met leverbare producten (uitgaven).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\UitgaveObjectV4[]
     */
    public $uitgave;
    /**
     * Constructor method for LeverbareProductenInfoV4
     * @uses LeverbareProductenInfoV4::setUitgave()
     * @param \StructType\UitgaveObjectV4[] $uitgave
     */
    public function __construct(array $uitgave = array())
    {
        $this
            ->setUitgave($uitgave);
    }
    /**
     * Get uitgave value
     * @return \StructType\UitgaveObjectV4[]|null
     */
    public function getUitgave()
    {
        return $this->uitgave;
    }
    /**
     * Set uitgave value
     * @throws \InvalidArgumentException
     * @param \StructType\UitgaveObjectV4[] $uitgave
     * @return \StructType\LeverbareProductenInfoV4
     */
    public function setUitgave(array $uitgave = array())
    {
        foreach ($uitgave as $leverbareProductenInfoV4UitgaveItem) {
            // validation for constraint: itemType
            if (!$leverbareProductenInfoV4UitgaveItem instanceof \StructType\UitgaveObjectV4) {
                throw new \InvalidArgumentException(sprintf('The uitgave property can only contain items of \StructType\UitgaveObjectV4, "%s" given', is_object($leverbareProductenInfoV4UitgaveItem) ? get_class($leverbareProductenInfoV4UitgaveItem) : gettype($leverbareProductenInfoV4UitgaveItem)), __LINE__);
            }
        }
        $this->uitgave = $uitgave;
        return $this;
    }
    /**
     * Add item to uitgave value
     * @throws \InvalidArgumentException
     * @param \StructType\UitgaveObjectV4 $item
     * @return \StructType\LeverbareProductenInfoV4
     */
    public function addToUitgave(\StructType\UitgaveObjectV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UitgaveObjectV4) {
            throw new \InvalidArgumentException(sprintf('The uitgave property can only contain items of \StructType\UitgaveObjectV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->uitgave[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LeverbareProductenInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
