<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getToekomstigeMutatiesResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error1: Kan geen relatie vinden, er is geen relNo opgegeven. | error2: Kan geen relatie vinden obv de opgegeven relNo.
 * @subpackage Structs
 */
class GetToekomstigeMutatiesResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The toekomstigeMutaties
     * Meta informations extracted from the WSDL
     * - documentation: De lijst met toekomstige mutaties, zoals vakantie regelingen of verhuizingen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ToekMutInfoV4
     */
    public $toekomstigeMutaties;
    /**
     * Constructor method for getToekomstigeMutatiesResponse
     * @uses GetToekomstigeMutatiesResponse::setRequestTag()
     * @uses GetToekomstigeMutatiesResponse::setToekomstigeMutaties()
     * @param string $requestTag
     * @param \StructType\ToekMutInfoV4 $toekomstigeMutaties
     */
    public function __construct($requestTag = null, \StructType\ToekMutInfoV4 $toekomstigeMutaties = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setToekomstigeMutaties($toekomstigeMutaties);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetToekomstigeMutatiesResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get toekomstigeMutaties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ToekMutInfoV4|null
     */
    public function getToekomstigeMutaties()
    {
        return isset($this->toekomstigeMutaties) ? $this->toekomstigeMutaties : null;
    }
    /**
     * Set toekomstigeMutaties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ToekMutInfoV4 $toekomstigeMutaties
     * @return \StructType\GetToekomstigeMutatiesResponse
     */
    public function setToekomstigeMutaties(\StructType\ToekMutInfoV4 $toekomstigeMutaties = null)
    {
        if (is_null($toekomstigeMutaties) || (is_array($toekomstigeMutaties) && empty($toekomstigeMutaties))) {
            unset($this->toekomstigeMutaties);
        } else {
            $this->toekomstigeMutaties = $toekomstigeMutaties;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetToekomstigeMutatiesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
