<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSwitchPropositiesResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error1: Het abonnement is niet gevonden | error12: Er is geen abonnement opgegeven | error34: De actie is niet gevonden | error57: De actie is niet actief | error84: Voor de abonnee is al een actief abonnement met dezelfde uitgave
 * aanwezig (deze melding kan dus niet optreden als geenControleLopendAbo als 1 meegegeven is in het request) | error85: Het is niet mogelijk een proefabonnement aan te maken | error95: De ingangsdatum van de actie is nog niet ingegaan | error96: De
 * einddatum van de actie is verstreken | error180: Geen geldig switchmogelijkheid gevonden
 * @subpackage Structs
 */
class GetSwitchPropositiesResponse extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het abonnement waarvoor de proposities worden opgevraagd.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The startDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum per wanneer er geswitcht kan worden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $startDatum;
    /**
     * The proposities
     * Meta informations extracted from the WSDL
     * - documentation: Een lijst met mogelijke proposities waar naartoe er geswitcht mag worden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PropositieTabV4
     */
    public $proposities;
    /**
     * Constructor method for getSwitchPropositiesResponse
     * @uses GetSwitchPropositiesResponse::setAboNo()
     * @uses GetSwitchPropositiesResponse::setRequestTag()
     * @uses GetSwitchPropositiesResponse::setStartDatum()
     * @uses GetSwitchPropositiesResponse::setProposities()
     * @param int $aboNo
     * @param string $requestTag
     * @param string $startDatum
     * @param \StructType\PropositieTabV4 $proposities
     */
    public function __construct($aboNo = null, $requestTag = null, $startDatum = null, \StructType\PropositieTabV4 $proposities = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setRequestTag($requestTag)
            ->setStartDatum($startDatum)
            ->setProposities($proposities);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \StructType\GetSwitchPropositiesResponse
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetSwitchPropositiesResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get startDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDatum()
    {
        return isset($this->startDatum) ? $this->startDatum : null;
    }
    /**
     * Set startDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDatum
     * @return \StructType\GetSwitchPropositiesResponse
     */
    public function setStartDatum($startDatum = null)
    {
        // validation for constraint: string
        if (!is_null($startDatum) && !is_string($startDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDatum)), __LINE__);
        }
        if (is_null($startDatum) || (is_array($startDatum) && empty($startDatum))) {
            unset($this->startDatum);
        } else {
            $this->startDatum = $startDatum;
        }
        return $this;
    }
    /**
     * Get proposities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PropositieTabV4|null
     */
    public function getProposities()
    {
        return isset($this->proposities) ? $this->proposities : null;
    }
    /**
     * Set proposities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PropositieTabV4 $proposities
     * @return \StructType\GetSwitchPropositiesResponse
     */
    public function setProposities(\StructType\PropositieTabV4 $proposities = null)
    {
        if (is_null($proposities) || (is_array($proposities) && empty($proposities))) {
            unset($this->proposities);
        } else {
            $this->proposities = $proposities;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSwitchPropositiesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
