<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSwitchPropositiesRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft een lijst met proposities terug waar een abonnement naartoe kan switchen
 * @subpackage Structs
 */
class GetSwitchPropositiesRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het abonnement waarvoor de proposities worden opgevraagd.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The actieCode
     * Meta informations extracted from the WSDL
     * - documentation: Actiecode waarvoor de proposities worden opgevraagd.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $actieCode;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for getSwitchPropositiesRequest
     * @uses GetSwitchPropositiesRequest::setAboNo()
     * @uses GetSwitchPropositiesRequest::setActieCode()
     * @uses GetSwitchPropositiesRequest::setRequestTag()
     * @param int $aboNo
     * @param string $actieCode
     * @param string $requestTag
     */
    public function __construct($aboNo = null, $actieCode = null, $requestTag = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setActieCode($actieCode)
            ->setRequestTag($requestTag);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \StructType\GetSwitchPropositiesRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get actieCode value
     * @return string
     */
    public function getActieCode()
    {
        return $this->actieCode;
    }
    /**
     * Set actieCode value
     * @param string $actieCode
     * @return \StructType\GetSwitchPropositiesRequest
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actieCode) && strlen($actieCode) > 15) || (is_array($actieCode) && count($actieCode) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($actieCode) ? strlen($actieCode) : count($actieCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($actieCode) && strlen($actieCode) < 1) || (is_array($actieCode) && count($actieCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actieCode)), __LINE__);
        }
        $this->actieCode = $actieCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetSwitchPropositiesRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSwitchPropositiesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
