<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPostcodeInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft de straat en huisnummer terug die behoort bij de opgegeven postcode en huisnumemr combinatie. Deze operatie werkt alleen indien er een postcodetabel van Cendris in Zeno is geimporteerd of gebruik wordt gemaakt van AdresXpress
 * van Cendris of PostcodeApi.nu.</p> <p>Indien gebruik wordt gemaakt van PostcodeApi.nu, wordt geen straat- en plaats gevonden voor postbus-adressen omdat PostcodeApi.nu gebruik maakt van de gegevens uit de Basisadministratie Gemeenten (BAG).
 * @subpackage Structs
 */
class GetPostcodeInfoRequest extends AbstractStructBase
{
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - documentation: Postcode in formaat 0000 AA.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $postcode;
    /**
     * The huisNummer
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $huisNummer;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for getPostcodeInfoRequest
     * @uses GetPostcodeInfoRequest::setPostcode()
     * @uses GetPostcodeInfoRequest::setHuisNummer()
     * @uses GetPostcodeInfoRequest::setRequestTag()
     * @param string $postcode
     * @param float $huisNummer
     * @param string $requestTag
     */
    public function __construct($postcode = null, $huisNummer = null, $requestTag = null)
    {
        $this
            ->setPostcode($postcode)
            ->setHuisNummer($huisNummer)
            ->setRequestTag($requestTag);
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\GetPostcodeInfoRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postcode) && strlen($postcode) > 10) || (is_array($postcode) && count($postcode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($postcode) ? strlen($postcode) : count($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($postcode) && strlen($postcode) < 1) || (is_array($postcode) && count($postcode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get huisNummer value
     * @return float
     */
    public function getHuisNummer()
    {
        return $this->huisNummer;
    }
    /**
     * Set huisNummer value
     * @param float $huisNummer
     * @return \StructType\GetPostcodeInfoRequest
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($huisNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $huisNummer)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($huisNummer, strpos($huisNummer, '.')))), __LINE__);
        }
        $this->huisNummer = $huisNummer;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetPostcodeInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPostcodeInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
