<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getLicentiehoudersRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft terug wat de licentiehouders van een bepaald abonnement is.
 * @subpackage Structs
 */
class GetLicentiehoudersRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Het abonnementsnummer waarvan de licentiehouders opgehaald moeten worden. Als deze niet is opgegeven, moet een licentieNo worden meegegeven aan de aanroep.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The licentieNo
     * Meta informations extracted from the WSDL
     * - documentation: Het nunner dat een licentiehouder uniek identificeert. Als deze niet is opgegeven, moet een aboNo worden meegegeven aan de aanroep.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $licentieNo;
    /**
     * Constructor method for getLicentiehoudersRequest
     * @uses GetLicentiehoudersRequest::setRequestTag()
     * @uses GetLicentiehoudersRequest::setAboNo()
     * @uses GetLicentiehoudersRequest::setLicentieNo()
     * @param string $requestTag
     * @param int $aboNo
     * @param int $licentieNo
     */
    public function __construct($requestTag = null, $aboNo = null, $licentieNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAboNo($aboNo)
            ->setLicentieNo($licentieNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetLicentiehoudersRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \StructType\GetLicentiehoudersRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get licentieNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLicentieNo()
    {
        return isset($this->licentieNo) ? $this->licentieNo : null;
    }
    /**
     * Set licentieNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $licentieNo
     * @return \StructType\GetLicentiehoudersRequest
     */
    public function setLicentieNo($licentieNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($licentieNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $licentieNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($licentieNo, strpos($licentieNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($licentieNo) && !is_numeric($licentieNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($licentieNo)), __LINE__);
        }
        if (is_null($licentieNo) || (is_array($licentieNo) && empty($licentieNo))) {
            unset($this->licentieNo);
        } else {
            $this->licentieNo = $licentieNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetLicentiehoudersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
