<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAbonnementInfoResponse StructType
 * @subpackage Structs
 */
class GetAbonnementInfoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The return1
     * Meta informations extracted from the WSDL
     * - documentation: Resultaat. De output van deze service bestaat uit 4 delen: <br/>De gegevens van de abonnee. <br/>De gegevens van het abonnement. <br/>De gegevens van één of meerdere klachten bij het abonnement. <br/>De recente verschijningen van
     * het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AbonnementInfoV4
     */
    public $return1;
    /**
     * Constructor method for getAbonnementInfoResponse
     * @uses GetAbonnementInfoResponse::setRequestTag()
     * @uses GetAbonnementInfoResponse::setReturn1()
     * @param string $requestTag
     * @param \StructType\AbonnementInfoV4 $return1
     */
    public function __construct($requestTag = null, \StructType\AbonnementInfoV4 $return1 = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setReturn1($return1);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetAbonnementInfoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get return1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AbonnementInfoV4|null
     */
    public function getReturn1()
    {
        return isset($this->return1) ? $this->return1 : null;
    }
    /**
     * Set return1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AbonnementInfoV4 $return1
     * @return \StructType\GetAbonnementInfoResponse
     */
    public function setReturn1(\StructType\AbonnementInfoV4 $return1 = null)
    {
        if (is_null($return1) || (is_array($return1) && empty($return1))) {
            unset($this->return1);
        } else {
            $this->return1 = $return1;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAbonnementInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
