<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAbonnementInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ophalen van abonnements informatie.
 * @subpackage Structs
 */
class GetAbonnementInfoRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de relatie. Dient > 0 te zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The toonAbonnementen
     * Meta informations extracted from the WSDL
     * - documentation: Welk type abonnementen moet worden getoond 0=Alleen gewone (default) 1=Alleen licentie 2=Alle abonnementen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $toonAbonnementen;
    /**
     * The toonHistorie
     * Meta informations extracted from the WSDL
     * - documentation: Geeft aan of ook historische abonnementen moeten worden opgehaald.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $toonHistorie;
    /**
     * Constructor method for getAbonnementInfoRequest
     * @uses GetAbonnementInfoRequest::setRequestTag()
     * @uses GetAbonnementInfoRequest::setRelNo()
     * @uses GetAbonnementInfoRequest::setToonAbonnementen()
     * @uses GetAbonnementInfoRequest::setToonHistorie()
     * @param string $requestTag
     * @param int $relNo
     * @param float $toonAbonnementen
     * @param bool $toonHistorie
     */
    public function __construct($requestTag = null, $relNo = null, $toonAbonnementen = null, $toonHistorie = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelNo($relNo)
            ->setToonAbonnementen($toonAbonnementen)
            ->setToonHistorie($toonHistorie);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetAbonnementInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \StructType\GetAbonnementInfoRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get toonAbonnementen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getToonAbonnementen()
    {
        return isset($this->toonAbonnementen) ? $this->toonAbonnementen : null;
    }
    /**
     * Set toonAbonnementen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $toonAbonnementen
     * @return \StructType\GetAbonnementInfoRequest
     */
    public function setToonAbonnementen($toonAbonnementen = null)
    {
        // validation for constraint: totalDigits
        if (is_float($toonAbonnementen) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $toonAbonnementen)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($toonAbonnementen, strpos($toonAbonnementen, '.')))), __LINE__);
        }
        if (is_null($toonAbonnementen) || (is_array($toonAbonnementen) && empty($toonAbonnementen))) {
            unset($this->toonAbonnementen);
        } else {
            $this->toonAbonnementen = $toonAbonnementen;
        }
        return $this;
    }
    /**
     * Get toonHistorie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getToonHistorie()
    {
        return isset($this->toonHistorie) ? $this->toonHistorie : null;
    }
    /**
     * Set toonHistorie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $toonHistorie
     * @return \StructType\GetAbonnementInfoRequest
     */
    public function setToonHistorie($toonHistorie = null)
    {
        if (is_null($toonHistorie) || (is_array($toonHistorie) && empty($toonHistorie))) {
            unset($this->toonHistorie);
        } else {
            $this->toonHistorie = $toonHistorie;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAbonnementInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
