<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactuurAdresV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Het factuuradres bestaat uit de volgende velden:
 * @subpackage Structs
 */
class FactuurAdresV4 extends AbstractStructBase
{
    /**
     * The bedrijfsNaam
     * Meta informations extracted from the WSDL
     * - documentation: Bedrijfsnaam.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $bedrijfsNaam;
    /**
     * The afdeling
     * Meta informations extracted from the WSDL
     * - documentation: Afdeling.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $afdeling;
    /**
     * The voorLettersNaam
     * Meta informations extracted from the WSDL
     * - documentation: Voorletters of voornaam afhankelijk van hoe dat ingesteld staat in Zeno.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $voorLettersNaam;
    /**
     * The tussenvoegsels
     * Meta informations extracted from the WSDL
     * - documentation: Tussenvoegsels.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $tussenvoegsels;
    /**
     * The achterNaam
     * Meta informations extracted from the WSDL
     * - documentation: Achternaam.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $achterNaam;
    /**
     * The straat
     * Meta informations extracted from the WSDL
     * - documentation: Straatnaam.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $straat;
    /**
     * The huisNummer
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer, groter dan 0.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $huisNummer;
    /**
     * The huisNummerToev
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer toevoeging.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $huisNummerToev;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - documentation: Postcode.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $postcode;
    /**
     * The plaats
     * Meta informations extracted from the WSDL
     * - documentation: Woonplaats.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 40
     * @var string
     */
    public $plaats;
    /**
     * The land
     * Meta informations extracted from the WSDL
     * - documentation: Land.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $land;
    /**
     * Constructor method for FactuurAdresV4
     * @uses FactuurAdresV4::setBedrijfsNaam()
     * @uses FactuurAdresV4::setAfdeling()
     * @uses FactuurAdresV4::setVoorLettersNaam()
     * @uses FactuurAdresV4::setTussenvoegsels()
     * @uses FactuurAdresV4::setAchterNaam()
     * @uses FactuurAdresV4::setStraat()
     * @uses FactuurAdresV4::setHuisNummer()
     * @uses FactuurAdresV4::setHuisNummerToev()
     * @uses FactuurAdresV4::setPostcode()
     * @uses FactuurAdresV4::setPlaats()
     * @uses FactuurAdresV4::setLand()
     * @param string $bedrijfsNaam
     * @param string $afdeling
     * @param string $voorLettersNaam
     * @param string $tussenvoegsels
     * @param string $achterNaam
     * @param string $straat
     * @param int $huisNummer
     * @param string $huisNummerToev
     * @param string $postcode
     * @param string $plaats
     * @param string $land
     */
    public function __construct($bedrijfsNaam = null, $afdeling = null, $voorLettersNaam = null, $tussenvoegsels = null, $achterNaam = null, $straat = null, $huisNummer = null, $huisNummerToev = null, $postcode = null, $plaats = null, $land = null)
    {
        $this
            ->setBedrijfsNaam($bedrijfsNaam)
            ->setAfdeling($afdeling)
            ->setVoorLettersNaam($voorLettersNaam)
            ->setTussenvoegsels($tussenvoegsels)
            ->setAchterNaam($achterNaam)
            ->setStraat($straat)
            ->setHuisNummer($huisNummer)
            ->setHuisNummerToev($huisNummerToev)
            ->setPostcode($postcode)
            ->setPlaats($plaats)
            ->setLand($land);
    }
    /**
     * Get bedrijfsNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBedrijfsNaam()
    {
        return isset($this->bedrijfsNaam) ? $this->bedrijfsNaam : null;
    }
    /**
     * Set bedrijfsNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bedrijfsNaam
     * @return \StructType\FactuurAdresV4
     */
    public function setBedrijfsNaam($bedrijfsNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bedrijfsNaam) && strlen($bedrijfsNaam) > 120) || (is_array($bedrijfsNaam) && count($bedrijfsNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($bedrijfsNaam) ? strlen($bedrijfsNaam) : count($bedrijfsNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bedrijfsNaam) && !is_string($bedrijfsNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bedrijfsNaam)), __LINE__);
        }
        if (is_null($bedrijfsNaam) || (is_array($bedrijfsNaam) && empty($bedrijfsNaam))) {
            unset($this->bedrijfsNaam);
        } else {
            $this->bedrijfsNaam = $bedrijfsNaam;
        }
        return $this;
    }
    /**
     * Get afdeling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfdeling()
    {
        return isset($this->afdeling) ? $this->afdeling : null;
    }
    /**
     * Set afdeling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afdeling
     * @return \StructType\FactuurAdresV4
     */
    public function setAfdeling($afdeling = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($afdeling) && strlen($afdeling) > 120) || (is_array($afdeling) && count($afdeling) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($afdeling) ? strlen($afdeling) : count($afdeling)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($afdeling) && !is_string($afdeling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($afdeling)), __LINE__);
        }
        if (is_null($afdeling) || (is_array($afdeling) && empty($afdeling))) {
            unset($this->afdeling);
        } else {
            $this->afdeling = $afdeling;
        }
        return $this;
    }
    /**
     * Get voorLettersNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorLettersNaam()
    {
        return isset($this->voorLettersNaam) ? $this->voorLettersNaam : null;
    }
    /**
     * Set voorLettersNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorLettersNaam
     * @return \StructType\FactuurAdresV4
     */
    public function setVoorLettersNaam($voorLettersNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($voorLettersNaam) && strlen($voorLettersNaam) > 120) || (is_array($voorLettersNaam) && count($voorLettersNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($voorLettersNaam) ? strlen($voorLettersNaam) : count($voorLettersNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($voorLettersNaam) && !is_string($voorLettersNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voorLettersNaam)), __LINE__);
        }
        if (is_null($voorLettersNaam) || (is_array($voorLettersNaam) && empty($voorLettersNaam))) {
            unset($this->voorLettersNaam);
        } else {
            $this->voorLettersNaam = $voorLettersNaam;
        }
        return $this;
    }
    /**
     * Get tussenvoegsels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTussenvoegsels()
    {
        return isset($this->tussenvoegsels) ? $this->tussenvoegsels : null;
    }
    /**
     * Set tussenvoegsels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tussenvoegsels
     * @return \StructType\FactuurAdresV4
     */
    public function setTussenvoegsels($tussenvoegsels = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tussenvoegsels) && strlen($tussenvoegsels) > 10) || (is_array($tussenvoegsels) && count($tussenvoegsels) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($tussenvoegsels) ? strlen($tussenvoegsels) : count($tussenvoegsels)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tussenvoegsels) && !is_string($tussenvoegsels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tussenvoegsels)), __LINE__);
        }
        if (is_null($tussenvoegsels) || (is_array($tussenvoegsels) && empty($tussenvoegsels))) {
            unset($this->tussenvoegsels);
        } else {
            $this->tussenvoegsels = $tussenvoegsels;
        }
        return $this;
    }
    /**
     * Get achterNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAchterNaam()
    {
        return isset($this->achterNaam) ? $this->achterNaam : null;
    }
    /**
     * Set achterNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $achterNaam
     * @return \StructType\FactuurAdresV4
     */
    public function setAchterNaam($achterNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($achterNaam) && strlen($achterNaam) > 120) || (is_array($achterNaam) && count($achterNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($achterNaam) ? strlen($achterNaam) : count($achterNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($achterNaam) && !is_string($achterNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($achterNaam)), __LINE__);
        }
        if (is_null($achterNaam) || (is_array($achterNaam) && empty($achterNaam))) {
            unset($this->achterNaam);
        } else {
            $this->achterNaam = $achterNaam;
        }
        return $this;
    }
    /**
     * Get straat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStraat()
    {
        return isset($this->straat) ? $this->straat : null;
    }
    /**
     * Set straat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $straat
     * @return \StructType\FactuurAdresV4
     */
    public function setStraat($straat = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($straat) && strlen($straat) > 255) || (is_array($straat) && count($straat) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($straat) ? strlen($straat) : count($straat)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($straat) && !is_string($straat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($straat)), __LINE__);
        }
        if (is_null($straat) || (is_array($straat) && empty($straat))) {
            unset($this->straat);
        } else {
            $this->straat = $straat;
        }
        return $this;
    }
    /**
     * Get huisNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHuisNummer()
    {
        return isset($this->huisNummer) ? $this->huisNummer : null;
    }
    /**
     * Set huisNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $huisNummer
     * @return \StructType\FactuurAdresV4
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($huisNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $huisNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($huisNummer, strpos($huisNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($huisNummer) && !is_numeric($huisNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($huisNummer)), __LINE__);
        }
        if (is_null($huisNummer) || (is_array($huisNummer) && empty($huisNummer))) {
            unset($this->huisNummer);
        } else {
            $this->huisNummer = $huisNummer;
        }
        return $this;
    }
    /**
     * Get huisNummerToev value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisNummerToev()
    {
        return isset($this->huisNummerToev) ? $this->huisNummerToev : null;
    }
    /**
     * Set huisNummerToev value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisNummerToev
     * @return \StructType\FactuurAdresV4
     */
    public function setHuisNummerToev($huisNummerToev = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($huisNummerToev) && strlen($huisNummerToev) > 12) || (is_array($huisNummerToev) && count($huisNummerToev) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($huisNummerToev) ? strlen($huisNummerToev) : count($huisNummerToev)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($huisNummerToev) && !is_string($huisNummerToev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($huisNummerToev)), __LINE__);
        }
        if (is_null($huisNummerToev) || (is_array($huisNummerToev) && empty($huisNummerToev))) {
            unset($this->huisNummerToev);
        } else {
            $this->huisNummerToev = $huisNummerToev;
        }
        return $this;
    }
    /**
     * Get postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->postcode) ? $this->postcode : null;
    }
    /**
     * Set postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\FactuurAdresV4
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postcode) && strlen($postcode) > 10) || (is_array($postcode) && count($postcode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($postcode) ? strlen($postcode) : count($postcode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->postcode);
        } else {
            $this->postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get plaats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaats()
    {
        return isset($this->plaats) ? $this->plaats : null;
    }
    /**
     * Set plaats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plaats
     * @return \StructType\FactuurAdresV4
     */
    public function setPlaats($plaats = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($plaats) && strlen($plaats) > 40) || (is_array($plaats) && count($plaats) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($plaats) ? strlen($plaats) : count($plaats)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($plaats) && !is_string($plaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plaats)), __LINE__);
        }
        if (is_null($plaats) || (is_array($plaats) && empty($plaats))) {
            unset($this->plaats);
        } else {
            $this->plaats = $plaats;
        }
        return $this;
    }
    /**
     * Get land value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLand()
    {
        return isset($this->land) ? $this->land : null;
    }
    /**
     * Set land value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $land
     * @return \StructType\FactuurAdresV4
     */
    public function setLand($land = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($land) && strlen($land) > 120) || (is_array($land) && count($land) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($land) ? strlen($land) : count($land)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($land) && !is_string($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($land)), __LINE__);
        }
        if (is_null($land) || (is_array($land) && empty($land))) {
            unset($this->land);
        } else {
            $this->land = $land;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FactuurAdresV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
