<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatSubtotV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Subtotaal regels van een factuur samenvatting.
 * @subpackage Structs
 */
class FactSamenvatSubtotV4 extends AbstractStructBase
{
    /**
     * The subtotaalBedragExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Subtotaal bedrag exclusief BTW.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $subtotaalBedragExclBtw;
    /**
     * The omschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Regel omschrijving.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $omschrijving;
    /**
     * The periodeVan
     * Meta informations extracted from the WSDL
     * - documentation: Periode, datum vanaf.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $periodeVan;
    /**
     * The periodeTm
     * Meta informations extracted from the WSDL
     * - documentation: Periode, datum tot en met.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $periodeTm;
    /**
     * Constructor method for FactSamenvatSubtotV4
     * @uses FactSamenvatSubtotV4::setSubtotaalBedragExclBtw()
     * @uses FactSamenvatSubtotV4::setOmschrijving()
     * @uses FactSamenvatSubtotV4::setPeriodeVan()
     * @uses FactSamenvatSubtotV4::setPeriodeTm()
     * @param float $subtotaalBedragExclBtw
     * @param string $omschrijving
     * @param string $periodeVan
     * @param string $periodeTm
     */
    public function __construct($subtotaalBedragExclBtw = null, $omschrijving = null, $periodeVan = null, $periodeTm = null)
    {
        $this
            ->setSubtotaalBedragExclBtw($subtotaalBedragExclBtw)
            ->setOmschrijving($omschrijving)
            ->setPeriodeVan($periodeVan)
            ->setPeriodeTm($periodeTm);
    }
    /**
     * Get subtotaalBedragExclBtw value
     * @return float
     */
    public function getSubtotaalBedragExclBtw()
    {
        return $this->subtotaalBedragExclBtw;
    }
    /**
     * Set subtotaalBedragExclBtw value
     * @param float $subtotaalBedragExclBtw
     * @return \StructType\FactSamenvatSubtotV4
     */
    public function setSubtotaalBedragExclBtw($subtotaalBedragExclBtw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($subtotaalBedragExclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $subtotaalBedragExclBtw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($subtotaalBedragExclBtw, strpos($subtotaalBedragExclBtw, '.')))), __LINE__);
        }
        $this->subtotaalBedragExclBtw = $subtotaalBedragExclBtw;
        return $this;
    }
    /**
     * Get omschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOmschrijving()
    {
        return isset($this->omschrijving) ? $this->omschrijving : null;
    }
    /**
     * Set omschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $omschrijving
     * @return \StructType\FactSamenvatSubtotV4
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($omschrijving) && strlen($omschrijving) > 4000) || (is_array($omschrijving) && count($omschrijving) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($omschrijving) ? strlen($omschrijving) : count($omschrijving)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($omschrijving)), __LINE__);
        }
        if (is_null($omschrijving) || (is_array($omschrijving) && empty($omschrijving))) {
            unset($this->omschrijving);
        } else {
            $this->omschrijving = $omschrijving;
        }
        return $this;
    }
    /**
     * Get periodeVan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodeVan()
    {
        return isset($this->periodeVan) ? $this->periodeVan : null;
    }
    /**
     * Set periodeVan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodeVan
     * @return \StructType\FactSamenvatSubtotV4
     */
    public function setPeriodeVan($periodeVan = null)
    {
        // validation for constraint: string
        if (!is_null($periodeVan) && !is_string($periodeVan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodeVan)), __LINE__);
        }
        if (is_null($periodeVan) || (is_array($periodeVan) && empty($periodeVan))) {
            unset($this->periodeVan);
        } else {
            $this->periodeVan = $periodeVan;
        }
        return $this;
    }
    /**
     * Get periodeTm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodeTm()
    {
        return isset($this->periodeTm) ? $this->periodeTm : null;
    }
    /**
     * Set periodeTm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodeTm
     * @return \StructType\FactSamenvatSubtotV4
     */
    public function setPeriodeTm($periodeTm = null)
    {
        // validation for constraint: string
        if (!is_null($periodeTm) && !is_string($periodeTm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodeTm)), __LINE__);
        }
        if (is_null($periodeTm) || (is_array($periodeTm) && empty($periodeTm))) {
            unset($this->periodeTm);
        } else {
            $this->periodeTm = $periodeTm;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FactSamenvatSubtotV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
