<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatSubtotInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met subtotaal regels van een factuur samenvatting.
 * @subpackage Structs
 */
class FactSamenvatSubtotInfoV4 extends AbstractStructBase
{
    /**
     * The subtotaal
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met subtotaal regels van een factuur samenvatting.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\FactSamenvatSubtotV4[]
     */
    public $subtotaal;
    /**
     * Constructor method for FactSamenvatSubtotInfoV4
     * @uses FactSamenvatSubtotInfoV4::setSubtotaal()
     * @param \StructType\FactSamenvatSubtotV4[] $subtotaal
     */
    public function __construct(array $subtotaal = array())
    {
        $this
            ->setSubtotaal($subtotaal);
    }
    /**
     * Get subtotaal value
     * @return \StructType\FactSamenvatSubtotV4[]|null
     */
    public function getSubtotaal()
    {
        return $this->subtotaal;
    }
    /**
     * Set subtotaal value
     * @throws \InvalidArgumentException
     * @param \StructType\FactSamenvatSubtotV4[] $subtotaal
     * @return \StructType\FactSamenvatSubtotInfoV4
     */
    public function setSubtotaal(array $subtotaal = array())
    {
        foreach ($subtotaal as $factSamenvatSubtotInfoV4SubtotaalItem) {
            // validation for constraint: itemType
            if (!$factSamenvatSubtotInfoV4SubtotaalItem instanceof \StructType\FactSamenvatSubtotV4) {
                throw new \InvalidArgumentException(sprintf('The subtotaal property can only contain items of \StructType\FactSamenvatSubtotV4, "%s" given', is_object($factSamenvatSubtotInfoV4SubtotaalItem) ? get_class($factSamenvatSubtotInfoV4SubtotaalItem) : gettype($factSamenvatSubtotInfoV4SubtotaalItem)), __LINE__);
            }
        }
        $this->subtotaal = $subtotaal;
        return $this;
    }
    /**
     * Add item to subtotaal value
     * @throws \InvalidArgumentException
     * @param \StructType\FactSamenvatSubtotV4 $item
     * @return \StructType\FactSamenvatSubtotInfoV4
     */
    public function addToSubtotaal(\StructType\FactSamenvatSubtotV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FactSamenvatSubtotV4) {
            throw new \InvalidArgumentException(sprintf('The subtotaal property can only contain items of \StructType\FactSamenvatSubtotV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subtotaal[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FactSamenvatSubtotInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
