<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditieV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Gegevens van de editie.
 * @subpackage Structs
 */
class EditieV4 extends AbstractStructBase
{
    /**
     * The editieCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de editie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $editieCode;
    /**
     * The editieNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de editie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 120
     * - minLength: 1
     * @var string
     */
    public $editieNaam;
    /**
     * The editieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de editie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $editieNummer;
    /**
     * The editieVerschijndatum
     * Meta informations extracted from the WSDL
     * - documentation: Verschijndatum van de editie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $editieVerschijndatum;
    /**
     * Constructor method for EditieV4
     * @uses EditieV4::setEditieCode()
     * @uses EditieV4::setEditieNaam()
     * @uses EditieV4::setEditieNummer()
     * @uses EditieV4::setEditieVerschijndatum()
     * @param string $editieCode
     * @param string $editieNaam
     * @param int $editieNummer
     * @param string $editieVerschijndatum
     */
    public function __construct($editieCode = null, $editieNaam = null, $editieNummer = null, $editieVerschijndatum = null)
    {
        $this
            ->setEditieCode($editieCode)
            ->setEditieNaam($editieNaam)
            ->setEditieNummer($editieNummer)
            ->setEditieVerschijndatum($editieVerschijndatum);
    }
    /**
     * Get editieCode value
     * @return string
     */
    public function getEditieCode()
    {
        return $this->editieCode;
    }
    /**
     * Set editieCode value
     * @param string $editieCode
     * @return \StructType\EditieV4
     */
    public function setEditieCode($editieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($editieCode) && strlen($editieCode) > 30) || (is_array($editieCode) && count($editieCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($editieCode) ? strlen($editieCode) : count($editieCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($editieCode) && strlen($editieCode) < 1) || (is_array($editieCode) && count($editieCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($editieCode) && !is_string($editieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($editieCode)), __LINE__);
        }
        $this->editieCode = $editieCode;
        return $this;
    }
    /**
     * Get editieNaam value
     * @return string
     */
    public function getEditieNaam()
    {
        return $this->editieNaam;
    }
    /**
     * Set editieNaam value
     * @param string $editieNaam
     * @return \StructType\EditieV4
     */
    public function setEditieNaam($editieNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($editieNaam) && strlen($editieNaam) > 120) || (is_array($editieNaam) && count($editieNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($editieNaam) ? strlen($editieNaam) : count($editieNaam)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($editieNaam) && strlen($editieNaam) < 1) || (is_array($editieNaam) && count($editieNaam) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($editieNaam) && !is_string($editieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($editieNaam)), __LINE__);
        }
        $this->editieNaam = $editieNaam;
        return $this;
    }
    /**
     * Get editieNummer value
     * @return int
     */
    public function getEditieNummer()
    {
        return $this->editieNummer;
    }
    /**
     * Set editieNummer value
     * @param int $editieNummer
     * @return \StructType\EditieV4
     */
    public function setEditieNummer($editieNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($editieNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $editieNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($editieNummer, strpos($editieNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($editieNummer) && !is_numeric($editieNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($editieNummer)), __LINE__);
        }
        $this->editieNummer = $editieNummer;
        return $this;
    }
    /**
     * Get editieVerschijndatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEditieVerschijndatum()
    {
        return isset($this->editieVerschijndatum) ? $this->editieVerschijndatum : null;
    }
    /**
     * Set editieVerschijndatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $editieVerschijndatum
     * @return \StructType\EditieV4
     */
    public function setEditieVerschijndatum($editieVerschijndatum = null)
    {
        // validation for constraint: string
        if (!is_null($editieVerschijndatum) && !is_string($editieVerschijndatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($editieVerschijndatum)), __LINE__);
        }
        if (is_null($editieVerschijndatum) || (is_array($editieVerschijndatum) && empty($editieVerschijndatum))) {
            unset($this->editieVerschijndatum);
        } else {
            $this->editieVerschijndatum = $editieVerschijndatum;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditieV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
