<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteVerbandRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Verwijdert een relatieverband tussen twee relaties.
 * @subpackage Structs
 */
class DeleteVerbandRequest extends AbstractStructBase
{
    /**
     * The verbandNo
     * Meta informations extracted from the WSDL
     * - documentation: Verbandnummer van het te verwijderen verband.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $verbandNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for deleteVerbandRequest
     * @uses DeleteVerbandRequest::setVerbandNo()
     * @uses DeleteVerbandRequest::setRequestTag()
     * @param int $verbandNo
     * @param string $requestTag
     */
    public function __construct($verbandNo = null, $requestTag = null)
    {
        $this
            ->setVerbandNo($verbandNo)
            ->setRequestTag($requestTag);
    }
    /**
     * Get verbandNo value
     * @return int
     */
    public function getVerbandNo()
    {
        return $this->verbandNo;
    }
    /**
     * Set verbandNo value
     * @param int $verbandNo
     * @return \StructType\DeleteVerbandRequest
     */
    public function setVerbandNo($verbandNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($verbandNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $verbandNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($verbandNo, strpos($verbandNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($verbandNo) && !is_numeric($verbandNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($verbandNo)), __LINE__);
        }
        $this->verbandNo = $verbandNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\DeleteVerbandRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteVerbandRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
