<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVervolgAbonnementRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Maakt op basis van een bestaand (proef-) abonnement een vervolgabonnement aan.</p> <p>Met createVervolgAbonnement kan een bestaand (proef-) abonnement opgevolgd worden met een nieuw abonnement. Voor het nieuwe abonnement kan een
 * afwijkende debiteur opgegeven worden, dit kan handig zijn bij het opvolgen van cadeauabonnementen (die doorgaans door een andere debiteur betaald worden). Indien dit leeggelaten wordt, zal de abonnee zelf als debiteur genomen worden. </p> <p>(N.B.
 * het veld ingangsDatum van het aboObject kan gevuld worden, maar zal bij invoer van het vervolgAbonnement genegeerd worden).
 * @subpackage Structs
 */
class CreateVervolgAbonnementRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementnummer van een bestaand (proef-) abonnement waarvoor een vervolgabonnement aangemaakt moet worden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The aboObject
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsgegevens van het nieuwe abonnment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AboObjectV4
     */
    public $aboObject;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The relNoDeb
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer van de debiteur. De relatie moet bestaan. Indien leeg, wordt de abonnee van het bestaande abonnement zelf als debiteur genomen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoDeb;
    /**
     * The geenControleLopendAbo
     * Meta informations extracted from the WSDL
     * - documentation: Controle actief abonnement niet uitvoeren voor deze aanvraag. Default false dus wel uitvoeren.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $geenControleLopendAbo;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen vervolg abonnement aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createVervolgAbonnementRequest
     * @uses CreateVervolgAbonnementRequest::setAboNo()
     * @uses CreateVervolgAbonnementRequest::setAboObject()
     * @uses CreateVervolgAbonnementRequest::setRequestTag()
     * @uses CreateVervolgAbonnementRequest::setRelNoDeb()
     * @uses CreateVervolgAbonnementRequest::setGeenControleLopendAbo()
     * @uses CreateVervolgAbonnementRequest::setCanCreate()
     * @param int $aboNo
     * @param \StructType\AboObjectV4 $aboObject
     * @param string $requestTag
     * @param int $relNoDeb
     * @param bool $geenControleLopendAbo
     * @param bool $canCreate
     */
    public function __construct($aboNo = null, \StructType\AboObjectV4 $aboObject = null, $requestTag = null, $relNoDeb = null, $geenControleLopendAbo = null, $canCreate = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setAboObject($aboObject)
            ->setRequestTag($requestTag)
            ->setRelNoDeb($relNoDeb)
            ->setGeenControleLopendAbo($geenControleLopendAbo)
            ->setCanCreate($canCreate);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \StructType\CreateVervolgAbonnementRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get aboObject value
     * @return \StructType\AboObjectV4
     */
    public function getAboObject()
    {
        return $this->aboObject;
    }
    /**
     * Set aboObject value
     * @param \StructType\AboObjectV4 $aboObject
     * @return \StructType\CreateVervolgAbonnementRequest
     */
    public function setAboObject(\StructType\AboObjectV4 $aboObject = null)
    {
        $this->aboObject = $aboObject;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateVervolgAbonnementRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNoDeb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoDeb()
    {
        return isset($this->relNoDeb) ? $this->relNoDeb : null;
    }
    /**
     * Set relNoDeb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoDeb
     * @return \StructType\CreateVervolgAbonnementRequest
     */
    public function setRelNoDeb($relNoDeb = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoDeb) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoDeb)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoDeb, strpos($relNoDeb, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoDeb) && !is_numeric($relNoDeb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoDeb)), __LINE__);
        }
        if (is_null($relNoDeb) || (is_array($relNoDeb) && empty($relNoDeb))) {
            unset($this->relNoDeb);
        } else {
            $this->relNoDeb = $relNoDeb;
        }
        return $this;
    }
    /**
     * Get geenControleLopendAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGeenControleLopendAbo()
    {
        return isset($this->geenControleLopendAbo) ? $this->geenControleLopendAbo : null;
    }
    /**
     * Set geenControleLopendAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $geenControleLopendAbo
     * @return \StructType\CreateVervolgAbonnementRequest
     */
    public function setGeenControleLopendAbo($geenControleLopendAbo = null)
    {
        if (is_null($geenControleLopendAbo) || (is_array($geenControleLopendAbo) && empty($geenControleLopendAbo))) {
            unset($this->geenControleLopendAbo);
        } else {
            $this->geenControleLopendAbo = $geenControleLopendAbo;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \StructType\CreateVervolgAbonnementRequest
     */
    public function setCanCreate($canCreate = null)
    {
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateVervolgAbonnementRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
