<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerbandR1noR2noRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Maakt een relatieverband tussen twee relaties aan.</p> <p>Een ingelogde gebruiker (het relatienummer is bekend) wil een verband vastleggen tussen zijn/haar gebruiker en een andere bekende gebruiker.</p> <p>Voor de meegegeven
 * relatienummers wordt gecontroleerd of deze bij een verwijderde relatie horen. Als dat het geval is (mogelijk door samengevoegde doublures) wordt het relatienummer van de relatie waaraan de verwijderde relatie gekoppeld is gebruikt en geretourneerd.
 * @subpackage Structs
 */
class CreateVerbandR1noR2noRequest extends AbstractStructBase
{
    /**
     * The relNoRel1
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van Relatie 1.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel1;
    /**
     * The relNoRel2
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van Relatie 2.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel2;
    /**
     * The verbandCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het te leggen verband. Moet een bestaande code zijn.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $verbandCode;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen verband aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createVerbandR1noR2noRequest
     * @uses CreateVerbandR1noR2noRequest::setRelNoRel1()
     * @uses CreateVerbandR1noR2noRequest::setRelNoRel2()
     * @uses CreateVerbandR1noR2noRequest::setVerbandCode()
     * @uses CreateVerbandR1noR2noRequest::setRequestTag()
     * @uses CreateVerbandR1noR2noRequest::setCanCreate()
     * @param int $relNoRel1
     * @param int $relNoRel2
     * @param string $verbandCode
     * @param string $requestTag
     * @param bool $canCreate
     */
    public function __construct($relNoRel1 = null, $relNoRel2 = null, $verbandCode = null, $requestTag = null, $canCreate = null)
    {
        $this
            ->setRelNoRel1($relNoRel1)
            ->setRelNoRel2($relNoRel2)
            ->setVerbandCode($verbandCode)
            ->setRequestTag($requestTag)
            ->setCanCreate($canCreate);
    }
    /**
     * Get relNoRel1 value
     * @return int
     */
    public function getRelNoRel1()
    {
        return $this->relNoRel1;
    }
    /**
     * Set relNoRel1 value
     * @param int $relNoRel1
     * @return \StructType\CreateVerbandR1noR2noRequest
     */
    public function setRelNoRel1($relNoRel1 = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoRel1) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoRel1)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoRel1, strpos($relNoRel1, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoRel1) && !is_numeric($relNoRel1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoRel1)), __LINE__);
        }
        $this->relNoRel1 = $relNoRel1;
        return $this;
    }
    /**
     * Get relNoRel2 value
     * @return int
     */
    public function getRelNoRel2()
    {
        return $this->relNoRel2;
    }
    /**
     * Set relNoRel2 value
     * @param int $relNoRel2
     * @return \StructType\CreateVerbandR1noR2noRequest
     */
    public function setRelNoRel2($relNoRel2 = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoRel2) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoRel2)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoRel2, strpos($relNoRel2, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoRel2) && !is_numeric($relNoRel2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoRel2)), __LINE__);
        }
        $this->relNoRel2 = $relNoRel2;
        return $this;
    }
    /**
     * Get verbandCode value
     * @return string
     */
    public function getVerbandCode()
    {
        return $this->verbandCode;
    }
    /**
     * Set verbandCode value
     * @param string $verbandCode
     * @return \StructType\CreateVerbandR1noR2noRequest
     */
    public function setVerbandCode($verbandCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($verbandCode) && strlen($verbandCode) > 12) || (is_array($verbandCode) && count($verbandCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($verbandCode) ? strlen($verbandCode) : count($verbandCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($verbandCode) && strlen($verbandCode) < 1) || (is_array($verbandCode) && count($verbandCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($verbandCode) && !is_string($verbandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verbandCode)), __LINE__);
        }
        $this->verbandCode = $verbandCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateVerbandR1noR2noRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \StructType\CreateVerbandR1noR2noRequest
     */
    public function setCanCreate($canCreate = null)
    {
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateVerbandR1noR2noRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
