<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createKlantPersoonRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Aanmaken van een nieuwe relatie van type persoon. Bij het aanmaken wordt op basis van de input gekeken of er al een persoon in de database staat die gelijk is. In dat geval wordt er geen nieuwe relatie aangemaakt maar wordt de
 * bestaande relatie gebruikt. De businessrules hiervoor zijn op te vragen bij de servicedesk van Socho_IT.
 * @subpackage Structs
 */
class CreateKlantPersoonRequest extends AbstractStructBase
{
    /**
     * The persoonsObject
     * Meta informations extracted from the WSDL
     * - documentation: Persoonsgegevens van de aan te maken relatie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\PersoonsObjectV4
     */
    public $persoonsObject;
    /**
     * The bezoekAdresObject
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het aan te maken bezoekadres.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AdresObjectV4
     */
    public $bezoekAdresObject;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen relatie aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createKlantPersoonRequest
     * @uses CreateKlantPersoonRequest::setPersoonsObject()
     * @uses CreateKlantPersoonRequest::setBezoekAdresObject()
     * @uses CreateKlantPersoonRequest::setRequestTag()
     * @uses CreateKlantPersoonRequest::setCanCreate()
     * @param \StructType\PersoonsObjectV4 $persoonsObject
     * @param \StructType\AdresObjectV4 $bezoekAdresObject
     * @param string $requestTag
     * @param bool $canCreate
     */
    public function __construct(\StructType\PersoonsObjectV4 $persoonsObject = null, \StructType\AdresObjectV4 $bezoekAdresObject = null, $requestTag = null, $canCreate = null)
    {
        $this
            ->setPersoonsObject($persoonsObject)
            ->setBezoekAdresObject($bezoekAdresObject)
            ->setRequestTag($requestTag)
            ->setCanCreate($canCreate);
    }
    /**
     * Get persoonsObject value
     * @return \StructType\PersoonsObjectV4
     */
    public function getPersoonsObject()
    {
        return $this->persoonsObject;
    }
    /**
     * Set persoonsObject value
     * @param \StructType\PersoonsObjectV4 $persoonsObject
     * @return \StructType\CreateKlantPersoonRequest
     */
    public function setPersoonsObject(\StructType\PersoonsObjectV4 $persoonsObject = null)
    {
        $this->persoonsObject = $persoonsObject;
        return $this;
    }
    /**
     * Get bezoekAdresObject value
     * @return \StructType\AdresObjectV4
     */
    public function getBezoekAdresObject()
    {
        return $this->bezoekAdresObject;
    }
    /**
     * Set bezoekAdresObject value
     * @param \StructType\AdresObjectV4 $bezoekAdresObject
     * @return \StructType\CreateKlantPersoonRequest
     */
    public function setBezoekAdresObject(\StructType\AdresObjectV4 $bezoekAdresObject = null)
    {
        $this->bezoekAdresObject = $bezoekAdresObject;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateKlantPersoonRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \StructType\CreateKlantPersoonRequest
     */
    public function setCanCreate($canCreate = null)
    {
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateKlantPersoonRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
