<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createBezorgKlachtResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error1: Het abonnement is niet gevonden | error12: Er is geen abonnement opgegeven | error13: Er is geen klachtsoort opgegeven | error14: De klachtsoort is niet bekend | error15: Het klachtonderwerp is niet bekend | error17: De
 * default klachtstatus is niet gevonden | error18: Er is geen klachtsoort opgegeven | error25: Er is geen datum voor de klacht opgegeven | error77: Het klachtonderwerp is niet gekoppeld bij de klachtsoort | error78: Op basis van de klachtdatum is geen
 * editie gevonden | error79: De klachtsoort is niet actief | error80: Het klachtonderwerp is niet actief | error116: Deze klacht is niet aan een abonnement en niet aan een LVK-punt gekoppeld en kan daarom niet ingevoerd worden | error117: Uiterste
 * bezorgtijd is nog niet verstreken. Klacht is niet geregistreerd | error118: Het abonnement had op de opgegeven datum geen recht op een blad of was niet actief | error119: Het abonnement krijgt op de opgegeven datum bonnen en geen blad | error120: Het
 * abonnement werd op de opgegeven datum doorgestuurd naar een goed doel en ontving dus geen blad | error121: Het abonnement had op de opgegeven datum een vakantiestop | error122: LVK-punt was op de opgegeven datum niet meer actief | error123: LVK-punt
 * was op de opgegeven datum gesloten | error129: Datum heeft een verkeerd formaat of kan niet tot een bestaande datum worden herleid | error751: Onterechte niet bezorgd klacht. Uiterste tijdstip bezorging is niet verstreken | error752: Verzoek tot
 * nazending niet mogelijk. Verschijning is langer dan 3 dagen geleden | error753: Geen nazending mogelijk voor deze uitgave | error754: Geen nazending mogelijk voor post of ritbezorging | error755: Klacht is reeds aangemeld | error756: Onterechte niet
 * nabezorgd klacht. Er is geen niet bezorgd klacht gevonden voor de verschijning | error757: Onterechte niet nabezorgd klacht. Bij de niet bezorgd klacht is niet om nazending verzocht | error758: Onterechte niet nabezorgd klacht. Termijn voor
 * nabezorging is nog niet verstreken | error759: Onterechte niet bezorgd klacht. Op verschijningsdatum gold voor het abonnement een verzendstop
 * @subpackage Structs
 */
class CreateBezorgKlachtResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The klachtToelichting
     * Meta informations extracted from the WSDL
     * - documentation: Korte toelichting van de klacht (120 karakters). Kan door Zeno in het response aangevuld worden met een code t.b.v. het signaleren van herhaalde/erntige klachten, door bijv. de code '1HEK' toe te voegen aan de toelichting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $klachtToelichting;
    /**
     * The klachtErnstig
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de klacht als ernstige klacht aangemerkt staat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtErnstig;
    /**
     * The klachtHerhaald
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de klacht als herhaalde klacht aangemerkt staat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtHerhaald;
    /**
     * The klachtNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de aangemaakte klacht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $klachtNo;
    /**
     * The nabezorgingMogelijk
     * Meta informations extracted from the WSDL
     * - documentation: Mogelijkheden voor nabezorging. [0,1,2,3]. 0 = Vandaag nog mogelijk, 1 = Na vandaag mogelijk, 2 = Niet meer mogelijk, 3 = Niet ondersteund.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $nabezorgingMogelijk;
    /**
     * Constructor method for createBezorgKlachtResponse
     * @uses CreateBezorgKlachtResponse::setRequestTag()
     * @uses CreateBezorgKlachtResponse::setKlachtToelichting()
     * @uses CreateBezorgKlachtResponse::setKlachtErnstig()
     * @uses CreateBezorgKlachtResponse::setKlachtHerhaald()
     * @uses CreateBezorgKlachtResponse::setKlachtNo()
     * @uses CreateBezorgKlachtResponse::setNabezorgingMogelijk()
     * @param string $requestTag
     * @param string $klachtToelichting
     * @param bool $klachtErnstig
     * @param bool $klachtHerhaald
     * @param int $klachtNo
     * @param float $nabezorgingMogelijk
     */
    public function __construct($requestTag = null, $klachtToelichting = null, $klachtErnstig = null, $klachtHerhaald = null, $klachtNo = null, $nabezorgingMogelijk = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setKlachtToelichting($klachtToelichting)
            ->setKlachtErnstig($klachtErnstig)
            ->setKlachtHerhaald($klachtHerhaald)
            ->setKlachtNo($klachtNo)
            ->setNabezorgingMogelijk($nabezorgingMogelijk);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateBezorgKlachtResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get klachtToelichting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtToelichting()
    {
        return isset($this->klachtToelichting) ? $this->klachtToelichting : null;
    }
    /**
     * Set klachtToelichting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtToelichting
     * @return \StructType\CreateBezorgKlachtResponse
     */
    public function setKlachtToelichting($klachtToelichting = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtToelichting) && strlen($klachtToelichting) > 4000) || (is_array($klachtToelichting) && count($klachtToelichting) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($klachtToelichting) ? strlen($klachtToelichting) : count($klachtToelichting)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtToelichting) && !is_string($klachtToelichting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtToelichting)), __LINE__);
        }
        if (is_null($klachtToelichting) || (is_array($klachtToelichting) && empty($klachtToelichting))) {
            unset($this->klachtToelichting);
        } else {
            $this->klachtToelichting = $klachtToelichting;
        }
        return $this;
    }
    /**
     * Get klachtErnstig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtErnstig()
    {
        return isset($this->klachtErnstig) ? $this->klachtErnstig : null;
    }
    /**
     * Set klachtErnstig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtErnstig
     * @return \StructType\CreateBezorgKlachtResponse
     */
    public function setKlachtErnstig($klachtErnstig = null)
    {
        if (is_null($klachtErnstig) || (is_array($klachtErnstig) && empty($klachtErnstig))) {
            unset($this->klachtErnstig);
        } else {
            $this->klachtErnstig = $klachtErnstig;
        }
        return $this;
    }
    /**
     * Get klachtHerhaald value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtHerhaald()
    {
        return isset($this->klachtHerhaald) ? $this->klachtHerhaald : null;
    }
    /**
     * Set klachtHerhaald value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtHerhaald
     * @return \StructType\CreateBezorgKlachtResponse
     */
    public function setKlachtHerhaald($klachtHerhaald = null)
    {
        if (is_null($klachtHerhaald) || (is_array($klachtHerhaald) && empty($klachtHerhaald))) {
            unset($this->klachtHerhaald);
        } else {
            $this->klachtHerhaald = $klachtHerhaald;
        }
        return $this;
    }
    /**
     * Get klachtNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKlachtNo()
    {
        return isset($this->klachtNo) ? $this->klachtNo : null;
    }
    /**
     * Set klachtNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $klachtNo
     * @return \StructType\CreateBezorgKlachtResponse
     */
    public function setKlachtNo($klachtNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($klachtNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $klachtNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($klachtNo, strpos($klachtNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($klachtNo) && !is_numeric($klachtNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($klachtNo)), __LINE__);
        }
        if (is_null($klachtNo) || (is_array($klachtNo) && empty($klachtNo))) {
            unset($this->klachtNo);
        } else {
            $this->klachtNo = $klachtNo;
        }
        return $this;
    }
    /**
     * Get nabezorgingMogelijk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNabezorgingMogelijk()
    {
        return isset($this->nabezorgingMogelijk) ? $this->nabezorgingMogelijk : null;
    }
    /**
     * Set nabezorgingMogelijk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $nabezorgingMogelijk
     * @return \StructType\CreateBezorgKlachtResponse
     */
    public function setNabezorgingMogelijk($nabezorgingMogelijk = null)
    {
        // validation for constraint: totalDigits
        if (is_float($nabezorgingMogelijk) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $nabezorgingMogelijk)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($nabezorgingMogelijk, strpos($nabezorgingMogelijk, '.')))), __LINE__);
        }
        if (is_null($nabezorgingMogelijk) || (is_array($nabezorgingMogelijk) && empty($nabezorgingMogelijk))) {
            unset($this->nabezorgingMogelijk);
        } else {
            $this->nabezorgingMogelijk = $nabezorgingMogelijk;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateBezorgKlachtResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
