<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createBezorgKlachtRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Aanmaken van een bezorgklacht op basis van een abonnementsnummer
 * @subpackage Structs
 */
class CreateBezorgKlachtRequest extends AbstractStructBase
{
    /**
     * The klachtSoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de klachtsoort. Moet een bestaande en actieve klachtsoort zijn.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $klachtSoortCode;
    /**
     * The klachtOnderwerpCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de klachtonderwerp. Moet een bestaande en actief klachtonderwerp zijn.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $klachtOnderwerpCode;
    /**
     * The klachtDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum waarvoor de klacht geldt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $klachtDatum;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het abonnement waarover geklaagd wordt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The klachtToelichting
     * Meta informations extracted from the WSDL
     * - documentation: Korte toelichting van de klacht (120 karakters). Kan door Zeno in het response aangevuld worden met een code t.b.v. het signaleren van herhaalde/erntige klachten, door bijv. de code '1HEK' toe te voegen aan de toelichting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $klachtToelichting;
    /**
     * The klachtNabezorgen
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de krant/tijdschrift nabezorgd moet worden. Standaardwaarde false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtNabezorgen;
    /**
     * The klachtCompenseren
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de krant/tijdschrift ter compensatie verlengd moet worden. Standaardwaarde false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtCompenseren;
    /**
     * The klachtEmail
     * Meta informations extracted from the WSDL
     * - documentation: E-mail adres van de klager. Wordt bij de klacht opgeslagen; mag afwijken van het e-mail adres van de relatie die bij de klacht geregistreerd staat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 80
     * @var string
     */
    public $klachtEmail;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen bezorgklacht aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createBezorgKlachtRequest
     * @uses CreateBezorgKlachtRequest::setKlachtSoortCode()
     * @uses CreateBezorgKlachtRequest::setKlachtOnderwerpCode()
     * @uses CreateBezorgKlachtRequest::setKlachtDatum()
     * @uses CreateBezorgKlachtRequest::setRequestTag()
     * @uses CreateBezorgKlachtRequest::setAboNo()
     * @uses CreateBezorgKlachtRequest::setKlachtToelichting()
     * @uses CreateBezorgKlachtRequest::setKlachtNabezorgen()
     * @uses CreateBezorgKlachtRequest::setKlachtCompenseren()
     * @uses CreateBezorgKlachtRequest::setKlachtEmail()
     * @uses CreateBezorgKlachtRequest::setCanCreate()
     * @param string $klachtSoortCode
     * @param string $klachtOnderwerpCode
     * @param string $klachtDatum
     * @param string $requestTag
     * @param int $aboNo
     * @param string $klachtToelichting
     * @param bool $klachtNabezorgen
     * @param bool $klachtCompenseren
     * @param string $klachtEmail
     * @param bool $canCreate
     */
    public function __construct($klachtSoortCode = null, $klachtOnderwerpCode = null, $klachtDatum = null, $requestTag = null, $aboNo = null, $klachtToelichting = null, $klachtNabezorgen = null, $klachtCompenseren = null, $klachtEmail = null, $canCreate = null)
    {
        $this
            ->setKlachtSoortCode($klachtSoortCode)
            ->setKlachtOnderwerpCode($klachtOnderwerpCode)
            ->setKlachtDatum($klachtDatum)
            ->setRequestTag($requestTag)
            ->setAboNo($aboNo)
            ->setKlachtToelichting($klachtToelichting)
            ->setKlachtNabezorgen($klachtNabezorgen)
            ->setKlachtCompenseren($klachtCompenseren)
            ->setKlachtEmail($klachtEmail)
            ->setCanCreate($canCreate);
    }
    /**
     * Get klachtSoortCode value
     * @return string
     */
    public function getKlachtSoortCode()
    {
        return $this->klachtSoortCode;
    }
    /**
     * Set klachtSoortCode value
     * @param string $klachtSoortCode
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public function setKlachtSoortCode($klachtSoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtSoortCode) && strlen($klachtSoortCode) > 25) || (is_array($klachtSoortCode) && count($klachtSoortCode) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($klachtSoortCode) ? strlen($klachtSoortCode) : count($klachtSoortCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($klachtSoortCode) && strlen($klachtSoortCode) < 1) || (is_array($klachtSoortCode) && count($klachtSoortCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtSoortCode) && !is_string($klachtSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtSoortCode)), __LINE__);
        }
        $this->klachtSoortCode = $klachtSoortCode;
        return $this;
    }
    /**
     * Get klachtOnderwerpCode value
     * @return string
     */
    public function getKlachtOnderwerpCode()
    {
        return $this->klachtOnderwerpCode;
    }
    /**
     * Set klachtOnderwerpCode value
     * @param string $klachtOnderwerpCode
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public function setKlachtOnderwerpCode($klachtOnderwerpCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtOnderwerpCode) && strlen($klachtOnderwerpCode) > 25) || (is_array($klachtOnderwerpCode) && count($klachtOnderwerpCode) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($klachtOnderwerpCode) ? strlen($klachtOnderwerpCode) : count($klachtOnderwerpCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($klachtOnderwerpCode) && strlen($klachtOnderwerpCode) < 1) || (is_array($klachtOnderwerpCode) && count($klachtOnderwerpCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtOnderwerpCode) && !is_string($klachtOnderwerpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtOnderwerpCode)), __LINE__);
        }
        $this->klachtOnderwerpCode = $klachtOnderwerpCode;
        return $this;
    }
    /**
     * Get klachtDatum value
     * @return string
     */
    public function getKlachtDatum()
    {
        return $this->klachtDatum;
    }
    /**
     * Set klachtDatum value
     * @param string $klachtDatum
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public function setKlachtDatum($klachtDatum = null)
    {
        // validation for constraint: string
        if (!is_null($klachtDatum) && !is_string($klachtDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtDatum)), __LINE__);
        }
        $this->klachtDatum = $klachtDatum;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get klachtToelichting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtToelichting()
    {
        return isset($this->klachtToelichting) ? $this->klachtToelichting : null;
    }
    /**
     * Set klachtToelichting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtToelichting
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public function setKlachtToelichting($klachtToelichting = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtToelichting) && strlen($klachtToelichting) > 4000) || (is_array($klachtToelichting) && count($klachtToelichting) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($klachtToelichting) ? strlen($klachtToelichting) : count($klachtToelichting)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtToelichting) && !is_string($klachtToelichting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtToelichting)), __LINE__);
        }
        if (is_null($klachtToelichting) || (is_array($klachtToelichting) && empty($klachtToelichting))) {
            unset($this->klachtToelichting);
        } else {
            $this->klachtToelichting = $klachtToelichting;
        }
        return $this;
    }
    /**
     * Get klachtNabezorgen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtNabezorgen()
    {
        return isset($this->klachtNabezorgen) ? $this->klachtNabezorgen : null;
    }
    /**
     * Set klachtNabezorgen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtNabezorgen
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public function setKlachtNabezorgen($klachtNabezorgen = null)
    {
        if (is_null($klachtNabezorgen) || (is_array($klachtNabezorgen) && empty($klachtNabezorgen))) {
            unset($this->klachtNabezorgen);
        } else {
            $this->klachtNabezorgen = $klachtNabezorgen;
        }
        return $this;
    }
    /**
     * Get klachtCompenseren value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtCompenseren()
    {
        return isset($this->klachtCompenseren) ? $this->klachtCompenseren : null;
    }
    /**
     * Set klachtCompenseren value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtCompenseren
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public function setKlachtCompenseren($klachtCompenseren = null)
    {
        if (is_null($klachtCompenseren) || (is_array($klachtCompenseren) && empty($klachtCompenseren))) {
            unset($this->klachtCompenseren);
        } else {
            $this->klachtCompenseren = $klachtCompenseren;
        }
        return $this;
    }
    /**
     * Get klachtEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtEmail()
    {
        return isset($this->klachtEmail) ? $this->klachtEmail : null;
    }
    /**
     * Set klachtEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtEmail
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public function setKlachtEmail($klachtEmail = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtEmail) && strlen($klachtEmail) > 80) || (is_array($klachtEmail) && count($klachtEmail) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($klachtEmail) ? strlen($klachtEmail) : count($klachtEmail)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtEmail) && !is_string($klachtEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtEmail)), __LINE__);
        }
        if (is_null($klachtEmail) || (is_array($klachtEmail) && empty($klachtEmail))) {
            unset($this->klachtEmail);
        } else {
            $this->klachtEmail = $klachtEmail;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public function setCanCreate($canCreate = null)
    {
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateBezorgKlachtRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
