<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkProefaboResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error1: Controle op eerdere proefabonnementen staat niet aan. | error2: Ongeldige uitgavecode meegegeven.
 * @subpackage Structs
 */
class CheckProefaboResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: Geeft terug of er een proefabonnement gevonden is. <br /> -1 = Er geen controle op proefabonnementen actief. <br /> 0 = Geen proefabonnementen gevonden in de laatste x maanden. <br /> 1 = Een proefabonnement gevonden in de afgelopen
     * x maanden op dezelfde uitgave. <br /> 2 = Een proefabonnement gevonden in de afgelopen x maanden op een andere uitgave. <br />
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $status;
    /**
     * The aantalMaandenControle
     * Meta informations extracted from the WSDL
     * - documentation: Aantal maanden dat ingesteld is in Zeno waarop een relatie geen proefabonnement mag hebben.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aantalMaandenControle;
    /**
     * The aantalMaandenProefabo
     * Meta informations extracted from the WSDL
     * - documentation: Aantal maanden dat een relatie met de opgegeven gegevens voor het laatst een proefabonnement heeft gehad.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aantalMaandenProefabo;
    /**
     * The uitgaveProefabo
     * Meta informations extracted from the WSDL
     * - documentation: De uitgave waar een relatie met de opgegeven gegevens voor het laatst een proefabonnement op heeft gehad (kan afwijken van de opgegeven uitgave indien in Zeno de controle over uitgaven heen aan staat).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $uitgaveProefabo;
    /**
     * Constructor method for checkProefaboResponse
     * @uses CheckProefaboResponse::setRequestTag()
     * @uses CheckProefaboResponse::setStatus()
     * @uses CheckProefaboResponse::setAantalMaandenControle()
     * @uses CheckProefaboResponse::setAantalMaandenProefabo()
     * @uses CheckProefaboResponse::setUitgaveProefabo()
     * @param string $requestTag
     * @param float $status
     * @param float $aantalMaandenControle
     * @param float $aantalMaandenProefabo
     * @param string $uitgaveProefabo
     */
    public function __construct($requestTag = null, $status = null, $aantalMaandenControle = null, $aantalMaandenProefabo = null, $uitgaveProefabo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setStatus($status)
            ->setAantalMaandenControle($aantalMaandenControle)
            ->setAantalMaandenProefabo($aantalMaandenProefabo)
            ->setUitgaveProefabo($uitgaveProefabo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CheckProefaboResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $status
     * @return \StructType\CheckProefaboResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: totalDigits
        if (is_float($status) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $status)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($status, strpos($status, '.')))), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get aantalMaandenControle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAantalMaandenControle()
    {
        return isset($this->aantalMaandenControle) ? $this->aantalMaandenControle : null;
    }
    /**
     * Set aantalMaandenControle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aantalMaandenControle
     * @return \StructType\CheckProefaboResponse
     */
    public function setAantalMaandenControle($aantalMaandenControle = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aantalMaandenControle) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aantalMaandenControle)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($aantalMaandenControle, strpos($aantalMaandenControle, '.')))), __LINE__);
        }
        if (is_null($aantalMaandenControle) || (is_array($aantalMaandenControle) && empty($aantalMaandenControle))) {
            unset($this->aantalMaandenControle);
        } else {
            $this->aantalMaandenControle = $aantalMaandenControle;
        }
        return $this;
    }
    /**
     * Get aantalMaandenProefabo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAantalMaandenProefabo()
    {
        return isset($this->aantalMaandenProefabo) ? $this->aantalMaandenProefabo : null;
    }
    /**
     * Set aantalMaandenProefabo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aantalMaandenProefabo
     * @return \StructType\CheckProefaboResponse
     */
    public function setAantalMaandenProefabo($aantalMaandenProefabo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aantalMaandenProefabo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aantalMaandenProefabo)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($aantalMaandenProefabo, strpos($aantalMaandenProefabo, '.')))), __LINE__);
        }
        if (is_null($aantalMaandenProefabo) || (is_array($aantalMaandenProefabo) && empty($aantalMaandenProefabo))) {
            unset($this->aantalMaandenProefabo);
        } else {
            $this->aantalMaandenProefabo = $aantalMaandenProefabo;
        }
        return $this;
    }
    /**
     * Get uitgaveProefabo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveProefabo()
    {
        return isset($this->uitgaveProefabo) ? $this->uitgaveProefabo : null;
    }
    /**
     * Set uitgaveProefabo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveProefabo
     * @return \StructType\CheckProefaboResponse
     */
    public function setUitgaveProefabo($uitgaveProefabo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveProefabo) && strlen($uitgaveProefabo) > 4000) || (is_array($uitgaveProefabo) && count($uitgaveProefabo) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($uitgaveProefabo) ? strlen($uitgaveProefabo) : count($uitgaveProefabo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveProefabo) && !is_string($uitgaveProefabo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveProefabo)), __LINE__);
        }
        if (is_null($uitgaveProefabo) || (is_array($uitgaveProefabo) && empty($uitgaveProefabo))) {
            unset($this->uitgaveProefabo);
        } else {
            $this->uitgaveProefabo = $uitgaveProefabo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckProefaboResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
