<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkProefaboRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Met deze webservice kan worden gecontroleerd of een relatie (obv zijn gegeven e-mail adres of postcode/huisnummer/toevoeging combinatie) al een proefabonnement heeft gehad dat gestart is binnen de afgelopen x maanden. Deze periode is
 * op te geven in de Zeno constantenkaart.
 * @subpackage Structs
 */
class CheckProefaboRequest extends AbstractStructBase
{
    /**
     * The uitgave
     * Meta informations extracted from the WSDL
     * - documentation: Code van de uitgave.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $uitgave;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The emailAdres
     * Meta informations extracted from the WSDL
     * - documentation: E-mail adres.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 80
     * @var string
     */
    public $emailAdres;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - documentation: Postcode.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $postcode;
    /**
     * The huisnummer
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $huisnummer;
    /**
     * The huisnummerToevoeging
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer toevinging.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $huisnummerToevoeging;
    /**
     * Constructor method for checkProefaboRequest
     * @uses CheckProefaboRequest::setUitgave()
     * @uses CheckProefaboRequest::setRequestTag()
     * @uses CheckProefaboRequest::setEmailAdres()
     * @uses CheckProefaboRequest::setPostcode()
     * @uses CheckProefaboRequest::setHuisnummer()
     * @uses CheckProefaboRequest::setHuisnummerToevoeging()
     * @param string $uitgave
     * @param string $requestTag
     * @param string $emailAdres
     * @param string $postcode
     * @param float $huisnummer
     * @param string $huisnummerToevoeging
     */
    public function __construct($uitgave = null, $requestTag = null, $emailAdres = null, $postcode = null, $huisnummer = null, $huisnummerToevoeging = null)
    {
        $this
            ->setUitgave($uitgave)
            ->setRequestTag($requestTag)
            ->setEmailAdres($emailAdres)
            ->setPostcode($postcode)
            ->setHuisnummer($huisnummer)
            ->setHuisnummerToevoeging($huisnummerToevoeging);
    }
    /**
     * Get uitgave value
     * @return string
     */
    public function getUitgave()
    {
        return $this->uitgave;
    }
    /**
     * Set uitgave value
     * @param string $uitgave
     * @return \StructType\CheckProefaboRequest
     */
    public function setUitgave($uitgave = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgave) && strlen($uitgave) > 12) || (is_array($uitgave) && count($uitgave) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($uitgave) ? strlen($uitgave) : count($uitgave)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($uitgave) && strlen($uitgave) < 1) || (is_array($uitgave) && count($uitgave) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgave) && !is_string($uitgave)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgave)), __LINE__);
        }
        $this->uitgave = $uitgave;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CheckProefaboRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get emailAdres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAdres()
    {
        return isset($this->emailAdres) ? $this->emailAdres : null;
    }
    /**
     * Set emailAdres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAdres
     * @return \StructType\CheckProefaboRequest
     */
    public function setEmailAdres($emailAdres = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAdres) && strlen($emailAdres) > 80) || (is_array($emailAdres) && count($emailAdres) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($emailAdres) ? strlen($emailAdres) : count($emailAdres)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAdres) && !is_string($emailAdres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAdres)), __LINE__);
        }
        if (is_null($emailAdres) || (is_array($emailAdres) && empty($emailAdres))) {
            unset($this->emailAdres);
        } else {
            $this->emailAdres = $emailAdres;
        }
        return $this;
    }
    /**
     * Get postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->postcode) ? $this->postcode : null;
    }
    /**
     * Set postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\CheckProefaboRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postcode) && strlen($postcode) > 10) || (is_array($postcode) && count($postcode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($postcode) ? strlen($postcode) : count($postcode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->postcode);
        } else {
            $this->postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get huisnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHuisnummer()
    {
        return isset($this->huisnummer) ? $this->huisnummer : null;
    }
    /**
     * Set huisnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $huisnummer
     * @return \StructType\CheckProefaboRequest
     */
    public function setHuisnummer($huisnummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($huisnummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $huisnummer)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($huisnummer, strpos($huisnummer, '.')))), __LINE__);
        }
        if (is_null($huisnummer) || (is_array($huisnummer) && empty($huisnummer))) {
            unset($this->huisnummer);
        } else {
            $this->huisnummer = $huisnummer;
        }
        return $this;
    }
    /**
     * Get huisnummerToevoeging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisnummerToevoeging()
    {
        return isset($this->huisnummerToevoeging) ? $this->huisnummerToevoeging : null;
    }
    /**
     * Set huisnummerToevoeging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisnummerToevoeging
     * @return \StructType\CheckProefaboRequest
     */
    public function setHuisnummerToevoeging($huisnummerToevoeging = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($huisnummerToevoeging) && strlen($huisnummerToevoeging) > 12) || (is_array($huisnummerToevoeging) && count($huisnummerToevoeging) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($huisnummerToevoeging) ? strlen($huisnummerToevoeging) : count($huisnummerToevoeging)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($huisnummerToevoeging) && !is_string($huisnummerToevoeging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($huisnummerToevoeging)), __LINE__);
        }
        if (is_null($huisnummerToevoeging) || (is_array($huisnummerToevoeging) && empty($huisnummerToevoeging))) {
            unset($this->huisnummerToevoeging);
        } else {
            $this->huisnummerToevoeging = $huisnummerToevoeging;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckProefaboRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
