<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelBezorgKlachtRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Annuleert een bezorg klacht als de abonnee vindt dat het bij nader inzien een onterechte klacht is. Of annulering van een bezorgklacht nog is toegestaan wordt aangegeven door het element canCancel in het type KlachtV4. Als een klacht
 * bijvoorbeeld al is afgehandeld kan deze niet meer worden geannuleerd, actie is dan namelijk al ondernomen.
 * @subpackage Structs
 */
class CancelBezorgKlachtRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer bij de te annuleren bezorgklacht.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The klachtNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de te annuleren bezorgklacht.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $klachtNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The canCancel
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen echte annulering uitgevoerd) false (Default) = uit, true = aan.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCancel;
    /**
     * Constructor method for cancelBezorgKlachtRequest
     * @uses CancelBezorgKlachtRequest::setRelNo()
     * @uses CancelBezorgKlachtRequest::setKlachtNo()
     * @uses CancelBezorgKlachtRequest::setRequestTag()
     * @uses CancelBezorgKlachtRequest::setCanCancel()
     * @param int $relNo
     * @param int $klachtNo
     * @param string $requestTag
     * @param bool $canCancel
     */
    public function __construct($relNo = null, $klachtNo = null, $requestTag = null, $canCancel = null)
    {
        $this
            ->setRelNo($relNo)
            ->setKlachtNo($klachtNo)
            ->setRequestTag($requestTag)
            ->setCanCancel($canCancel);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \StructType\CancelBezorgKlachtRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get klachtNo value
     * @return int
     */
    public function getKlachtNo()
    {
        return $this->klachtNo;
    }
    /**
     * Set klachtNo value
     * @param int $klachtNo
     * @return \StructType\CancelBezorgKlachtRequest
     */
    public function setKlachtNo($klachtNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($klachtNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $klachtNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($klachtNo, strpos($klachtNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($klachtNo) && !is_numeric($klachtNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($klachtNo)), __LINE__);
        }
        $this->klachtNo = $klachtNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CancelBezorgKlachtRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get canCancel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCancel()
    {
        return isset($this->canCancel) ? $this->canCancel : null;
    }
    /**
     * Set canCancel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCancel
     * @return \StructType\CancelBezorgKlachtRequest
     */
    public function setCanCancel($canCancel = null)
    {
        if (is_null($canCancel) || (is_array($canCancel) && empty($canCancel))) {
            unset($this->canCancel);
        } else {
            $this->canCancel = $canCancel;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelBezorgKlachtRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
