<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addLicentiehouderRolRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Toevoegen van een rol aan een licentiehouder van een abonnement.
 * @subpackage Structs
 */
class AddLicentiehouderRolRequest extends AbstractStructBase
{
    /**
     * The licentieNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de licentie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $licentieNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The rolOmschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de rol. Rol moet een bestaande rol bij de uitgave rollen zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $rolOmschrijving;
    /**
     * Constructor method for addLicentiehouderRolRequest
     * @uses AddLicentiehouderRolRequest::setLicentieNo()
     * @uses AddLicentiehouderRolRequest::setRequestTag()
     * @uses AddLicentiehouderRolRequest::setRolOmschrijving()
     * @param int $licentieNo
     * @param string $requestTag
     * @param string $rolOmschrijving
     */
    public function __construct($licentieNo = null, $requestTag = null, $rolOmschrijving = null)
    {
        $this
            ->setLicentieNo($licentieNo)
            ->setRequestTag($requestTag)
            ->setRolOmschrijving($rolOmschrijving);
    }
    /**
     * Get licentieNo value
     * @return int
     */
    public function getLicentieNo()
    {
        return $this->licentieNo;
    }
    /**
     * Set licentieNo value
     * @param int $licentieNo
     * @return \StructType\AddLicentiehouderRolRequest
     */
    public function setLicentieNo($licentieNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($licentieNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $licentieNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($licentieNo, strpos($licentieNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($licentieNo) && !is_numeric($licentieNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($licentieNo)), __LINE__);
        }
        $this->licentieNo = $licentieNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\AddLicentiehouderRolRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get rolOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRolOmschrijving()
    {
        return isset($this->rolOmschrijving) ? $this->rolOmschrijving : null;
    }
    /**
     * Set rolOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rolOmschrijving
     * @return \StructType\AddLicentiehouderRolRequest
     */
    public function setRolOmschrijving($rolOmschrijving = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rolOmschrijving) && strlen($rolOmschrijving) > 120) || (is_array($rolOmschrijving) && count($rolOmschrijving) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($rolOmschrijving) ? strlen($rolOmschrijving) : count($rolOmschrijving)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rolOmschrijving) && !is_string($rolOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rolOmschrijving)), __LINE__);
        }
        if (is_null($rolOmschrijving) || (is_array($rolOmschrijving) && empty($rolOmschrijving))) {
            unset($this->rolOmschrijving);
        } else {
            $this->rolOmschrijving = $rolOmschrijving;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddLicentiehouderRolRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
