<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbonnementInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst relaties met gevonden abonnementen.
 * @subpackage Structs
 */
class AbonnementInfoV4 extends AbstractStructBase
{
    /**
     * The aboRelatie
     * Meta informations extracted from the WSDL
     * - documentation: Lijst relaties met gevonden abonnementen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AboRelatieV4[]
     */
    public $aboRelatie;
    /**
     * Constructor method for AbonnementInfoV4
     * @uses AbonnementInfoV4::setAboRelatie()
     * @param \StructType\AboRelatieV4[] $aboRelatie
     */
    public function __construct(array $aboRelatie = array())
    {
        $this
            ->setAboRelatie($aboRelatie);
    }
    /**
     * Get aboRelatie value
     * @return \StructType\AboRelatieV4[]|null
     */
    public function getAboRelatie()
    {
        return $this->aboRelatie;
    }
    /**
     * Set aboRelatie value
     * @throws \InvalidArgumentException
     * @param \StructType\AboRelatieV4[] $aboRelatie
     * @return \StructType\AbonnementInfoV4
     */
    public function setAboRelatie(array $aboRelatie = array())
    {
        foreach ($aboRelatie as $abonnementInfoV4AboRelatieItem) {
            // validation for constraint: itemType
            if (!$abonnementInfoV4AboRelatieItem instanceof \StructType\AboRelatieV4) {
                throw new \InvalidArgumentException(sprintf('The aboRelatie property can only contain items of \StructType\AboRelatieV4, "%s" given', is_object($abonnementInfoV4AboRelatieItem) ? get_class($abonnementInfoV4AboRelatieItem) : gettype($abonnementInfoV4AboRelatieItem)), __LINE__);
            }
        }
        $this->aboRelatie = $aboRelatie;
        return $this;
    }
    /**
     * Add item to aboRelatie value
     * @throws \InvalidArgumentException
     * @param \StructType\AboRelatieV4 $item
     * @return \StructType\AbonnementInfoV4
     */
    public function addToAboRelatie(\StructType\AboRelatieV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AboRelatieV4) {
            throw new \InvalidArgumentException(sprintf('The aboRelatie property can only contain items of \StructType\AboRelatieV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->aboRelatie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbonnementInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
