<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboRelatieV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Relatie informatie
 * @subpackage Structs
 */
class AboRelatieV4 extends AbstractStructBase
{
    /**
     * The aanhef
     * Meta informations extracted from the WSDL
     * - documentation: Aanhef via de standaard functionaliteit van Zeno.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $aanhef;
    /**
     * The achternaam
     * Meta informations extracted from the WSDL
     * - documentation: Achternaam van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $achternaam;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - documentation: E-mail adres van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 80
     * @var string
     */
    public $email;
    /**
     * The geboorteDatum
     * Meta informations extracted from the WSDL
     * - documentation: Geboortedatum van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $geboorteDatum;
    /**
     * The geslachtsIndicatie
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2,3] Indicatie geslacht: 0 = nvt, 1 = Man, 2 = Vrouw, 3 = Onbekend.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 1
     * @var int
     */
    public $geslachtsIndicatie;
    /**
     * The huisNummer
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer van het adres van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $huisNummer;
    /**
     * The huisNummerToev
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer toevoeging van het adres van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $huisNummerToev;
    /**
     * The landCode
     * Meta informations extracted from the WSDL
     * - documentation: Landcode van het land van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 3
     * @var string
     */
    public $landCode;
    /**
     * The plaats
     * Meta informations extracted from the WSDL
     * - documentation: Woonplaats van het adres van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 40
     * @var string
     */
    public $plaats;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - documentation: Postcode van het adres van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $postcode;
    /**
     * The provincieCode
     * Meta informations extracted from the WSDL
     * - documentation: Provinciecode van de provincie van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $provincieCode;
    /**
     * The relNoAbo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoAbo;
    /**
     * The straat
     * Meta informations extracted from the WSDL
     * - documentation: Straat van het adres van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $straat;
    /**
     * The telefoonNummer
     * Meta informations extracted from the WSDL
     * - documentation: Telefoonnummer van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 80
     * @var string
     */
    public $telefoonNummer;
    /**
     * The telefoonNummerMobiel
     * Meta informations extracted from the WSDL
     * - documentation: Mobiel telefoonnummer van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 80
     * @var string
     */
    public $telefoonNummerMobiel;
    /**
     * The titulatuurCode
     * Meta informations extracted from the WSDL
     * - documentation: Titutatuur voor de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 25
     * @var string
     */
    public $titulatuurCode;
    /**
     * The tussenvoegsel
     * Meta informations extracted from the WSDL
     * - documentation: Tussenvoegsel van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $tussenvoegsel;
    /**
     * The voorletters
     * Meta informations extracted from the WSDL
     * - documentation: Voorletters van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $voorletters;
    /**
     * The voornaam
     * Meta informations extracted from the WSDL
     * - documentation: Voornaam van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $voornaam;
    /**
     * The rekeningNummer
     * Meta informations extracted from the WSDL
     * - documentation: Bankrekeningnummer van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $rekeningNummer;
    /**
     * The rekeningIbanNummer
     * Meta informations extracted from the WSDL
     * - documentation: IBAN van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $rekeningIbanNummer;
    /**
     * The rekeningBicCode
     * Meta informations extracted from the WSDL
     * - documentation: BIC van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $rekeningBicCode;
    /**
     * The btwNummer
     * Meta informations extracted from the WSDL
     * - documentation: BTW nummer van de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $btwNummer;
    /**
     * The bedrijfsNaam
     * Meta informations extracted from the WSDL
     * - documentation: Bedrijfsnaam.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $bedrijfsNaam;
    /**
     * The aboAbonnementen
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsgegevens: N.B. standaard worden alleen actieve of toekomstige abonnementen opgehaald. Abonnementen die afgesloten zijn worden door deze service teruggegeven afhankelijk van de instelling toonHistorie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AbonnementTabV4
     */
    public $aboAbonnementen;
    /**
     * Constructor method for AboRelatieV4
     * @uses AboRelatieV4::setAanhef()
     * @uses AboRelatieV4::setAchternaam()
     * @uses AboRelatieV4::setEmail()
     * @uses AboRelatieV4::setGeboorteDatum()
     * @uses AboRelatieV4::setGeslachtsIndicatie()
     * @uses AboRelatieV4::setHuisNummer()
     * @uses AboRelatieV4::setHuisNummerToev()
     * @uses AboRelatieV4::setLandCode()
     * @uses AboRelatieV4::setPlaats()
     * @uses AboRelatieV4::setPostcode()
     * @uses AboRelatieV4::setProvincieCode()
     * @uses AboRelatieV4::setRelNoAbo()
     * @uses AboRelatieV4::setStraat()
     * @uses AboRelatieV4::setTelefoonNummer()
     * @uses AboRelatieV4::setTelefoonNummerMobiel()
     * @uses AboRelatieV4::setTitulatuurCode()
     * @uses AboRelatieV4::setTussenvoegsel()
     * @uses AboRelatieV4::setVoorletters()
     * @uses AboRelatieV4::setVoornaam()
     * @uses AboRelatieV4::setRekeningNummer()
     * @uses AboRelatieV4::setRekeningIbanNummer()
     * @uses AboRelatieV4::setRekeningBicCode()
     * @uses AboRelatieV4::setBtwNummer()
     * @uses AboRelatieV4::setBedrijfsNaam()
     * @uses AboRelatieV4::setAboAbonnementen()
     * @param string $aanhef
     * @param string $achternaam
     * @param string $email
     * @param string $geboorteDatum
     * @param int $geslachtsIndicatie
     * @param int $huisNummer
     * @param string $huisNummerToev
     * @param string $landCode
     * @param string $plaats
     * @param string $postcode
     * @param string $provincieCode
     * @param int $relNoAbo
     * @param string $straat
     * @param string $telefoonNummer
     * @param string $telefoonNummerMobiel
     * @param string $titulatuurCode
     * @param string $tussenvoegsel
     * @param string $voorletters
     * @param string $voornaam
     * @param string $rekeningNummer
     * @param string $rekeningIbanNummer
     * @param string $rekeningBicCode
     * @param string $btwNummer
     * @param string $bedrijfsNaam
     * @param \StructType\AbonnementTabV4 $aboAbonnementen
     */
    public function __construct($aanhef = null, $achternaam = null, $email = null, $geboorteDatum = null, $geslachtsIndicatie = null, $huisNummer = null, $huisNummerToev = null, $landCode = null, $plaats = null, $postcode = null, $provincieCode = null, $relNoAbo = null, $straat = null, $telefoonNummer = null, $telefoonNummerMobiel = null, $titulatuurCode = null, $tussenvoegsel = null, $voorletters = null, $voornaam = null, $rekeningNummer = null, $rekeningIbanNummer = null, $rekeningBicCode = null, $btwNummer = null, $bedrijfsNaam = null, \StructType\AbonnementTabV4 $aboAbonnementen = null)
    {
        $this
            ->setAanhef($aanhef)
            ->setAchternaam($achternaam)
            ->setEmail($email)
            ->setGeboorteDatum($geboorteDatum)
            ->setGeslachtsIndicatie($geslachtsIndicatie)
            ->setHuisNummer($huisNummer)
            ->setHuisNummerToev($huisNummerToev)
            ->setLandCode($landCode)
            ->setPlaats($plaats)
            ->setPostcode($postcode)
            ->setProvincieCode($provincieCode)
            ->setRelNoAbo($relNoAbo)
            ->setStraat($straat)
            ->setTelefoonNummer($telefoonNummer)
            ->setTelefoonNummerMobiel($telefoonNummerMobiel)
            ->setTitulatuurCode($titulatuurCode)
            ->setTussenvoegsel($tussenvoegsel)
            ->setVoorletters($voorletters)
            ->setVoornaam($voornaam)
            ->setRekeningNummer($rekeningNummer)
            ->setRekeningIbanNummer($rekeningIbanNummer)
            ->setRekeningBicCode($rekeningBicCode)
            ->setBtwNummer($btwNummer)
            ->setBedrijfsNaam($bedrijfsNaam)
            ->setAboAbonnementen($aboAbonnementen);
    }
    /**
     * Get aanhef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAanhef()
    {
        return isset($this->aanhef) ? $this->aanhef : null;
    }
    /**
     * Set aanhef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aanhef
     * @return \StructType\AboRelatieV4
     */
    public function setAanhef($aanhef = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aanhef) && strlen($aanhef) > 120) || (is_array($aanhef) && count($aanhef) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($aanhef) ? strlen($aanhef) : count($aanhef)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aanhef) && !is_string($aanhef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aanhef)), __LINE__);
        }
        if (is_null($aanhef) || (is_array($aanhef) && empty($aanhef))) {
            unset($this->aanhef);
        } else {
            $this->aanhef = $aanhef;
        }
        return $this;
    }
    /**
     * Get achternaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAchternaam()
    {
        return isset($this->achternaam) ? $this->achternaam : null;
    }
    /**
     * Set achternaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $achternaam
     * @return \StructType\AboRelatieV4
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($achternaam) && strlen($achternaam) > 120) || (is_array($achternaam) && count($achternaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($achternaam) ? strlen($achternaam) : count($achternaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($achternaam)), __LINE__);
        }
        if (is_null($achternaam) || (is_array($achternaam) && empty($achternaam))) {
            unset($this->achternaam);
        } else {
            $this->achternaam = $achternaam;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\AboRelatieV4
     */
    public function setEmail($email = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($email) && strlen($email) > 80) || (is_array($email) && count($email) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($email) ? strlen($email) : count($email)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get geboorteDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeboorteDatum()
    {
        return isset($this->geboorteDatum) ? $this->geboorteDatum : null;
    }
    /**
     * Set geboorteDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geboorteDatum
     * @return \StructType\AboRelatieV4
     */
    public function setGeboorteDatum($geboorteDatum = null)
    {
        // validation for constraint: string
        if (!is_null($geboorteDatum) && !is_string($geboorteDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geboorteDatum)), __LINE__);
        }
        if (is_null($geboorteDatum) || (is_array($geboorteDatum) && empty($geboorteDatum))) {
            unset($this->geboorteDatum);
        } else {
            $this->geboorteDatum = $geboorteDatum;
        }
        return $this;
    }
    /**
     * Get geslachtsIndicatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGeslachtsIndicatie()
    {
        return isset($this->geslachtsIndicatie) ? $this->geslachtsIndicatie : null;
    }
    /**
     * Set geslachtsIndicatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $geslachtsIndicatie
     * @return \StructType\AboRelatieV4
     */
    public function setGeslachtsIndicatie($geslachtsIndicatie = null)
    {
        // validation for constraint: totalDigits
        if (is_float($geslachtsIndicatie) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $geslachtsIndicatie)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($geslachtsIndicatie, strpos($geslachtsIndicatie, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($geslachtsIndicatie) && !is_numeric($geslachtsIndicatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($geslachtsIndicatie)), __LINE__);
        }
        if (is_null($geslachtsIndicatie) || (is_array($geslachtsIndicatie) && empty($geslachtsIndicatie))) {
            unset($this->geslachtsIndicatie);
        } else {
            $this->geslachtsIndicatie = $geslachtsIndicatie;
        }
        return $this;
    }
    /**
     * Get huisNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHuisNummer()
    {
        return isset($this->huisNummer) ? $this->huisNummer : null;
    }
    /**
     * Set huisNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $huisNummer
     * @return \StructType\AboRelatieV4
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($huisNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $huisNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($huisNummer, strpos($huisNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($huisNummer) && !is_numeric($huisNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($huisNummer)), __LINE__);
        }
        if (is_null($huisNummer) || (is_array($huisNummer) && empty($huisNummer))) {
            unset($this->huisNummer);
        } else {
            $this->huisNummer = $huisNummer;
        }
        return $this;
    }
    /**
     * Get huisNummerToev value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisNummerToev()
    {
        return isset($this->huisNummerToev) ? $this->huisNummerToev : null;
    }
    /**
     * Set huisNummerToev value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisNummerToev
     * @return \StructType\AboRelatieV4
     */
    public function setHuisNummerToev($huisNummerToev = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($huisNummerToev) && strlen($huisNummerToev) > 20) || (is_array($huisNummerToev) && count($huisNummerToev) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($huisNummerToev) ? strlen($huisNummerToev) : count($huisNummerToev)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($huisNummerToev) && !is_string($huisNummerToev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($huisNummerToev)), __LINE__);
        }
        if (is_null($huisNummerToev) || (is_array($huisNummerToev) && empty($huisNummerToev))) {
            unset($this->huisNummerToev);
        } else {
            $this->huisNummerToev = $huisNummerToev;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \StructType\AboRelatieV4
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($landCode) && strlen($landCode) > 3) || (is_array($landCode) && count($landCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($landCode) ? strlen($landCode) : count($landCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
    /**
     * Get plaats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaats()
    {
        return isset($this->plaats) ? $this->plaats : null;
    }
    /**
     * Set plaats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plaats
     * @return \StructType\AboRelatieV4
     */
    public function setPlaats($plaats = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($plaats) && strlen($plaats) > 40) || (is_array($plaats) && count($plaats) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($plaats) ? strlen($plaats) : count($plaats)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($plaats) && !is_string($plaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plaats)), __LINE__);
        }
        if (is_null($plaats) || (is_array($plaats) && empty($plaats))) {
            unset($this->plaats);
        } else {
            $this->plaats = $plaats;
        }
        return $this;
    }
    /**
     * Get postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->postcode) ? $this->postcode : null;
    }
    /**
     * Set postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\AboRelatieV4
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postcode) && strlen($postcode) > 15) || (is_array($postcode) && count($postcode) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($postcode) ? strlen($postcode) : count($postcode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->postcode);
        } else {
            $this->postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get provincieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvincieCode()
    {
        return isset($this->provincieCode) ? $this->provincieCode : null;
    }
    /**
     * Set provincieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provincieCode
     * @return \StructType\AboRelatieV4
     */
    public function setProvincieCode($provincieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($provincieCode) && strlen($provincieCode) > 20) || (is_array($provincieCode) && count($provincieCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($provincieCode) ? strlen($provincieCode) : count($provincieCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($provincieCode) && !is_string($provincieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provincieCode)), __LINE__);
        }
        if (is_null($provincieCode) || (is_array($provincieCode) && empty($provincieCode))) {
            unset($this->provincieCode);
        } else {
            $this->provincieCode = $provincieCode;
        }
        return $this;
    }
    /**
     * Get relNoAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoAbo()
    {
        return isset($this->relNoAbo) ? $this->relNoAbo : null;
    }
    /**
     * Set relNoAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoAbo
     * @return \StructType\AboRelatieV4
     */
    public function setRelNoAbo($relNoAbo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoAbo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoAbo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoAbo, strpos($relNoAbo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoAbo) && !is_numeric($relNoAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoAbo)), __LINE__);
        }
        if (is_null($relNoAbo) || (is_array($relNoAbo) && empty($relNoAbo))) {
            unset($this->relNoAbo);
        } else {
            $this->relNoAbo = $relNoAbo;
        }
        return $this;
    }
    /**
     * Get straat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStraat()
    {
        return isset($this->straat) ? $this->straat : null;
    }
    /**
     * Set straat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $straat
     * @return \StructType\AboRelatieV4
     */
    public function setStraat($straat = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($straat) && strlen($straat) > 120) || (is_array($straat) && count($straat) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($straat) ? strlen($straat) : count($straat)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($straat) && !is_string($straat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($straat)), __LINE__);
        }
        if (is_null($straat) || (is_array($straat) && empty($straat))) {
            unset($this->straat);
        } else {
            $this->straat = $straat;
        }
        return $this;
    }
    /**
     * Get telefoonNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonNummer()
    {
        return isset($this->telefoonNummer) ? $this->telefoonNummer : null;
    }
    /**
     * Set telefoonNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonNummer
     * @return \StructType\AboRelatieV4
     */
    public function setTelefoonNummer($telefoonNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telefoonNummer) && strlen($telefoonNummer) > 80) || (is_array($telefoonNummer) && count($telefoonNummer) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($telefoonNummer) ? strlen($telefoonNummer) : count($telefoonNummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telefoonNummer) && !is_string($telefoonNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefoonNummer)), __LINE__);
        }
        if (is_null($telefoonNummer) || (is_array($telefoonNummer) && empty($telefoonNummer))) {
            unset($this->telefoonNummer);
        } else {
            $this->telefoonNummer = $telefoonNummer;
        }
        return $this;
    }
    /**
     * Get telefoonNummerMobiel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonNummerMobiel()
    {
        return isset($this->telefoonNummerMobiel) ? $this->telefoonNummerMobiel : null;
    }
    /**
     * Set telefoonNummerMobiel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonNummerMobiel
     * @return \StructType\AboRelatieV4
     */
    public function setTelefoonNummerMobiel($telefoonNummerMobiel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telefoonNummerMobiel) && strlen($telefoonNummerMobiel) > 80) || (is_array($telefoonNummerMobiel) && count($telefoonNummerMobiel) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($telefoonNummerMobiel) ? strlen($telefoonNummerMobiel) : count($telefoonNummerMobiel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telefoonNummerMobiel) && !is_string($telefoonNummerMobiel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefoonNummerMobiel)), __LINE__);
        }
        if (is_null($telefoonNummerMobiel) || (is_array($telefoonNummerMobiel) && empty($telefoonNummerMobiel))) {
            unset($this->telefoonNummerMobiel);
        } else {
            $this->telefoonNummerMobiel = $telefoonNummerMobiel;
        }
        return $this;
    }
    /**
     * Get titulatuurCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitulatuurCode()
    {
        return isset($this->titulatuurCode) ? $this->titulatuurCode : null;
    }
    /**
     * Set titulatuurCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titulatuurCode
     * @return \StructType\AboRelatieV4
     */
    public function setTitulatuurCode($titulatuurCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($titulatuurCode) && strlen($titulatuurCode) > 25) || (is_array($titulatuurCode) && count($titulatuurCode) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($titulatuurCode) ? strlen($titulatuurCode) : count($titulatuurCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($titulatuurCode) && !is_string($titulatuurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titulatuurCode)), __LINE__);
        }
        if (is_null($titulatuurCode) || (is_array($titulatuurCode) && empty($titulatuurCode))) {
            unset($this->titulatuurCode);
        } else {
            $this->titulatuurCode = $titulatuurCode;
        }
        return $this;
    }
    /**
     * Get tussenvoegsel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTussenvoegsel()
    {
        return isset($this->tussenvoegsel) ? $this->tussenvoegsel : null;
    }
    /**
     * Set tussenvoegsel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tussenvoegsel
     * @return \StructType\AboRelatieV4
     */
    public function setTussenvoegsel($tussenvoegsel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tussenvoegsel) && strlen($tussenvoegsel) > 15) || (is_array($tussenvoegsel) && count($tussenvoegsel) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($tussenvoegsel) ? strlen($tussenvoegsel) : count($tussenvoegsel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tussenvoegsel) && !is_string($tussenvoegsel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tussenvoegsel)), __LINE__);
        }
        if (is_null($tussenvoegsel) || (is_array($tussenvoegsel) && empty($tussenvoegsel))) {
            unset($this->tussenvoegsel);
        } else {
            $this->tussenvoegsel = $tussenvoegsel;
        }
        return $this;
    }
    /**
     * Get voorletters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorletters()
    {
        return isset($this->voorletters) ? $this->voorletters : null;
    }
    /**
     * Set voorletters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorletters
     * @return \StructType\AboRelatieV4
     */
    public function setVoorletters($voorletters = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($voorletters) && strlen($voorletters) > 30) || (is_array($voorletters) && count($voorletters) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($voorletters) ? strlen($voorletters) : count($voorletters)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($voorletters) && !is_string($voorletters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voorletters)), __LINE__);
        }
        if (is_null($voorletters) || (is_array($voorletters) && empty($voorletters))) {
            unset($this->voorletters);
        } else {
            $this->voorletters = $voorletters;
        }
        return $this;
    }
    /**
     * Get voornaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoornaam()
    {
        return isset($this->voornaam) ? $this->voornaam : null;
    }
    /**
     * Set voornaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voornaam
     * @return \StructType\AboRelatieV4
     */
    public function setVoornaam($voornaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($voornaam) && strlen($voornaam) > 120) || (is_array($voornaam) && count($voornaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($voornaam) ? strlen($voornaam) : count($voornaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($voornaam) && !is_string($voornaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voornaam)), __LINE__);
        }
        if (is_null($voornaam) || (is_array($voornaam) && empty($voornaam))) {
            unset($this->voornaam);
        } else {
            $this->voornaam = $voornaam;
        }
        return $this;
    }
    /**
     * Get rekeningNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRekeningNummer()
    {
        return isset($this->rekeningNummer) ? $this->rekeningNummer : null;
    }
    /**
     * Set rekeningNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rekeningNummer
     * @return \StructType\AboRelatieV4
     */
    public function setRekeningNummer($rekeningNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rekeningNummer) && strlen($rekeningNummer) > 15) || (is_array($rekeningNummer) && count($rekeningNummer) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($rekeningNummer) ? strlen($rekeningNummer) : count($rekeningNummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rekeningNummer) && !is_string($rekeningNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rekeningNummer)), __LINE__);
        }
        if (is_null($rekeningNummer) || (is_array($rekeningNummer) && empty($rekeningNummer))) {
            unset($this->rekeningNummer);
        } else {
            $this->rekeningNummer = $rekeningNummer;
        }
        return $this;
    }
    /**
     * Get rekeningIbanNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRekeningIbanNummer()
    {
        return isset($this->rekeningIbanNummer) ? $this->rekeningIbanNummer : null;
    }
    /**
     * Set rekeningIbanNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rekeningIbanNummer
     * @return \StructType\AboRelatieV4
     */
    public function setRekeningIbanNummer($rekeningIbanNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rekeningIbanNummer) && strlen($rekeningIbanNummer) > 4000) || (is_array($rekeningIbanNummer) && count($rekeningIbanNummer) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($rekeningIbanNummer) ? strlen($rekeningIbanNummer) : count($rekeningIbanNummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rekeningIbanNummer) && !is_string($rekeningIbanNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rekeningIbanNummer)), __LINE__);
        }
        if (is_null($rekeningIbanNummer) || (is_array($rekeningIbanNummer) && empty($rekeningIbanNummer))) {
            unset($this->rekeningIbanNummer);
        } else {
            $this->rekeningIbanNummer = $rekeningIbanNummer;
        }
        return $this;
    }
    /**
     * Get rekeningBicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRekeningBicCode()
    {
        return isset($this->rekeningBicCode) ? $this->rekeningBicCode : null;
    }
    /**
     * Set rekeningBicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rekeningBicCode
     * @return \StructType\AboRelatieV4
     */
    public function setRekeningBicCode($rekeningBicCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rekeningBicCode) && strlen($rekeningBicCode) > 4000) || (is_array($rekeningBicCode) && count($rekeningBicCode) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($rekeningBicCode) ? strlen($rekeningBicCode) : count($rekeningBicCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rekeningBicCode) && !is_string($rekeningBicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rekeningBicCode)), __LINE__);
        }
        if (is_null($rekeningBicCode) || (is_array($rekeningBicCode) && empty($rekeningBicCode))) {
            unset($this->rekeningBicCode);
        } else {
            $this->rekeningBicCode = $rekeningBicCode;
        }
        return $this;
    }
    /**
     * Get btwNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwNummer()
    {
        return isset($this->btwNummer) ? $this->btwNummer : null;
    }
    /**
     * Set btwNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwNummer
     * @return \StructType\AboRelatieV4
     */
    public function setBtwNummer($btwNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($btwNummer) && strlen($btwNummer) > 20) || (is_array($btwNummer) && count($btwNummer) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($btwNummer) ? strlen($btwNummer) : count($btwNummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($btwNummer) && !is_string($btwNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($btwNummer)), __LINE__);
        }
        if (is_null($btwNummer) || (is_array($btwNummer) && empty($btwNummer))) {
            unset($this->btwNummer);
        } else {
            $this->btwNummer = $btwNummer;
        }
        return $this;
    }
    /**
     * Get bedrijfsNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBedrijfsNaam()
    {
        return isset($this->bedrijfsNaam) ? $this->bedrijfsNaam : null;
    }
    /**
     * Set bedrijfsNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bedrijfsNaam
     * @return \StructType\AboRelatieV4
     */
    public function setBedrijfsNaam($bedrijfsNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bedrijfsNaam) && strlen($bedrijfsNaam) > 4000) || (is_array($bedrijfsNaam) && count($bedrijfsNaam) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($bedrijfsNaam) ? strlen($bedrijfsNaam) : count($bedrijfsNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bedrijfsNaam) && !is_string($bedrijfsNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bedrijfsNaam)), __LINE__);
        }
        if (is_null($bedrijfsNaam) || (is_array($bedrijfsNaam) && empty($bedrijfsNaam))) {
            unset($this->bedrijfsNaam);
        } else {
            $this->bedrijfsNaam = $bedrijfsNaam;
        }
        return $this;
    }
    /**
     * Get aboAbonnementen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AbonnementTabV4|null
     */
    public function getAboAbonnementen()
    {
        return isset($this->aboAbonnementen) ? $this->aboAbonnementen : null;
    }
    /**
     * Set aboAbonnementen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AbonnementTabV4 $aboAbonnementen
     * @return \StructType\AboRelatieV4
     */
    public function setAboAbonnementen(\StructType\AbonnementTabV4 $aboAbonnementen = null)
    {
        if (is_null($aboAbonnementen) || (is_array($aboAbonnementen) && empty($aboAbonnementen))) {
            unset($this->aboAbonnementen);
        } else {
            $this->aboAbonnementen = $aboAbonnementen;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AboRelatieV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
