<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboPakketAboSoortV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abonnementsoort object onder dit abonnements pakket
 * @subpackage Structs
 */
class AboPakketAboSoortV4 extends AbstractStructBase
{
    /**
     * The abonnementsoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de onderliggende abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $abonnementsoortCode;
    /**
     * The abonnementsoortNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de onderliggende abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $abonnementsoortNaam;
    /**
     * The onderdeelPrijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Onderdeel prijs inclusief BTW.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $onderdeelPrijsInclBtw;
    /**
     * The onderdeelPrijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Onderdeel prijs exclusief BTW.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $onderdeelPrijsExclBtw;
    /**
     * The btwCode
     * Meta informations extracted from the WSDL
     * - documentation: BTW code.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 3
     * @var string
     */
    public $btwCode;
    /**
     * The btwOmschrijving
     * Meta informations extracted from the WSDL
     * - documentation: BTW omschrijving.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $btwOmschrijving;
    /**
     * The btwPercentage
     * Meta informations extracted from the WSDL
     * - documentation: BTW percentage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 1
     * - totalDigits: 6
     * @var float
     */
    public $btwPercentage;
    /**
     * Constructor method for AboPakketAboSoortV4
     * @uses AboPakketAboSoortV4::setAbonnementsoortCode()
     * @uses AboPakketAboSoortV4::setAbonnementsoortNaam()
     * @uses AboPakketAboSoortV4::setOnderdeelPrijsInclBtw()
     * @uses AboPakketAboSoortV4::setOnderdeelPrijsExclBtw()
     * @uses AboPakketAboSoortV4::setBtwCode()
     * @uses AboPakketAboSoortV4::setBtwOmschrijving()
     * @uses AboPakketAboSoortV4::setBtwPercentage()
     * @param string $abonnementsoortCode
     * @param string $abonnementsoortNaam
     * @param float $onderdeelPrijsInclBtw
     * @param float $onderdeelPrijsExclBtw
     * @param string $btwCode
     * @param string $btwOmschrijving
     * @param float $btwPercentage
     */
    public function __construct($abonnementsoortCode = null, $abonnementsoortNaam = null, $onderdeelPrijsInclBtw = null, $onderdeelPrijsExclBtw = null, $btwCode = null, $btwOmschrijving = null, $btwPercentage = null)
    {
        $this
            ->setAbonnementsoortCode($abonnementsoortCode)
            ->setAbonnementsoortNaam($abonnementsoortNaam)
            ->setOnderdeelPrijsInclBtw($onderdeelPrijsInclBtw)
            ->setOnderdeelPrijsExclBtw($onderdeelPrijsExclBtw)
            ->setBtwCode($btwCode)
            ->setBtwOmschrijving($btwOmschrijving)
            ->setBtwPercentage($btwPercentage);
    }
    /**
     * Get abonnementsoortCode value
     * @return string
     */
    public function getAbonnementsoortCode()
    {
        return $this->abonnementsoortCode;
    }
    /**
     * Set abonnementsoortCode value
     * @param string $abonnementsoortCode
     * @return \StructType\AboPakketAboSoortV4
     */
    public function setAbonnementsoortCode($abonnementsoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortCode) && strlen($abonnementsoortCode) > 30) || (is_array($abonnementsoortCode) && count($abonnementsoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($abonnementsoortCode) ? strlen($abonnementsoortCode) : count($abonnementsoortCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abonnementsoortCode) && strlen($abonnementsoortCode) < 1) || (is_array($abonnementsoortCode) && count($abonnementsoortCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortCode) && !is_string($abonnementsoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortCode)), __LINE__);
        }
        $this->abonnementsoortCode = $abonnementsoortCode;
        return $this;
    }
    /**
     * Get abonnementsoortNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortNaam()
    {
        return isset($this->abonnementsoortNaam) ? $this->abonnementsoortNaam : null;
    }
    /**
     * Set abonnementsoortNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortNaam
     * @return \StructType\AboPakketAboSoortV4
     */
    public function setAbonnementsoortNaam($abonnementsoortNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortNaam) && strlen($abonnementsoortNaam) > 500) || (is_array($abonnementsoortNaam) && count($abonnementsoortNaam) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($abonnementsoortNaam) ? strlen($abonnementsoortNaam) : count($abonnementsoortNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortNaam) && !is_string($abonnementsoortNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortNaam)), __LINE__);
        }
        if (is_null($abonnementsoortNaam) || (is_array($abonnementsoortNaam) && empty($abonnementsoortNaam))) {
            unset($this->abonnementsoortNaam);
        } else {
            $this->abonnementsoortNaam = $abonnementsoortNaam;
        }
        return $this;
    }
    /**
     * Get onderdeelPrijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOnderdeelPrijsInclBtw()
    {
        return isset($this->onderdeelPrijsInclBtw) ? $this->onderdeelPrijsInclBtw : null;
    }
    /**
     * Set onderdeelPrijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $onderdeelPrijsInclBtw
     * @return \StructType\AboPakketAboSoortV4
     */
    public function setOnderdeelPrijsInclBtw($onderdeelPrijsInclBtw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($onderdeelPrijsInclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $onderdeelPrijsInclBtw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($onderdeelPrijsInclBtw, strpos($onderdeelPrijsInclBtw, '.')))), __LINE__);
        }
        if (is_null($onderdeelPrijsInclBtw) || (is_array($onderdeelPrijsInclBtw) && empty($onderdeelPrijsInclBtw))) {
            unset($this->onderdeelPrijsInclBtw);
        } else {
            $this->onderdeelPrijsInclBtw = $onderdeelPrijsInclBtw;
        }
        return $this;
    }
    /**
     * Get onderdeelPrijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOnderdeelPrijsExclBtw()
    {
        return isset($this->onderdeelPrijsExclBtw) ? $this->onderdeelPrijsExclBtw : null;
    }
    /**
     * Set onderdeelPrijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $onderdeelPrijsExclBtw
     * @return \StructType\AboPakketAboSoortV4
     */
    public function setOnderdeelPrijsExclBtw($onderdeelPrijsExclBtw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($onderdeelPrijsExclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $onderdeelPrijsExclBtw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($onderdeelPrijsExclBtw, strpos($onderdeelPrijsExclBtw, '.')))), __LINE__);
        }
        if (is_null($onderdeelPrijsExclBtw) || (is_array($onderdeelPrijsExclBtw) && empty($onderdeelPrijsExclBtw))) {
            unset($this->onderdeelPrijsExclBtw);
        } else {
            $this->onderdeelPrijsExclBtw = $onderdeelPrijsExclBtw;
        }
        return $this;
    }
    /**
     * Get btwCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwCode()
    {
        return isset($this->btwCode) ? $this->btwCode : null;
    }
    /**
     * Set btwCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwCode
     * @return \StructType\AboPakketAboSoortV4
     */
    public function setBtwCode($btwCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($btwCode) && strlen($btwCode) > 3) || (is_array($btwCode) && count($btwCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($btwCode) ? strlen($btwCode) : count($btwCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($btwCode) && !is_string($btwCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($btwCode)), __LINE__);
        }
        if (is_null($btwCode) || (is_array($btwCode) && empty($btwCode))) {
            unset($this->btwCode);
        } else {
            $this->btwCode = $btwCode;
        }
        return $this;
    }
    /**
     * Get btwOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwOmschrijving()
    {
        return isset($this->btwOmschrijving) ? $this->btwOmschrijving : null;
    }
    /**
     * Set btwOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwOmschrijving
     * @return \StructType\AboPakketAboSoortV4
     */
    public function setBtwOmschrijving($btwOmschrijving = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($btwOmschrijving) && strlen($btwOmschrijving) > 120) || (is_array($btwOmschrijving) && count($btwOmschrijving) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($btwOmschrijving) ? strlen($btwOmschrijving) : count($btwOmschrijving)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($btwOmschrijving) && !is_string($btwOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($btwOmschrijving)), __LINE__);
        }
        if (is_null($btwOmschrijving) || (is_array($btwOmschrijving) && empty($btwOmschrijving))) {
            unset($this->btwOmschrijving);
        } else {
            $this->btwOmschrijving = $btwOmschrijving;
        }
        return $this;
    }
    /**
     * Get btwPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBtwPercentage()
    {
        return isset($this->btwPercentage) ? $this->btwPercentage : null;
    }
    /**
     * Set btwPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $btwPercentage
     * @return \StructType\AboPakketAboSoortV4
     */
    public function setBtwPercentage($btwPercentage = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($btwPercentage) && strlen(substr($btwPercentage, strpos($btwPercentage, '.'))) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 fraction digits, "%d" given', strlen(substr($btwPercentage, strpos($btwPercentage, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($btwPercentage) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $btwPercentage)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 digits, "%d" given', strlen(substr($btwPercentage, strpos($btwPercentage, '.')))), __LINE__);
        }
        if (is_null($btwPercentage) || (is_array($btwPercentage) && empty($btwPercentage))) {
            unset($this->btwPercentage);
        } else {
            $this->btwPercentage = $btwPercentage;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AboPakketAboSoortV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
