<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboPakketAanvProdV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Aanvullend product object onder dit abonnements pakket
 * @subpackage Structs
 */
class AboPakketAanvProdV4 extends AbstractStructBase
{
    /**
     * The artikelCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de onderliggende aanvullende product.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $artikelCode;
    /**
     * The artikelNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de onderliggende aanvullende product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $artikelNaam;
    /**
     * The onderdeelPrijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Onderdeel prijs inclusief BTW.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $onderdeelPrijsInclBtw;
    /**
     * The onderdeelPrijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Onderdeel prijs exclusief BTW.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $onderdeelPrijsExclBtw;
    /**
     * The btwCode
     * Meta informations extracted from the WSDL
     * - documentation: BTW code.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 3
     * @var string
     */
    public $btwCode;
    /**
     * The btwOmschrijving
     * Meta informations extracted from the WSDL
     * - documentation: BTW omschrijving.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $btwOmschrijving;
    /**
     * The btwPercentage
     * Meta informations extracted from the WSDL
     * - documentation: BTW percentage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 1
     * - totalDigits: 6
     * @var float
     */
    public $btwPercentage;
    /**
     * Constructor method for AboPakketAanvProdV4
     * @uses AboPakketAanvProdV4::setArtikelCode()
     * @uses AboPakketAanvProdV4::setArtikelNaam()
     * @uses AboPakketAanvProdV4::setOnderdeelPrijsInclBtw()
     * @uses AboPakketAanvProdV4::setOnderdeelPrijsExclBtw()
     * @uses AboPakketAanvProdV4::setBtwCode()
     * @uses AboPakketAanvProdV4::setBtwOmschrijving()
     * @uses AboPakketAanvProdV4::setBtwPercentage()
     * @param string $artikelCode
     * @param string $artikelNaam
     * @param float $onderdeelPrijsInclBtw
     * @param float $onderdeelPrijsExclBtw
     * @param string $btwCode
     * @param string $btwOmschrijving
     * @param float $btwPercentage
     */
    public function __construct($artikelCode = null, $artikelNaam = null, $onderdeelPrijsInclBtw = null, $onderdeelPrijsExclBtw = null, $btwCode = null, $btwOmschrijving = null, $btwPercentage = null)
    {
        $this
            ->setArtikelCode($artikelCode)
            ->setArtikelNaam($artikelNaam)
            ->setOnderdeelPrijsInclBtw($onderdeelPrijsInclBtw)
            ->setOnderdeelPrijsExclBtw($onderdeelPrijsExclBtw)
            ->setBtwCode($btwCode)
            ->setBtwOmschrijving($btwOmschrijving)
            ->setBtwPercentage($btwPercentage);
    }
    /**
     * Get artikelCode value
     * @return string
     */
    public function getArtikelCode()
    {
        return $this->artikelCode;
    }
    /**
     * Set artikelCode value
     * @param string $artikelCode
     * @return \StructType\AboPakketAanvProdV4
     */
    public function setArtikelCode($artikelCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($artikelCode) && strlen($artikelCode) > 30) || (is_array($artikelCode) && count($artikelCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($artikelCode) ? strlen($artikelCode) : count($artikelCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($artikelCode) && strlen($artikelCode) < 1) || (is_array($artikelCode) && count($artikelCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($artikelCode) && !is_string($artikelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelCode)), __LINE__);
        }
        $this->artikelCode = $artikelCode;
        return $this;
    }
    /**
     * Get artikelNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelNaam()
    {
        return isset($this->artikelNaam) ? $this->artikelNaam : null;
    }
    /**
     * Set artikelNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelNaam
     * @return \StructType\AboPakketAanvProdV4
     */
    public function setArtikelNaam($artikelNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($artikelNaam) && strlen($artikelNaam) > 500) || (is_array($artikelNaam) && count($artikelNaam) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($artikelNaam) ? strlen($artikelNaam) : count($artikelNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($artikelNaam) && !is_string($artikelNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelNaam)), __LINE__);
        }
        if (is_null($artikelNaam) || (is_array($artikelNaam) && empty($artikelNaam))) {
            unset($this->artikelNaam);
        } else {
            $this->artikelNaam = $artikelNaam;
        }
        return $this;
    }
    /**
     * Get onderdeelPrijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOnderdeelPrijsInclBtw()
    {
        return isset($this->onderdeelPrijsInclBtw) ? $this->onderdeelPrijsInclBtw : null;
    }
    /**
     * Set onderdeelPrijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $onderdeelPrijsInclBtw
     * @return \StructType\AboPakketAanvProdV4
     */
    public function setOnderdeelPrijsInclBtw($onderdeelPrijsInclBtw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($onderdeelPrijsInclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $onderdeelPrijsInclBtw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($onderdeelPrijsInclBtw, strpos($onderdeelPrijsInclBtw, '.')))), __LINE__);
        }
        if (is_null($onderdeelPrijsInclBtw) || (is_array($onderdeelPrijsInclBtw) && empty($onderdeelPrijsInclBtw))) {
            unset($this->onderdeelPrijsInclBtw);
        } else {
            $this->onderdeelPrijsInclBtw = $onderdeelPrijsInclBtw;
        }
        return $this;
    }
    /**
     * Get onderdeelPrijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOnderdeelPrijsExclBtw()
    {
        return isset($this->onderdeelPrijsExclBtw) ? $this->onderdeelPrijsExclBtw : null;
    }
    /**
     * Set onderdeelPrijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $onderdeelPrijsExclBtw
     * @return \StructType\AboPakketAanvProdV4
     */
    public function setOnderdeelPrijsExclBtw($onderdeelPrijsExclBtw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($onderdeelPrijsExclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $onderdeelPrijsExclBtw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($onderdeelPrijsExclBtw, strpos($onderdeelPrijsExclBtw, '.')))), __LINE__);
        }
        if (is_null($onderdeelPrijsExclBtw) || (is_array($onderdeelPrijsExclBtw) && empty($onderdeelPrijsExclBtw))) {
            unset($this->onderdeelPrijsExclBtw);
        } else {
            $this->onderdeelPrijsExclBtw = $onderdeelPrijsExclBtw;
        }
        return $this;
    }
    /**
     * Get btwCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwCode()
    {
        return isset($this->btwCode) ? $this->btwCode : null;
    }
    /**
     * Set btwCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwCode
     * @return \StructType\AboPakketAanvProdV4
     */
    public function setBtwCode($btwCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($btwCode) && strlen($btwCode) > 3) || (is_array($btwCode) && count($btwCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($btwCode) ? strlen($btwCode) : count($btwCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($btwCode) && !is_string($btwCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($btwCode)), __LINE__);
        }
        if (is_null($btwCode) || (is_array($btwCode) && empty($btwCode))) {
            unset($this->btwCode);
        } else {
            $this->btwCode = $btwCode;
        }
        return $this;
    }
    /**
     * Get btwOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwOmschrijving()
    {
        return isset($this->btwOmschrijving) ? $this->btwOmschrijving : null;
    }
    /**
     * Set btwOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwOmschrijving
     * @return \StructType\AboPakketAanvProdV4
     */
    public function setBtwOmschrijving($btwOmschrijving = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($btwOmschrijving) && strlen($btwOmschrijving) > 120) || (is_array($btwOmschrijving) && count($btwOmschrijving) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($btwOmschrijving) ? strlen($btwOmschrijving) : count($btwOmschrijving)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($btwOmschrijving) && !is_string($btwOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($btwOmschrijving)), __LINE__);
        }
        if (is_null($btwOmschrijving) || (is_array($btwOmschrijving) && empty($btwOmschrijving))) {
            unset($this->btwOmschrijving);
        } else {
            $this->btwOmschrijving = $btwOmschrijving;
        }
        return $this;
    }
    /**
     * Get btwPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBtwPercentage()
    {
        return isset($this->btwPercentage) ? $this->btwPercentage : null;
    }
    /**
     * Set btwPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $btwPercentage
     * @return \StructType\AboPakketAanvProdV4
     */
    public function setBtwPercentage($btwPercentage = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($btwPercentage) && strlen(substr($btwPercentage, strpos($btwPercentage, '.'))) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 fraction digits, "%d" given', strlen(substr($btwPercentage, strpos($btwPercentage, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($btwPercentage) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $btwPercentage)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 digits, "%d" given', strlen(substr($btwPercentage, strpos($btwPercentage, '.')))), __LINE__);
        }
        if (is_null($btwPercentage) || (is_array($btwPercentage) && empty($btwPercentage))) {
            unset($this->btwPercentage);
        } else {
            $this->btwPercentage = $btwPercentage;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AboPakketAanvProdV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
