<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboObjectV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abonnement object.
 * @subpackage Structs
 */
class AboObjectV4 extends AbstractStructBase
{
    /**
     * The aboAboSoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de abonnementsoort Indien abosoort niet gevuld is dient pakket gevuld te zijn. Moet bestaan in abonnementsoort tabel. Moet een actieve abosoort zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $aboAboSoortCode;
    /**
     * The aboActieCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de actie. Code moet bestaan in actie tabel. Moet een actieve actie zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboActieCode;
    /**
     * The aboBetaalReferentie
     * Meta informations extracted from the WSDL
     * - documentation: Betaalreferentie in geval van betaling via eenmalige iDeal.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $aboBetaalReferentie;
    /**
     * The aboBetaalwijze
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,3,4,7] Betaalwijze: 0 = factuur, 1 = incasso, 3 = Eenmalige iDeal, 4 = Factuur per mail, 7 = Creditcard
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboBetaalwijze;
    /**
     * The aboHerkomstCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de herkomst. Code moet bestaan in herkomst tabel.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboHerkomstCode;
    /**
     * The aboIngangsDatum
     * Meta informations extracted from the WSDL
     * - documentation: Ingangsdatum van het abonnement, indien leeg eerstvolgende verschijning.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboIngangsDatum;
    /**
     * The aboPakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het pakket Indien pakket niet gevuld is dient abosoort gevuld te zijn. Moet bestaan in paketten tabel. Moet een actief pakket zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboPakketCode;
    /**
     * The aboPremiumCodeAbo
     * Meta informations extracted from the WSDL
     * - documentation: Code van premium voor abonnee Moet bestaan in de Premium tabel. Moet een actief Premium zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $aboPremiumCodeAbo;
    /**
     * The aboPremiumCodeBetaler
     * Meta informations extracted from the WSDL
     * - documentation: Code van premium voor betaler Moet bestaan in de Premium tabel. Moet een actief Premium zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $aboPremiumCodeBetaler;
    /**
     * The aboRekNr
     * Meta informations extracted from the WSDL
     * - documentation: Bankrekeningnummer Gironr begint met P en niet langer dan 7 cijfers, banknr 11-proef. Igv incasso + pre Sepa verplicht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $aboRekNr;
    /**
     * The aboRekIbanNr
     * Meta informations extracted from the WSDL
     * - documentation: Iban nummer Iban nummer wordt gevalideerd als zijnde een valide Iban nummer. Igv incasso + Sepa verplicht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 34
     * @var string
     */
    public $aboRekIbanNr;
    /**
     * The aboRekBicCode
     * Meta informations extracted from the WSDL
     * - documentation: Bic Code Bic code van de bankrekening. Wordt gevalideerd als zijnde een valide Bic code. Igv incasso + Sepa verplicht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 11
     * @var string
     */
    public $aboRekBicCode;
    /**
     * The aboMachtigingsDatum
     * Meta informations extracted from the WSDL
     * - documentation: Machtigingsdatum voor de incasso Wordt bij de incasso machtiging opgeslagen als machtigings datum (Default vandaag).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboMachtigingsDatum;
    /**
     * The aboAantalExemplaren
     * Meta informations extracted from the WSDL
     * - documentation: Aantal exemplaren (Default 1). Aantal gewenste exemplaren van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboAantalExemplaren;
    /**
     * The aboAdresType
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2] Indicatie naar welk adres het abonnement verzonden moet worden (Default 0). Toegestane waarden: 0=Correspondentie, 1=Bezoek, 2=Prive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 1
     * @var int
     */
    public $aboAdresType;
    /**
     * The aboFactuurNaarPriveadres
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie factuur naar privé adres (Default niet naar privé).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboFactuurNaarPriveadres;
    /**
     * The aboEenmaligeKortingBedr
     * Meta informations extracted from the WSDL
     * - documentation: Bedrag van de eenmalige korting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $aboEenmaligeKortingBedr;
    /**
     * The aboEenmaligeKortingOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de eenmalige korting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboEenmaligeKortingOmschr;
    /**
     * The aboEenmaligeKortingCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van vaste eenmalige korting Moet de code zijn van een bestaande eenmalige korting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboEenmaligeKortingCode;
    /**
     * The aboPropositieCode
     * Meta informations extracted from the WSDL
     * - documentation: Unieke code van de propositie Propositie moet bestaan en actief zijn. Obv de propositie wordt het abonnement aan een actie + abosoort of pakket gekoppeld.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboPropositieCode;
    /**
     * The aboPrijsPropositie
     * Meta informations extracted from the WSDL
     * - documentation: Prijs voor de propositie Propositieprijs geldend voor de eerste factuur of contractperiode. Overruled de propositieprijs opgegeven op de propositie zelf.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $aboPrijsPropositie;
    /**
     * The aboIngevoerdDoor
     * Meta informations extracted from the WSDL
     * - documentation: Abonnement ingevoerd door.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 80
     * @var string
     */
    public $aboIngevoerdDoor;
    /**
     * The aboVrijeVelden
     * Meta informations extracted from the WSDL
     * - documentation: De vrije velden van het abonnement
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijeVeldenAboRecV4
     */
    public $aboVrijeVelden;
    /**
     * The aboOrdernummer
     * Meta informations extracted from the WSDL
     * - documentation: Ordernummer van besteller ter referentie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $aboOrdernummer;
    /**
     * The aboCreditcard
     * Meta informations extracted from the WSDL
     * - documentation: Creditcardgegevens in geval van betaalwijze creditcard
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreditcardV4
     */
    public $aboCreditcard;
    /**
     * Constructor method for AboObjectV4
     * @uses AboObjectV4::setAboAboSoortCode()
     * @uses AboObjectV4::setAboActieCode()
     * @uses AboObjectV4::setAboBetaalReferentie()
     * @uses AboObjectV4::setAboBetaalwijze()
     * @uses AboObjectV4::setAboHerkomstCode()
     * @uses AboObjectV4::setAboIngangsDatum()
     * @uses AboObjectV4::setAboPakketCode()
     * @uses AboObjectV4::setAboPremiumCodeAbo()
     * @uses AboObjectV4::setAboPremiumCodeBetaler()
     * @uses AboObjectV4::setAboRekNr()
     * @uses AboObjectV4::setAboRekIbanNr()
     * @uses AboObjectV4::setAboRekBicCode()
     * @uses AboObjectV4::setAboMachtigingsDatum()
     * @uses AboObjectV4::setAboAantalExemplaren()
     * @uses AboObjectV4::setAboAdresType()
     * @uses AboObjectV4::setAboFactuurNaarPriveadres()
     * @uses AboObjectV4::setAboEenmaligeKortingBedr()
     * @uses AboObjectV4::setAboEenmaligeKortingOmschr()
     * @uses AboObjectV4::setAboEenmaligeKortingCode()
     * @uses AboObjectV4::setAboPropositieCode()
     * @uses AboObjectV4::setAboPrijsPropositie()
     * @uses AboObjectV4::setAboIngevoerdDoor()
     * @uses AboObjectV4::setAboVrijeVelden()
     * @uses AboObjectV4::setAboOrdernummer()
     * @uses AboObjectV4::setAboCreditcard()
     * @param string $aboAboSoortCode
     * @param string $aboActieCode
     * @param string $aboBetaalReferentie
     * @param int $aboBetaalwijze
     * @param string $aboHerkomstCode
     * @param string $aboIngangsDatum
     * @param string $aboPakketCode
     * @param string $aboPremiumCodeAbo
     * @param string $aboPremiumCodeBetaler
     * @param string $aboRekNr
     * @param string $aboRekIbanNr
     * @param string $aboRekBicCode
     * @param string $aboMachtigingsDatum
     * @param int $aboAantalExemplaren
     * @param int $aboAdresType
     * @param bool $aboFactuurNaarPriveadres
     * @param float $aboEenmaligeKortingBedr
     * @param string $aboEenmaligeKortingOmschr
     * @param string $aboEenmaligeKortingCode
     * @param string $aboPropositieCode
     * @param float $aboPrijsPropositie
     * @param string $aboIngevoerdDoor
     * @param \StructType\VrijeVeldenAboRecV4 $aboVrijeVelden
     * @param string $aboOrdernummer
     * @param \StructType\CreditcardV4 $aboCreditcard
     */
    public function __construct($aboAboSoortCode = null, $aboActieCode = null, $aboBetaalReferentie = null, $aboBetaalwijze = null, $aboHerkomstCode = null, $aboIngangsDatum = null, $aboPakketCode = null, $aboPremiumCodeAbo = null, $aboPremiumCodeBetaler = null, $aboRekNr = null, $aboRekIbanNr = null, $aboRekBicCode = null, $aboMachtigingsDatum = null, $aboAantalExemplaren = null, $aboAdresType = null, $aboFactuurNaarPriveadres = null, $aboEenmaligeKortingBedr = null, $aboEenmaligeKortingOmschr = null, $aboEenmaligeKortingCode = null, $aboPropositieCode = null, $aboPrijsPropositie = null, $aboIngevoerdDoor = null, \StructType\VrijeVeldenAboRecV4 $aboVrijeVelden = null, $aboOrdernummer = null, \StructType\CreditcardV4 $aboCreditcard = null)
    {
        $this
            ->setAboAboSoortCode($aboAboSoortCode)
            ->setAboActieCode($aboActieCode)
            ->setAboBetaalReferentie($aboBetaalReferentie)
            ->setAboBetaalwijze($aboBetaalwijze)
            ->setAboHerkomstCode($aboHerkomstCode)
            ->setAboIngangsDatum($aboIngangsDatum)
            ->setAboPakketCode($aboPakketCode)
            ->setAboPremiumCodeAbo($aboPremiumCodeAbo)
            ->setAboPremiumCodeBetaler($aboPremiumCodeBetaler)
            ->setAboRekNr($aboRekNr)
            ->setAboRekIbanNr($aboRekIbanNr)
            ->setAboRekBicCode($aboRekBicCode)
            ->setAboMachtigingsDatum($aboMachtigingsDatum)
            ->setAboAantalExemplaren($aboAantalExemplaren)
            ->setAboAdresType($aboAdresType)
            ->setAboFactuurNaarPriveadres($aboFactuurNaarPriveadres)
            ->setAboEenmaligeKortingBedr($aboEenmaligeKortingBedr)
            ->setAboEenmaligeKortingOmschr($aboEenmaligeKortingOmschr)
            ->setAboEenmaligeKortingCode($aboEenmaligeKortingCode)
            ->setAboPropositieCode($aboPropositieCode)
            ->setAboPrijsPropositie($aboPrijsPropositie)
            ->setAboIngevoerdDoor($aboIngevoerdDoor)
            ->setAboVrijeVelden($aboVrijeVelden)
            ->setAboOrdernummer($aboOrdernummer)
            ->setAboCreditcard($aboCreditcard);
    }
    /**
     * Get aboAboSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboAboSoortCode()
    {
        return isset($this->aboAboSoortCode) ? $this->aboAboSoortCode : null;
    }
    /**
     * Set aboAboSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboAboSoortCode
     * @return \StructType\AboObjectV4
     */
    public function setAboAboSoortCode($aboAboSoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboAboSoortCode) && strlen($aboAboSoortCode) > 30) || (is_array($aboAboSoortCode) && count($aboAboSoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($aboAboSoortCode) ? strlen($aboAboSoortCode) : count($aboAboSoortCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboAboSoortCode) && !is_string($aboAboSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboAboSoortCode)), __LINE__);
        }
        if (is_null($aboAboSoortCode) || (is_array($aboAboSoortCode) && empty($aboAboSoortCode))) {
            unset($this->aboAboSoortCode);
        } else {
            $this->aboAboSoortCode = $aboAboSoortCode;
        }
        return $this;
    }
    /**
     * Get aboActieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboActieCode()
    {
        return isset($this->aboActieCode) ? $this->aboActieCode : null;
    }
    /**
     * Set aboActieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboActieCode
     * @return \StructType\AboObjectV4
     */
    public function setAboActieCode($aboActieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboActieCode) && strlen($aboActieCode) > 20) || (is_array($aboActieCode) && count($aboActieCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboActieCode) ? strlen($aboActieCode) : count($aboActieCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboActieCode) && !is_string($aboActieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboActieCode)), __LINE__);
        }
        if (is_null($aboActieCode) || (is_array($aboActieCode) && empty($aboActieCode))) {
            unset($this->aboActieCode);
        } else {
            $this->aboActieCode = $aboActieCode;
        }
        return $this;
    }
    /**
     * Get aboBetaalReferentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboBetaalReferentie()
    {
        return isset($this->aboBetaalReferentie) ? $this->aboBetaalReferentie : null;
    }
    /**
     * Set aboBetaalReferentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboBetaalReferentie
     * @return \StructType\AboObjectV4
     */
    public function setAboBetaalReferentie($aboBetaalReferentie = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboBetaalReferentie) && strlen($aboBetaalReferentie) > 255) || (is_array($aboBetaalReferentie) && count($aboBetaalReferentie) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($aboBetaalReferentie) ? strlen($aboBetaalReferentie) : count($aboBetaalReferentie)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboBetaalReferentie) && !is_string($aboBetaalReferentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboBetaalReferentie)), __LINE__);
        }
        if (is_null($aboBetaalReferentie) || (is_array($aboBetaalReferentie) && empty($aboBetaalReferentie))) {
            unset($this->aboBetaalReferentie);
        } else {
            $this->aboBetaalReferentie = $aboBetaalReferentie;
        }
        return $this;
    }
    /**
     * Get aboBetaalwijze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboBetaalwijze()
    {
        return isset($this->aboBetaalwijze) ? $this->aboBetaalwijze : null;
    }
    /**
     * Set aboBetaalwijze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboBetaalwijze
     * @return \StructType\AboObjectV4
     */
    public function setAboBetaalwijze($aboBetaalwijze = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboBetaalwijze) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboBetaalwijze)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboBetaalwijze, strpos($aboBetaalwijze, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboBetaalwijze) && !is_numeric($aboBetaalwijze)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboBetaalwijze)), __LINE__);
        }
        if (is_null($aboBetaalwijze) || (is_array($aboBetaalwijze) && empty($aboBetaalwijze))) {
            unset($this->aboBetaalwijze);
        } else {
            $this->aboBetaalwijze = $aboBetaalwijze;
        }
        return $this;
    }
    /**
     * Get aboHerkomstCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboHerkomstCode()
    {
        return isset($this->aboHerkomstCode) ? $this->aboHerkomstCode : null;
    }
    /**
     * Set aboHerkomstCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboHerkomstCode
     * @return \StructType\AboObjectV4
     */
    public function setAboHerkomstCode($aboHerkomstCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboHerkomstCode) && strlen($aboHerkomstCode) > 20) || (is_array($aboHerkomstCode) && count($aboHerkomstCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboHerkomstCode) ? strlen($aboHerkomstCode) : count($aboHerkomstCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboHerkomstCode) && !is_string($aboHerkomstCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboHerkomstCode)), __LINE__);
        }
        if (is_null($aboHerkomstCode) || (is_array($aboHerkomstCode) && empty($aboHerkomstCode))) {
            unset($this->aboHerkomstCode);
        } else {
            $this->aboHerkomstCode = $aboHerkomstCode;
        }
        return $this;
    }
    /**
     * Get aboIngangsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboIngangsDatum()
    {
        return isset($this->aboIngangsDatum) ? $this->aboIngangsDatum : null;
    }
    /**
     * Set aboIngangsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboIngangsDatum
     * @return \StructType\AboObjectV4
     */
    public function setAboIngangsDatum($aboIngangsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($aboIngangsDatum) && !is_string($aboIngangsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboIngangsDatum)), __LINE__);
        }
        if (is_null($aboIngangsDatum) || (is_array($aboIngangsDatum) && empty($aboIngangsDatum))) {
            unset($this->aboIngangsDatum);
        } else {
            $this->aboIngangsDatum = $aboIngangsDatum;
        }
        return $this;
    }
    /**
     * Get aboPakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboPakketCode()
    {
        return isset($this->aboPakketCode) ? $this->aboPakketCode : null;
    }
    /**
     * Set aboPakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboPakketCode
     * @return \StructType\AboObjectV4
     */
    public function setAboPakketCode($aboPakketCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboPakketCode) && strlen($aboPakketCode) > 20) || (is_array($aboPakketCode) && count($aboPakketCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboPakketCode) ? strlen($aboPakketCode) : count($aboPakketCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboPakketCode) && !is_string($aboPakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboPakketCode)), __LINE__);
        }
        if (is_null($aboPakketCode) || (is_array($aboPakketCode) && empty($aboPakketCode))) {
            unset($this->aboPakketCode);
        } else {
            $this->aboPakketCode = $aboPakketCode;
        }
        return $this;
    }
    /**
     * Get aboPremiumCodeAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboPremiumCodeAbo()
    {
        return isset($this->aboPremiumCodeAbo) ? $this->aboPremiumCodeAbo : null;
    }
    /**
     * Set aboPremiumCodeAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboPremiumCodeAbo
     * @return \StructType\AboObjectV4
     */
    public function setAboPremiumCodeAbo($aboPremiumCodeAbo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboPremiumCodeAbo) && strlen($aboPremiumCodeAbo) > 30) || (is_array($aboPremiumCodeAbo) && count($aboPremiumCodeAbo) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($aboPremiumCodeAbo) ? strlen($aboPremiumCodeAbo) : count($aboPremiumCodeAbo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboPremiumCodeAbo) && !is_string($aboPremiumCodeAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboPremiumCodeAbo)), __LINE__);
        }
        if (is_null($aboPremiumCodeAbo) || (is_array($aboPremiumCodeAbo) && empty($aboPremiumCodeAbo))) {
            unset($this->aboPremiumCodeAbo);
        } else {
            $this->aboPremiumCodeAbo = $aboPremiumCodeAbo;
        }
        return $this;
    }
    /**
     * Get aboPremiumCodeBetaler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboPremiumCodeBetaler()
    {
        return isset($this->aboPremiumCodeBetaler) ? $this->aboPremiumCodeBetaler : null;
    }
    /**
     * Set aboPremiumCodeBetaler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboPremiumCodeBetaler
     * @return \StructType\AboObjectV4
     */
    public function setAboPremiumCodeBetaler($aboPremiumCodeBetaler = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboPremiumCodeBetaler) && strlen($aboPremiumCodeBetaler) > 30) || (is_array($aboPremiumCodeBetaler) && count($aboPremiumCodeBetaler) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($aboPremiumCodeBetaler) ? strlen($aboPremiumCodeBetaler) : count($aboPremiumCodeBetaler)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboPremiumCodeBetaler) && !is_string($aboPremiumCodeBetaler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboPremiumCodeBetaler)), __LINE__);
        }
        if (is_null($aboPremiumCodeBetaler) || (is_array($aboPremiumCodeBetaler) && empty($aboPremiumCodeBetaler))) {
            unset($this->aboPremiumCodeBetaler);
        } else {
            $this->aboPremiumCodeBetaler = $aboPremiumCodeBetaler;
        }
        return $this;
    }
    /**
     * Get aboRekNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboRekNr()
    {
        return isset($this->aboRekNr) ? $this->aboRekNr : null;
    }
    /**
     * Set aboRekNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboRekNr
     * @return \StructType\AboObjectV4
     */
    public function setAboRekNr($aboRekNr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboRekNr) && strlen($aboRekNr) > 15) || (is_array($aboRekNr) && count($aboRekNr) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($aboRekNr) ? strlen($aboRekNr) : count($aboRekNr)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboRekNr) && !is_string($aboRekNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboRekNr)), __LINE__);
        }
        if (is_null($aboRekNr) || (is_array($aboRekNr) && empty($aboRekNr))) {
            unset($this->aboRekNr);
        } else {
            $this->aboRekNr = $aboRekNr;
        }
        return $this;
    }
    /**
     * Get aboRekIbanNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboRekIbanNr()
    {
        return isset($this->aboRekIbanNr) ? $this->aboRekIbanNr : null;
    }
    /**
     * Set aboRekIbanNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboRekIbanNr
     * @return \StructType\AboObjectV4
     */
    public function setAboRekIbanNr($aboRekIbanNr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboRekIbanNr) && strlen($aboRekIbanNr) > 34) || (is_array($aboRekIbanNr) && count($aboRekIbanNr) > 34)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 34 element(s) or a scalar of 34 character(s) at most, "%d" length given', is_scalar($aboRekIbanNr) ? strlen($aboRekIbanNr) : count($aboRekIbanNr)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboRekIbanNr) && !is_string($aboRekIbanNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboRekIbanNr)), __LINE__);
        }
        if (is_null($aboRekIbanNr) || (is_array($aboRekIbanNr) && empty($aboRekIbanNr))) {
            unset($this->aboRekIbanNr);
        } else {
            $this->aboRekIbanNr = $aboRekIbanNr;
        }
        return $this;
    }
    /**
     * Get aboRekBicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboRekBicCode()
    {
        return isset($this->aboRekBicCode) ? $this->aboRekBicCode : null;
    }
    /**
     * Set aboRekBicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboRekBicCode
     * @return \StructType\AboObjectV4
     */
    public function setAboRekBicCode($aboRekBicCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboRekBicCode) && strlen($aboRekBicCode) > 11) || (is_array($aboRekBicCode) && count($aboRekBicCode) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($aboRekBicCode) ? strlen($aboRekBicCode) : count($aboRekBicCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboRekBicCode) && !is_string($aboRekBicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboRekBicCode)), __LINE__);
        }
        if (is_null($aboRekBicCode) || (is_array($aboRekBicCode) && empty($aboRekBicCode))) {
            unset($this->aboRekBicCode);
        } else {
            $this->aboRekBicCode = $aboRekBicCode;
        }
        return $this;
    }
    /**
     * Get aboMachtigingsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboMachtigingsDatum()
    {
        return isset($this->aboMachtigingsDatum) ? $this->aboMachtigingsDatum : null;
    }
    /**
     * Set aboMachtigingsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboMachtigingsDatum
     * @return \StructType\AboObjectV4
     */
    public function setAboMachtigingsDatum($aboMachtigingsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($aboMachtigingsDatum) && !is_string($aboMachtigingsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboMachtigingsDatum)), __LINE__);
        }
        if (is_null($aboMachtigingsDatum) || (is_array($aboMachtigingsDatum) && empty($aboMachtigingsDatum))) {
            unset($this->aboMachtigingsDatum);
        } else {
            $this->aboMachtigingsDatum = $aboMachtigingsDatum;
        }
        return $this;
    }
    /**
     * Get aboAantalExemplaren value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboAantalExemplaren()
    {
        return isset($this->aboAantalExemplaren) ? $this->aboAantalExemplaren : null;
    }
    /**
     * Set aboAantalExemplaren value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboAantalExemplaren
     * @return \StructType\AboObjectV4
     */
    public function setAboAantalExemplaren($aboAantalExemplaren = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboAantalExemplaren) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboAantalExemplaren)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboAantalExemplaren, strpos($aboAantalExemplaren, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboAantalExemplaren) && !is_numeric($aboAantalExemplaren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboAantalExemplaren)), __LINE__);
        }
        if (is_null($aboAantalExemplaren) || (is_array($aboAantalExemplaren) && empty($aboAantalExemplaren))) {
            unset($this->aboAantalExemplaren);
        } else {
            $this->aboAantalExemplaren = $aboAantalExemplaren;
        }
        return $this;
    }
    /**
     * Get aboAdresType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboAdresType()
    {
        return isset($this->aboAdresType) ? $this->aboAdresType : null;
    }
    /**
     * Set aboAdresType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboAdresType
     * @return \StructType\AboObjectV4
     */
    public function setAboAdresType($aboAdresType = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboAdresType) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboAdresType)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($aboAdresType, strpos($aboAdresType, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboAdresType) && !is_numeric($aboAdresType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboAdresType)), __LINE__);
        }
        if (is_null($aboAdresType) || (is_array($aboAdresType) && empty($aboAdresType))) {
            unset($this->aboAdresType);
        } else {
            $this->aboAdresType = $aboAdresType;
        }
        return $this;
    }
    /**
     * Get aboFactuurNaarPriveadres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboFactuurNaarPriveadres()
    {
        return isset($this->aboFactuurNaarPriveadres) ? $this->aboFactuurNaarPriveadres : null;
    }
    /**
     * Set aboFactuurNaarPriveadres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboFactuurNaarPriveadres
     * @return \StructType\AboObjectV4
     */
    public function setAboFactuurNaarPriveadres($aboFactuurNaarPriveadres = null)
    {
        if (is_null($aboFactuurNaarPriveadres) || (is_array($aboFactuurNaarPriveadres) && empty($aboFactuurNaarPriveadres))) {
            unset($this->aboFactuurNaarPriveadres);
        } else {
            $this->aboFactuurNaarPriveadres = $aboFactuurNaarPriveadres;
        }
        return $this;
    }
    /**
     * Get aboEenmaligeKortingBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboEenmaligeKortingBedr()
    {
        return isset($this->aboEenmaligeKortingBedr) ? $this->aboEenmaligeKortingBedr : null;
    }
    /**
     * Set aboEenmaligeKortingBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboEenmaligeKortingBedr
     * @return \StructType\AboObjectV4
     */
    public function setAboEenmaligeKortingBedr($aboEenmaligeKortingBedr = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($aboEenmaligeKortingBedr) && strlen(substr($aboEenmaligeKortingBedr, strpos($aboEenmaligeKortingBedr, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($aboEenmaligeKortingBedr, strpos($aboEenmaligeKortingBedr, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($aboEenmaligeKortingBedr) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboEenmaligeKortingBedr)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($aboEenmaligeKortingBedr, strpos($aboEenmaligeKortingBedr, '.')))), __LINE__);
        }
        if (is_null($aboEenmaligeKortingBedr) || (is_array($aboEenmaligeKortingBedr) && empty($aboEenmaligeKortingBedr))) {
            unset($this->aboEenmaligeKortingBedr);
        } else {
            $this->aboEenmaligeKortingBedr = $aboEenmaligeKortingBedr;
        }
        return $this;
    }
    /**
     * Get aboEenmaligeKortingOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboEenmaligeKortingOmschr()
    {
        return isset($this->aboEenmaligeKortingOmschr) ? $this->aboEenmaligeKortingOmschr : null;
    }
    /**
     * Set aboEenmaligeKortingOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboEenmaligeKortingOmschr
     * @return \StructType\AboObjectV4
     */
    public function setAboEenmaligeKortingOmschr($aboEenmaligeKortingOmschr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboEenmaligeKortingOmschr) && strlen($aboEenmaligeKortingOmschr) > 4000) || (is_array($aboEenmaligeKortingOmschr) && count($aboEenmaligeKortingOmschr) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboEenmaligeKortingOmschr) ? strlen($aboEenmaligeKortingOmschr) : count($aboEenmaligeKortingOmschr)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboEenmaligeKortingOmschr) && !is_string($aboEenmaligeKortingOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboEenmaligeKortingOmschr)), __LINE__);
        }
        if (is_null($aboEenmaligeKortingOmschr) || (is_array($aboEenmaligeKortingOmschr) && empty($aboEenmaligeKortingOmschr))) {
            unset($this->aboEenmaligeKortingOmschr);
        } else {
            $this->aboEenmaligeKortingOmschr = $aboEenmaligeKortingOmschr;
        }
        return $this;
    }
    /**
     * Get aboEenmaligeKortingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboEenmaligeKortingCode()
    {
        return isset($this->aboEenmaligeKortingCode) ? $this->aboEenmaligeKortingCode : null;
    }
    /**
     * Set aboEenmaligeKortingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboEenmaligeKortingCode
     * @return \StructType\AboObjectV4
     */
    public function setAboEenmaligeKortingCode($aboEenmaligeKortingCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboEenmaligeKortingCode) && strlen($aboEenmaligeKortingCode) > 4000) || (is_array($aboEenmaligeKortingCode) && count($aboEenmaligeKortingCode) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboEenmaligeKortingCode) ? strlen($aboEenmaligeKortingCode) : count($aboEenmaligeKortingCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboEenmaligeKortingCode) && !is_string($aboEenmaligeKortingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboEenmaligeKortingCode)), __LINE__);
        }
        if (is_null($aboEenmaligeKortingCode) || (is_array($aboEenmaligeKortingCode) && empty($aboEenmaligeKortingCode))) {
            unset($this->aboEenmaligeKortingCode);
        } else {
            $this->aboEenmaligeKortingCode = $aboEenmaligeKortingCode;
        }
        return $this;
    }
    /**
     * Get aboPropositieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboPropositieCode()
    {
        return isset($this->aboPropositieCode) ? $this->aboPropositieCode : null;
    }
    /**
     * Set aboPropositieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboPropositieCode
     * @return \StructType\AboObjectV4
     */
    public function setAboPropositieCode($aboPropositieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboPropositieCode) && strlen($aboPropositieCode) > 20) || (is_array($aboPropositieCode) && count($aboPropositieCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboPropositieCode) ? strlen($aboPropositieCode) : count($aboPropositieCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboPropositieCode) && !is_string($aboPropositieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboPropositieCode)), __LINE__);
        }
        if (is_null($aboPropositieCode) || (is_array($aboPropositieCode) && empty($aboPropositieCode))) {
            unset($this->aboPropositieCode);
        } else {
            $this->aboPropositieCode = $aboPropositieCode;
        }
        return $this;
    }
    /**
     * Get aboPrijsPropositie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboPrijsPropositie()
    {
        return isset($this->aboPrijsPropositie) ? $this->aboPrijsPropositie : null;
    }
    /**
     * Set aboPrijsPropositie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboPrijsPropositie
     * @return \StructType\AboObjectV4
     */
    public function setAboPrijsPropositie($aboPrijsPropositie = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($aboPrijsPropositie) && strlen(substr($aboPrijsPropositie, strpos($aboPrijsPropositie, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($aboPrijsPropositie, strpos($aboPrijsPropositie, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($aboPrijsPropositie) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboPrijsPropositie)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($aboPrijsPropositie, strpos($aboPrijsPropositie, '.')))), __LINE__);
        }
        if (is_null($aboPrijsPropositie) || (is_array($aboPrijsPropositie) && empty($aboPrijsPropositie))) {
            unset($this->aboPrijsPropositie);
        } else {
            $this->aboPrijsPropositie = $aboPrijsPropositie;
        }
        return $this;
    }
    /**
     * Get aboIngevoerdDoor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboIngevoerdDoor()
    {
        return isset($this->aboIngevoerdDoor) ? $this->aboIngevoerdDoor : null;
    }
    /**
     * Set aboIngevoerdDoor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboIngevoerdDoor
     * @return \StructType\AboObjectV4
     */
    public function setAboIngevoerdDoor($aboIngevoerdDoor = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboIngevoerdDoor) && strlen($aboIngevoerdDoor) > 80) || (is_array($aboIngevoerdDoor) && count($aboIngevoerdDoor) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($aboIngevoerdDoor) ? strlen($aboIngevoerdDoor) : count($aboIngevoerdDoor)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboIngevoerdDoor) && !is_string($aboIngevoerdDoor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboIngevoerdDoor)), __LINE__);
        }
        if (is_null($aboIngevoerdDoor) || (is_array($aboIngevoerdDoor) && empty($aboIngevoerdDoor))) {
            unset($this->aboIngevoerdDoor);
        } else {
            $this->aboIngevoerdDoor = $aboIngevoerdDoor;
        }
        return $this;
    }
    /**
     * Get aboVrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijeVeldenAboRecV4|null
     */
    public function getAboVrijeVelden()
    {
        return isset($this->aboVrijeVelden) ? $this->aboVrijeVelden : null;
    }
    /**
     * Set aboVrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijeVeldenAboRecV4 $aboVrijeVelden
     * @return \StructType\AboObjectV4
     */
    public function setAboVrijeVelden(\StructType\VrijeVeldenAboRecV4 $aboVrijeVelden = null)
    {
        if (is_null($aboVrijeVelden) || (is_array($aboVrijeVelden) && empty($aboVrijeVelden))) {
            unset($this->aboVrijeVelden);
        } else {
            $this->aboVrijeVelden = $aboVrijeVelden;
        }
        return $this;
    }
    /**
     * Get aboOrdernummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboOrdernummer()
    {
        return isset($this->aboOrdernummer) ? $this->aboOrdernummer : null;
    }
    /**
     * Set aboOrdernummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboOrdernummer
     * @return \StructType\AboObjectV4
     */
    public function setAboOrdernummer($aboOrdernummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboOrdernummer) && strlen($aboOrdernummer) > 50) || (is_array($aboOrdernummer) && count($aboOrdernummer) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($aboOrdernummer) ? strlen($aboOrdernummer) : count($aboOrdernummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboOrdernummer) && !is_string($aboOrdernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboOrdernummer)), __LINE__);
        }
        if (is_null($aboOrdernummer) || (is_array($aboOrdernummer) && empty($aboOrdernummer))) {
            unset($this->aboOrdernummer);
        } else {
            $this->aboOrdernummer = $aboOrdernummer;
        }
        return $this;
    }
    /**
     * Get aboCreditcard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreditcardV4|null
     */
    public function getAboCreditcard()
    {
        return isset($this->aboCreditcard) ? $this->aboCreditcard : null;
    }
    /**
     * Set aboCreditcard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreditcardV4 $aboCreditcard
     * @return \StructType\AboObjectV4
     */
    public function setAboCreditcard(\StructType\CreditcardV4 $aboCreditcard = null)
    {
        if (is_null($aboCreditcard) || (is_array($aboCreditcard) && empty($aboCreditcard))) {
            unset($this->aboCreditcard);
        } else {
            $this->aboCreditcard = $aboCreditcard;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AboObjectV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
