<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named deleteVerband
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Verwijdert een relatieverband tussen twee relaties.error171: Er is geen verbandnummer opgegevenerror172: Het verbandnummer is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteVerbandRequest $request_parameters
     * @return \StructType\DeleteVerbandResponse|bool
     */
    public function deleteVerband(\StructType\DeleteVerbandRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteVerband($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteKlantKenmerk
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Verwijdert een kenmerk bij een klant.</p> <p>Op basis van een kenmerknummer kan een kenmerk bij een relatie weer verwijderd worden. Het kenmerknummer komt terug bij het aanmaken van een kenmerk (createKenmerk), kan opgehaald worden
     * via getKlantKenmerk (voor één kenmerk) of kan opgevraagd worden via getKenmerkInfo.error176: Er is geen relatie-kenmerk sleutel opgegevenerror177: Het relatie-kenmerk is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteKlantKenmerkRequest $request_parameters
     * @return \StructType\DeleteKlantKenmerkResponse|bool
     */
    public function deleteKlantKenmerk(\StructType\DeleteKlantKenmerkRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteKlantKenmerk($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteLicentiehouderRol
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Verwijdert een rol bij een licentiehoudererror245: Er is geen licentiehouderrol opgegevenerror246: De licentiehouderrol is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteLicentiehouderRolRequest $request_parameters
     * @return \StructType\DeleteLicentiehouderRolResponse|bool
     */
    public function deleteLicentiehouderRol(\StructType\DeleteLicentiehouderRolRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteLicentiehouderRol($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteLicentiehouder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Verwijdert een licentiehouder bij een abonnement. Ofwel aboNo en relNo moeten opgegeven worden, ofwel licentiehouderNo moet worden opgegeven.error1: Het abonnement is niet gevondenerror5: De relatie is niet gevondenerror12: Er is
     * geen abonnement opgegevenerror19: Er is geen relatie opgegevenerror244: Er is geen licentiehouder opgegeven
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteLicentiehouderRequest $request_parameters
     * @return \StructType\DeleteLicentiehouderResponse|bool
     */
    public function deleteLicentiehouder(\StructType\DeleteLicentiehouderRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteLicentiehouder($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteToekomstigeMutatie
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Verwijdert een toekomstige mutatie, zoals een verhuizing of een vakantie regeling.error1: Kan geen relatie vinden, er is geen relNo opgegeven.error2: Kan geen relatie vinden obv de opgegeven relNo.error3: Er is geen toekomstige
     * mutatie nummer opgegeven.error4: Het toekomstige mutatie nummer is niet gevonden.error5: De relatie die de toekomstige mutatie wil verwijderen is niet de relatie waarop de mutatie betrekking heeft.error6: De toekomstige mutatie mag niet worden
     * verwijderd.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteToekomstigeMutatieRequest $request_parameters
     * @return \StructType\DeleteToekomstigeMutatieResponse|bool
     */
    public function deleteToekomstigeMutatie(\StructType\DeleteToekomstigeMutatieRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteToekomstigeMutatie($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteKlantKenmerkResponse|\StructType\DeleteLicentiehouderResponse|\StructType\DeleteLicentiehouderRolResponse|\StructType\DeleteToekomstigeMutatieResponse|\StructType\DeleteVerbandResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
