<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Site StructType
 * @subpackage Structs
 */
class Site extends AbstractStructBase
{
    /**
     * The MaxOccupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The Occupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Occupancy;
    /**
     * The Hysteres
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Hysteres;
    /**
     * The Marginal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Marginal;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Site
     * @uses Site::setMaxOccupancy()
     * @uses Site::setOccupancy()
     * @uses Site::setHysteres()
     * @uses Site::setMarginal()
     * @uses Site::setActive()
     * @uses Site::setId()
     * @uses Site::setName()
     * @param int $maxOccupancy
     * @param int $occupancy
     * @param int $hysteres
     * @param int $marginal
     * @param bool $active
     * @param string $id
     * @param string $name
     */
    public function __construct($maxOccupancy = null, $occupancy = null, $hysteres = null, $marginal = null, $active = null, $id = null, $name = null)
    {
        $this
            ->setMaxOccupancy($maxOccupancy)
            ->setOccupancy($occupancy)
            ->setHysteres($hysteres)
            ->setMarginal($marginal)
            ->setActive($active)
            ->setId($id)
            ->setName($name);
    }
    /**
     * Get MaxOccupancy value
     * @return int
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\Site
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !is_numeric($maxOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return int
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @param int $occupancy
     * @return \StructType\Site
     */
    public function setOccupancy($occupancy = null)
    {
        // validation for constraint: int
        if (!is_null($occupancy) && !is_numeric($occupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($occupancy)), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Get Hysteres value
     * @return int
     */
    public function getHysteres()
    {
        return $this->Hysteres;
    }
    /**
     * Set Hysteres value
     * @param int $hysteres
     * @return \StructType\Site
     */
    public function setHysteres($hysteres = null)
    {
        // validation for constraint: int
        if (!is_null($hysteres) && !is_numeric($hysteres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hysteres)), __LINE__);
        }
        $this->Hysteres = $hysteres;
        return $this;
    }
    /**
     * Get Marginal value
     * @return int
     */
    public function getMarginal()
    {
        return $this->Marginal;
    }
    /**
     * Set Marginal value
     * @param int $marginal
     * @return \StructType\Site
     */
    public function setMarginal($marginal = null)
    {
        // validation for constraint: int
        if (!is_null($marginal) && !is_numeric($marginal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($marginal)), __LINE__);
        }
        $this->Marginal = $marginal;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Site
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\Site
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Site
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Site
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
