<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sign StructType
 * @subpackage Structs
 */
class Sign extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The CurrentMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrentMessage;
    /**
     * The Sites
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSite
     */
    public $Sites;
    /**
     * Constructor method for Sign
     * @uses Sign::setId()
     * @uses Sign::setName()
     * @uses Sign::setCurrentMessage()
     * @uses Sign::setSites()
     * @param string $id
     * @param string $name
     * @param string $currentMessage
     * @param \ArrayType\ArrayOfSite $sites
     */
    public function __construct($id = null, $name = null, $currentMessage = null, \ArrayType\ArrayOfSite $sites = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setCurrentMessage($currentMessage)
            ->setSites($sites);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\Sign
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Sign
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CurrentMessage value
     * @return string|null
     */
    public function getCurrentMessage()
    {
        return $this->CurrentMessage;
    }
    /**
     * Set CurrentMessage value
     * @param string $currentMessage
     * @return \StructType\Sign
     */
    public function setCurrentMessage($currentMessage = null)
    {
        // validation for constraint: string
        if (!is_null($currentMessage) && !is_string($currentMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentMessage)), __LINE__);
        }
        $this->CurrentMessage = $currentMessage;
        return $this;
    }
    /**
     * Get Sites value
     * @return \ArrayType\ArrayOfSite|null
     */
    public function getSites()
    {
        return $this->Sites;
    }
    /**
     * Set Sites value
     * @param \ArrayType\ArrayOfSite $sites
     * @return \StructType\Sign
     */
    public function setSites(\ArrayType\ArrayOfSite $sites = null)
    {
        $this->Sites = $sites;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Sign
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
