<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSite ArrayType
 * @subpackage Arrays
 */
class ArrayOfSite extends AbstractStructArrayBase
{
    /**
     * The Site
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Site[]
     */
    public $Site;
    /**
     * Constructor method for ArrayOfSite
     * @uses ArrayOfSite::setSite()
     * @param \StructType\Site[] $site
     */
    public function __construct(array $site = array())
    {
        $this
            ->setSite($site);
    }
    /**
     * Get Site value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Site[]|null
     */
    public function getSite()
    {
        return isset($this->Site) ? $this->Site : null;
    }
    /**
     * Set Site value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Site[] $site
     * @return \ArrayType\ArrayOfSite
     */
    public function setSite(array $site = array())
    {
        foreach ($site as $arrayOfSiteSiteItem) {
            // validation for constraint: itemType
            if (!$arrayOfSiteSiteItem instanceof \StructType\Site) {
                throw new \InvalidArgumentException(sprintf('The Site property can only contain items of \StructType\Site, "%s" given', is_object($arrayOfSiteSiteItem) ? get_class($arrayOfSiteSiteItem) : gettype($arrayOfSiteSiteItem)), __LINE__);
            }
        }
        if (is_null($site) || (is_array($site) && empty($site))) {
            unset($this->Site);
        } else {
            $this->Site = $site;
        }
        return $this;
    }
    /**
     * Add item to Site value
     * @throws \InvalidArgumentException
     * @param \StructType\Site $item
     * @return \ArrayType\ArrayOfSite
     */
    public function addToSite(\StructType\Site $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Site) {
            throw new \InvalidArgumentException(sprintf('The Site property can only contain items of \StructType\Site, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Site[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Site|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Site|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Site|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Site|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Site|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Site
     */
    public function getAttributeName()
    {
        return 'Site';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSite
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
