<?php

namespace /meuapp/teste\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resposta StructType
 * @subpackage Structs
 */
class Resposta extends AbstractStructBase
{
    /**
     * The siglaSistemaMensagem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 3
     * @var string
     */
    public $siglaSistemaMensagem;
    /**
     * The codigoRetornoPrograma
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoRetornoPrograma;
    /**
     * The nomeProgramaErro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $nomeProgramaErro;
    /**
     * The textoMensagemErro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 68
     * @var string
     */
    public $textoMensagemErro;
    /**
     * The numeroPosicaoErroPrograma
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $numeroPosicaoErroPrograma;
    /**
     * The codigoTipoRetornoPrograma
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 1
     * @var int
     */
    public $codigoTipoRetornoPrograma;
    /**
     * The textoNumeroTituloCobrancaBb
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $textoNumeroTituloCobrancaBb;
    /**
     * The numeroCarteiraCobranca
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $numeroCarteiraCobranca;
    /**
     * The numeroVariacaoCarteiraCobranca
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $numeroVariacaoCarteiraCobranca;
    /**
     * The codigoPrefixoDependenciaBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $codigoPrefixoDependenciaBeneficiario;
    /**
     * The numeroContaCorrenteBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 9
     * @var int
     */
    public $numeroContaCorrenteBeneficiario;
    /**
     * The codigoCliente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 9
     * @var int
     */
    public $codigoCliente;
    /**
     * The linhaDigitavel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 47
     * @var string
     */
    public $linhaDigitavel;
    /**
     * The codigoBarraNumerico
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 52
     * @var string
     */
    public $codigoBarraNumerico;
    /**
     * The codigoTipoEnderecoBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 1
     * @var int
     */
    public $codigoTipoEnderecoBeneficiario;
    /**
     * The nomeLogradouroBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $nomeLogradouroBeneficiario;
    /**
     * The nomeBairroBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $nomeBairroBeneficiario;
    /**
     * The nomeMunicipioBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $nomeMunicipioBeneficiario;
    /**
     * The codigoMunicipioBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 9
     * @var int
     */
    public $codigoMunicipioBeneficiario;
    /**
     * The siglaUfBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $siglaUfBeneficiario;
    /**
     * The codigoCepBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 9
     * @var int
     */
    public $codigoCepBeneficiario;
    /**
     * The indicadorComprovacaoBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $indicadorComprovacaoBeneficiario;
    /**
     * The numeroContratoCobranca
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 9
     * @var int
     */
    public $numeroContratoCobranca;
    /**
     * Constructor method for resposta
     * @uses Resposta::setSiglaSistemaMensagem()
     * @uses Resposta::setCodigoRetornoPrograma()
     * @uses Resposta::setNomeProgramaErro()
     * @uses Resposta::setTextoMensagemErro()
     * @uses Resposta::setNumeroPosicaoErroPrograma()
     * @uses Resposta::setCodigoTipoRetornoPrograma()
     * @uses Resposta::setTextoNumeroTituloCobrancaBb()
     * @uses Resposta::setNumeroCarteiraCobranca()
     * @uses Resposta::setNumeroVariacaoCarteiraCobranca()
     * @uses Resposta::setCodigoPrefixoDependenciaBeneficiario()
     * @uses Resposta::setNumeroContaCorrenteBeneficiario()
     * @uses Resposta::setCodigoCliente()
     * @uses Resposta::setLinhaDigitavel()
     * @uses Resposta::setCodigoBarraNumerico()
     * @uses Resposta::setCodigoTipoEnderecoBeneficiario()
     * @uses Resposta::setNomeLogradouroBeneficiario()
     * @uses Resposta::setNomeBairroBeneficiario()
     * @uses Resposta::setNomeMunicipioBeneficiario()
     * @uses Resposta::setCodigoMunicipioBeneficiario()
     * @uses Resposta::setSiglaUfBeneficiario()
     * @uses Resposta::setCodigoCepBeneficiario()
     * @uses Resposta::setIndicadorComprovacaoBeneficiario()
     * @uses Resposta::setNumeroContratoCobranca()
     * @param string $siglaSistemaMensagem
     * @param int $codigoRetornoPrograma
     * @param string $nomeProgramaErro
     * @param string $textoMensagemErro
     * @param int $numeroPosicaoErroPrograma
     * @param int $codigoTipoRetornoPrograma
     * @param string $textoNumeroTituloCobrancaBb
     * @param int $numeroCarteiraCobranca
     * @param int $numeroVariacaoCarteiraCobranca
     * @param int $codigoPrefixoDependenciaBeneficiario
     * @param int $numeroContaCorrenteBeneficiario
     * @param int $codigoCliente
     * @param string $linhaDigitavel
     * @param string $codigoBarraNumerico
     * @param int $codigoTipoEnderecoBeneficiario
     * @param string $nomeLogradouroBeneficiario
     * @param string $nomeBairroBeneficiario
     * @param string $nomeMunicipioBeneficiario
     * @param int $codigoMunicipioBeneficiario
     * @param string $siglaUfBeneficiario
     * @param int $codigoCepBeneficiario
     * @param string $indicadorComprovacaoBeneficiario
     * @param int $numeroContratoCobranca
     */
    public function __construct($siglaSistemaMensagem = null, $codigoRetornoPrograma = null, $nomeProgramaErro = null, $textoMensagemErro = null, $numeroPosicaoErroPrograma = null, $codigoTipoRetornoPrograma = null, $textoNumeroTituloCobrancaBb = null, $numeroCarteiraCobranca = null, $numeroVariacaoCarteiraCobranca = null, $codigoPrefixoDependenciaBeneficiario = null, $numeroContaCorrenteBeneficiario = null, $codigoCliente = null, $linhaDigitavel = null, $codigoBarraNumerico = null, $codigoTipoEnderecoBeneficiario = null, $nomeLogradouroBeneficiario = null, $nomeBairroBeneficiario = null, $nomeMunicipioBeneficiario = null, $codigoMunicipioBeneficiario = null, $siglaUfBeneficiario = null, $codigoCepBeneficiario = null, $indicadorComprovacaoBeneficiario = null, $numeroContratoCobranca = null)
    {
        $this
            ->setSiglaSistemaMensagem($siglaSistemaMensagem)
            ->setCodigoRetornoPrograma($codigoRetornoPrograma)
            ->setNomeProgramaErro($nomeProgramaErro)
            ->setTextoMensagemErro($textoMensagemErro)
            ->setNumeroPosicaoErroPrograma($numeroPosicaoErroPrograma)
            ->setCodigoTipoRetornoPrograma($codigoTipoRetornoPrograma)
            ->setTextoNumeroTituloCobrancaBb($textoNumeroTituloCobrancaBb)
            ->setNumeroCarteiraCobranca($numeroCarteiraCobranca)
            ->setNumeroVariacaoCarteiraCobranca($numeroVariacaoCarteiraCobranca)
            ->setCodigoPrefixoDependenciaBeneficiario($codigoPrefixoDependenciaBeneficiario)
            ->setNumeroContaCorrenteBeneficiario($numeroContaCorrenteBeneficiario)
            ->setCodigoCliente($codigoCliente)
            ->setLinhaDigitavel($linhaDigitavel)
            ->setCodigoBarraNumerico($codigoBarraNumerico)
            ->setCodigoTipoEnderecoBeneficiario($codigoTipoEnderecoBeneficiario)
            ->setNomeLogradouroBeneficiario($nomeLogradouroBeneficiario)
            ->setNomeBairroBeneficiario($nomeBairroBeneficiario)
            ->setNomeMunicipioBeneficiario($nomeMunicipioBeneficiario)
            ->setCodigoMunicipioBeneficiario($codigoMunicipioBeneficiario)
            ->setSiglaUfBeneficiario($siglaUfBeneficiario)
            ->setCodigoCepBeneficiario($codigoCepBeneficiario)
            ->setIndicadorComprovacaoBeneficiario($indicadorComprovacaoBeneficiario)
            ->setNumeroContratoCobranca($numeroContratoCobranca);
    }
    /**
     * Get siglaSistemaMensagem value
     * @return string|null
     */
    public function getSiglaSistemaMensagem()
    {
        return $this->siglaSistemaMensagem;
    }
    /**
     * Set siglaSistemaMensagem value
     * @param string $siglaSistemaMensagem
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setSiglaSistemaMensagem($siglaSistemaMensagem = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($siglaSistemaMensagem) && strlen($siglaSistemaMensagem) > 3) || (is_array($siglaSistemaMensagem) && count($siglaSistemaMensagem) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($siglaSistemaMensagem) ? strlen($siglaSistemaMensagem) : count($siglaSistemaMensagem)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($siglaSistemaMensagem) && !is_string($siglaSistemaMensagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siglaSistemaMensagem)), __LINE__);
        }
        $this->siglaSistemaMensagem = $siglaSistemaMensagem;
        return $this;
    }
    /**
     * Get codigoRetornoPrograma value
     * @return int|null
     */
    public function getCodigoRetornoPrograma()
    {
        return $this->codigoRetornoPrograma;
    }
    /**
     * Set codigoRetornoPrograma value
     * @param int $codigoRetornoPrograma
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setCodigoRetornoPrograma($codigoRetornoPrograma = null)
    {
        // validation for constraint: int
        if (!is_null($codigoRetornoPrograma) && !is_numeric($codigoRetornoPrograma)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoRetornoPrograma)), __LINE__);
        }
        $this->codigoRetornoPrograma = $codigoRetornoPrograma;
        return $this;
    }
    /**
     * Get nomeProgramaErro value
     * @return string|null
     */
    public function getNomeProgramaErro()
    {
        return $this->nomeProgramaErro;
    }
    /**
     * Set nomeProgramaErro value
     * @param string $nomeProgramaErro
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setNomeProgramaErro($nomeProgramaErro = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nomeProgramaErro) && strlen($nomeProgramaErro) > 8) || (is_array($nomeProgramaErro) && count($nomeProgramaErro) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($nomeProgramaErro) ? strlen($nomeProgramaErro) : count($nomeProgramaErro)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nomeProgramaErro) && !is_string($nomeProgramaErro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeProgramaErro)), __LINE__);
        }
        $this->nomeProgramaErro = $nomeProgramaErro;
        return $this;
    }
    /**
     * Get textoMensagemErro value
     * @return string|null
     */
    public function getTextoMensagemErro()
    {
        return $this->textoMensagemErro;
    }
    /**
     * Set textoMensagemErro value
     * @param string $textoMensagemErro
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setTextoMensagemErro($textoMensagemErro = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textoMensagemErro) && strlen($textoMensagemErro) > 68) || (is_array($textoMensagemErro) && count($textoMensagemErro) > 68)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 68 element(s) or a scalar of 68 character(s) at most, "%d" length given', is_scalar($textoMensagemErro) ? strlen($textoMensagemErro) : count($textoMensagemErro)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textoMensagemErro) && !is_string($textoMensagemErro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textoMensagemErro)), __LINE__);
        }
        $this->textoMensagemErro = $textoMensagemErro;
        return $this;
    }
    /**
     * Get numeroPosicaoErroPrograma value
     * @return int|null
     */
    public function getNumeroPosicaoErroPrograma()
    {
        return $this->numeroPosicaoErroPrograma;
    }
    /**
     * Set numeroPosicaoErroPrograma value
     * @param int $numeroPosicaoErroPrograma
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setNumeroPosicaoErroPrograma($numeroPosicaoErroPrograma = null)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroPosicaoErroPrograma) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroPosicaoErroPrograma)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 digits, "%d" given', strlen(substr($numeroPosicaoErroPrograma, strpos($numeroPosicaoErroPrograma, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroPosicaoErroPrograma) && !is_numeric($numeroPosicaoErroPrograma)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroPosicaoErroPrograma)), __LINE__);
        }
        $this->numeroPosicaoErroPrograma = $numeroPosicaoErroPrograma;
        return $this;
    }
    /**
     * Get codigoTipoRetornoPrograma value
     * @return int|null
     */
    public function getCodigoTipoRetornoPrograma()
    {
        return $this->codigoTipoRetornoPrograma;
    }
    /**
     * Set codigoTipoRetornoPrograma value
     * @param int $codigoTipoRetornoPrograma
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setCodigoTipoRetornoPrograma($codigoTipoRetornoPrograma = null)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoTipoRetornoPrograma) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoTipoRetornoPrograma)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($codigoTipoRetornoPrograma, strpos($codigoTipoRetornoPrograma, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoTipoRetornoPrograma) && !is_numeric($codigoTipoRetornoPrograma)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoTipoRetornoPrograma)), __LINE__);
        }
        $this->codigoTipoRetornoPrograma = $codigoTipoRetornoPrograma;
        return $this;
    }
    /**
     * Get textoNumeroTituloCobrancaBb value
     * @return string|null
     */
    public function getTextoNumeroTituloCobrancaBb()
    {
        return $this->textoNumeroTituloCobrancaBb;
    }
    /**
     * Set textoNumeroTituloCobrancaBb value
     * @param string $textoNumeroTituloCobrancaBb
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setTextoNumeroTituloCobrancaBb($textoNumeroTituloCobrancaBb = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textoNumeroTituloCobrancaBb) && strlen($textoNumeroTituloCobrancaBb) > 20) || (is_array($textoNumeroTituloCobrancaBb) && count($textoNumeroTituloCobrancaBb) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($textoNumeroTituloCobrancaBb) ? strlen($textoNumeroTituloCobrancaBb) : count($textoNumeroTituloCobrancaBb)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textoNumeroTituloCobrancaBb) && !is_string($textoNumeroTituloCobrancaBb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textoNumeroTituloCobrancaBb)), __LINE__);
        }
        $this->textoNumeroTituloCobrancaBb = $textoNumeroTituloCobrancaBb;
        return $this;
    }
    /**
     * Get numeroCarteiraCobranca value
     * @return int|null
     */
    public function getNumeroCarteiraCobranca()
    {
        return $this->numeroCarteiraCobranca;
    }
    /**
     * Set numeroCarteiraCobranca value
     * @param int $numeroCarteiraCobranca
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setNumeroCarteiraCobranca($numeroCarteiraCobranca = null)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroCarteiraCobranca) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroCarteiraCobranca)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 digits, "%d" given', strlen(substr($numeroCarteiraCobranca, strpos($numeroCarteiraCobranca, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroCarteiraCobranca) && !is_numeric($numeroCarteiraCobranca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroCarteiraCobranca)), __LINE__);
        }
        $this->numeroCarteiraCobranca = $numeroCarteiraCobranca;
        return $this;
    }
    /**
     * Get numeroVariacaoCarteiraCobranca value
     * @return int|null
     */
    public function getNumeroVariacaoCarteiraCobranca()
    {
        return $this->numeroVariacaoCarteiraCobranca;
    }
    /**
     * Set numeroVariacaoCarteiraCobranca value
     * @param int $numeroVariacaoCarteiraCobranca
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setNumeroVariacaoCarteiraCobranca($numeroVariacaoCarteiraCobranca = null)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroVariacaoCarteiraCobranca) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroVariacaoCarteiraCobranca)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 digits, "%d" given', strlen(substr($numeroVariacaoCarteiraCobranca, strpos($numeroVariacaoCarteiraCobranca, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroVariacaoCarteiraCobranca) && !is_numeric($numeroVariacaoCarteiraCobranca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroVariacaoCarteiraCobranca)), __LINE__);
        }
        $this->numeroVariacaoCarteiraCobranca = $numeroVariacaoCarteiraCobranca;
        return $this;
    }
    /**
     * Get codigoPrefixoDependenciaBeneficiario value
     * @return int|null
     */
    public function getCodigoPrefixoDependenciaBeneficiario()
    {
        return $this->codigoPrefixoDependenciaBeneficiario;
    }
    /**
     * Set codigoPrefixoDependenciaBeneficiario value
     * @param int $codigoPrefixoDependenciaBeneficiario
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setCodigoPrefixoDependenciaBeneficiario($codigoPrefixoDependenciaBeneficiario = null)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoPrefixoDependenciaBeneficiario) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoPrefixoDependenciaBeneficiario)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 digits, "%d" given', strlen(substr($codigoPrefixoDependenciaBeneficiario, strpos($codigoPrefixoDependenciaBeneficiario, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoPrefixoDependenciaBeneficiario) && !is_numeric($codigoPrefixoDependenciaBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoPrefixoDependenciaBeneficiario)), __LINE__);
        }
        $this->codigoPrefixoDependenciaBeneficiario = $codigoPrefixoDependenciaBeneficiario;
        return $this;
    }
    /**
     * Get numeroContaCorrenteBeneficiario value
     * @return int|null
     */
    public function getNumeroContaCorrenteBeneficiario()
    {
        return $this->numeroContaCorrenteBeneficiario;
    }
    /**
     * Set numeroContaCorrenteBeneficiario value
     * @param int $numeroContaCorrenteBeneficiario
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setNumeroContaCorrenteBeneficiario($numeroContaCorrenteBeneficiario = null)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroContaCorrenteBeneficiario) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroContaCorrenteBeneficiario)) !== 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 9 digits, "%d" given', strlen(substr($numeroContaCorrenteBeneficiario, strpos($numeroContaCorrenteBeneficiario, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroContaCorrenteBeneficiario) && !is_numeric($numeroContaCorrenteBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroContaCorrenteBeneficiario)), __LINE__);
        }
        $this->numeroContaCorrenteBeneficiario = $numeroContaCorrenteBeneficiario;
        return $this;
    }
    /**
     * Get codigoCliente value
     * @return int|null
     */
    public function getCodigoCliente()
    {
        return $this->codigoCliente;
    }
    /**
     * Set codigoCliente value
     * @param int $codigoCliente
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setCodigoCliente($codigoCliente = null)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoCliente) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoCliente)) !== 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 9 digits, "%d" given', strlen(substr($codigoCliente, strpos($codigoCliente, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoCliente) && !is_numeric($codigoCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoCliente)), __LINE__);
        }
        $this->codigoCliente = $codigoCliente;
        return $this;
    }
    /**
     * Get linhaDigitavel value
     * @return string|null
     */
    public function getLinhaDigitavel()
    {
        return $this->linhaDigitavel;
    }
    /**
     * Set linhaDigitavel value
     * @param string $linhaDigitavel
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setLinhaDigitavel($linhaDigitavel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($linhaDigitavel) && strlen($linhaDigitavel) > 47) || (is_array($linhaDigitavel) && count($linhaDigitavel) > 47)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 47 element(s) or a scalar of 47 character(s) at most, "%d" length given', is_scalar($linhaDigitavel) ? strlen($linhaDigitavel) : count($linhaDigitavel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($linhaDigitavel) && !is_string($linhaDigitavel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linhaDigitavel)), __LINE__);
        }
        $this->linhaDigitavel = $linhaDigitavel;
        return $this;
    }
    /**
     * Get codigoBarraNumerico value
     * @return string|null
     */
    public function getCodigoBarraNumerico()
    {
        return $this->codigoBarraNumerico;
    }
    /**
     * Set codigoBarraNumerico value
     * @param string $codigoBarraNumerico
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setCodigoBarraNumerico($codigoBarraNumerico = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codigoBarraNumerico) && strlen($codigoBarraNumerico) > 52) || (is_array($codigoBarraNumerico) && count($codigoBarraNumerico) > 52)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 52 element(s) or a scalar of 52 character(s) at most, "%d" length given', is_scalar($codigoBarraNumerico) ? strlen($codigoBarraNumerico) : count($codigoBarraNumerico)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoBarraNumerico) && !is_string($codigoBarraNumerico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoBarraNumerico)), __LINE__);
        }
        $this->codigoBarraNumerico = $codigoBarraNumerico;
        return $this;
    }
    /**
     * Get codigoTipoEnderecoBeneficiario value
     * @return int|null
     */
    public function getCodigoTipoEnderecoBeneficiario()
    {
        return $this->codigoTipoEnderecoBeneficiario;
    }
    /**
     * Set codigoTipoEnderecoBeneficiario value
     * @param int $codigoTipoEnderecoBeneficiario
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setCodigoTipoEnderecoBeneficiario($codigoTipoEnderecoBeneficiario = null)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoTipoEnderecoBeneficiario) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoTipoEnderecoBeneficiario)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($codigoTipoEnderecoBeneficiario, strpos($codigoTipoEnderecoBeneficiario, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoTipoEnderecoBeneficiario) && !is_numeric($codigoTipoEnderecoBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoTipoEnderecoBeneficiario)), __LINE__);
        }
        $this->codigoTipoEnderecoBeneficiario = $codigoTipoEnderecoBeneficiario;
        return $this;
    }
    /**
     * Get nomeLogradouroBeneficiario value
     * @return string|null
     */
    public function getNomeLogradouroBeneficiario()
    {
        return $this->nomeLogradouroBeneficiario;
    }
    /**
     * Set nomeLogradouroBeneficiario value
     * @param string $nomeLogradouroBeneficiario
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setNomeLogradouroBeneficiario($nomeLogradouroBeneficiario = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nomeLogradouroBeneficiario) && strlen($nomeLogradouroBeneficiario) > 60) || (is_array($nomeLogradouroBeneficiario) && count($nomeLogradouroBeneficiario) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($nomeLogradouroBeneficiario) ? strlen($nomeLogradouroBeneficiario) : count($nomeLogradouroBeneficiario)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nomeLogradouroBeneficiario) && !is_string($nomeLogradouroBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeLogradouroBeneficiario)), __LINE__);
        }
        $this->nomeLogradouroBeneficiario = $nomeLogradouroBeneficiario;
        return $this;
    }
    /**
     * Get nomeBairroBeneficiario value
     * @return string|null
     */
    public function getNomeBairroBeneficiario()
    {
        return $this->nomeBairroBeneficiario;
    }
    /**
     * Set nomeBairroBeneficiario value
     * @param string $nomeBairroBeneficiario
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setNomeBairroBeneficiario($nomeBairroBeneficiario = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nomeBairroBeneficiario) && strlen($nomeBairroBeneficiario) > 30) || (is_array($nomeBairroBeneficiario) && count($nomeBairroBeneficiario) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($nomeBairroBeneficiario) ? strlen($nomeBairroBeneficiario) : count($nomeBairroBeneficiario)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nomeBairroBeneficiario) && !is_string($nomeBairroBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeBairroBeneficiario)), __LINE__);
        }
        $this->nomeBairroBeneficiario = $nomeBairroBeneficiario;
        return $this;
    }
    /**
     * Get nomeMunicipioBeneficiario value
     * @return string|null
     */
    public function getNomeMunicipioBeneficiario()
    {
        return $this->nomeMunicipioBeneficiario;
    }
    /**
     * Set nomeMunicipioBeneficiario value
     * @param string $nomeMunicipioBeneficiario
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setNomeMunicipioBeneficiario($nomeMunicipioBeneficiario = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nomeMunicipioBeneficiario) && strlen($nomeMunicipioBeneficiario) > 30) || (is_array($nomeMunicipioBeneficiario) && count($nomeMunicipioBeneficiario) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($nomeMunicipioBeneficiario) ? strlen($nomeMunicipioBeneficiario) : count($nomeMunicipioBeneficiario)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nomeMunicipioBeneficiario) && !is_string($nomeMunicipioBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeMunicipioBeneficiario)), __LINE__);
        }
        $this->nomeMunicipioBeneficiario = $nomeMunicipioBeneficiario;
        return $this;
    }
    /**
     * Get codigoMunicipioBeneficiario value
     * @return int|null
     */
    public function getCodigoMunicipioBeneficiario()
    {
        return $this->codigoMunicipioBeneficiario;
    }
    /**
     * Set codigoMunicipioBeneficiario value
     * @param int $codigoMunicipioBeneficiario
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setCodigoMunicipioBeneficiario($codigoMunicipioBeneficiario = null)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoMunicipioBeneficiario) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoMunicipioBeneficiario)) !== 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 9 digits, "%d" given', strlen(substr($codigoMunicipioBeneficiario, strpos($codigoMunicipioBeneficiario, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoMunicipioBeneficiario) && !is_numeric($codigoMunicipioBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoMunicipioBeneficiario)), __LINE__);
        }
        $this->codigoMunicipioBeneficiario = $codigoMunicipioBeneficiario;
        return $this;
    }
    /**
     * Get siglaUfBeneficiario value
     * @return string|null
     */
    public function getSiglaUfBeneficiario()
    {
        return $this->siglaUfBeneficiario;
    }
    /**
     * Set siglaUfBeneficiario value
     * @param string $siglaUfBeneficiario
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setSiglaUfBeneficiario($siglaUfBeneficiario = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($siglaUfBeneficiario) && strlen($siglaUfBeneficiario) > 2) || (is_array($siglaUfBeneficiario) && count($siglaUfBeneficiario) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($siglaUfBeneficiario) ? strlen($siglaUfBeneficiario) : count($siglaUfBeneficiario)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($siglaUfBeneficiario) && !is_string($siglaUfBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siglaUfBeneficiario)), __LINE__);
        }
        $this->siglaUfBeneficiario = $siglaUfBeneficiario;
        return $this;
    }
    /**
     * Get codigoCepBeneficiario value
     * @return int|null
     */
    public function getCodigoCepBeneficiario()
    {
        return $this->codigoCepBeneficiario;
    }
    /**
     * Set codigoCepBeneficiario value
     * @param int $codigoCepBeneficiario
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setCodigoCepBeneficiario($codigoCepBeneficiario = null)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoCepBeneficiario) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoCepBeneficiario)) !== 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 9 digits, "%d" given', strlen(substr($codigoCepBeneficiario, strpos($codigoCepBeneficiario, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoCepBeneficiario) && !is_numeric($codigoCepBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoCepBeneficiario)), __LINE__);
        }
        $this->codigoCepBeneficiario = $codigoCepBeneficiario;
        return $this;
    }
    /**
     * Get indicadorComprovacaoBeneficiario value
     * @return string|null
     */
    public function getIndicadorComprovacaoBeneficiario()
    {
        return $this->indicadorComprovacaoBeneficiario;
    }
    /**
     * Set indicadorComprovacaoBeneficiario value
     * @param string $indicadorComprovacaoBeneficiario
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setIndicadorComprovacaoBeneficiario($indicadorComprovacaoBeneficiario = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($indicadorComprovacaoBeneficiario) && strlen($indicadorComprovacaoBeneficiario) > 1) || (is_array($indicadorComprovacaoBeneficiario) && count($indicadorComprovacaoBeneficiario) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($indicadorComprovacaoBeneficiario) ? strlen($indicadorComprovacaoBeneficiario) : count($indicadorComprovacaoBeneficiario)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($indicadorComprovacaoBeneficiario) && !is_string($indicadorComprovacaoBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indicadorComprovacaoBeneficiario)), __LINE__);
        }
        $this->indicadorComprovacaoBeneficiario = $indicadorComprovacaoBeneficiario;
        return $this;
    }
    /**
     * Get numeroContratoCobranca value
     * @return int|null
     */
    public function getNumeroContratoCobranca()
    {
        return $this->numeroContratoCobranca;
    }
    /**
     * Set numeroContratoCobranca value
     * @param int $numeroContratoCobranca
     * @return \/meuapp/teste\StructType\Resposta
     */
    public function setNumeroContratoCobranca($numeroContratoCobranca = null)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroContratoCobranca) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroContratoCobranca)) !== 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 9 digits, "%d" given', strlen(substr($numeroContratoCobranca, strpos($numeroContratoCobranca, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroContratoCobranca) && !is_numeric($numeroContratoCobranca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroContratoCobranca)), __LINE__);
        }
        $this->numeroContratoCobranca = $numeroContratoCobranca;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \/meuapp/teste\StructType\Resposta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
