<?php

namespace /meuapp/teste\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requisicao StructType
 * @subpackage Structs
 */
class Requisicao extends AbstractStructBase
{
    /**
     * The numeroConvenio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 9
     * @var int
     */
    public $numeroConvenio;
    /**
     * The numeroCarteira
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $numeroCarteira;
    /**
     * The numeroVariacaoCarteira
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $numeroVariacaoCarteira;
    /**
     * The codigoModalidadeTitulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $codigoModalidadeTitulo;
    /**
     * The dataEmissaoTitulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $dataEmissaoTitulo;
    /**
     * The dataVencimentoTitulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $dataVencimentoTitulo;
    /**
     * The valorOriginalTitulo
     * Meta informations extracted from the WSDL
     * - default: 0.0
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $valorOriginalTitulo;
    /**
     * The codigoTipoDesconto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 1
     * @var int
     */
    public $codigoTipoDesconto;
    /**
     * The dataDescontoTitulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $dataDescontoTitulo;
    /**
     * The percentualDescontoTitulo
     * Meta informations extracted from the WSDL
     * - default: 0.0
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 5
     * @var float
     */
    public $percentualDescontoTitulo;
    /**
     * The valorDescontoTitulo
     * Meta informations extracted from the WSDL
     * - default: 0.0
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $valorDescontoTitulo;
    /**
     * The valorAbatimentoTitulo
     * Meta informations extracted from the WSDL
     * - default: 0.0
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $valorAbatimentoTitulo;
    /**
     * The quantidadeDiaProtesto
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $quantidadeDiaProtesto;
    /**
     * The codigoTipoJuroMora
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 1
     * @var int
     */
    public $codigoTipoJuroMora;
    /**
     * The percentualJuroMoraTitulo
     * Meta informations extracted from the WSDL
     * - default: 0.0
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 5
     * @var float
     */
    public $percentualJuroMoraTitulo;
    /**
     * The valorJuroMoraTitulo
     * Meta informations extracted from the WSDL
     * - default: 0.0
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $valorJuroMoraTitulo;
    /**
     * The codigoTipoMulta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - totalDigits: 1
     * @var int
     */
    public $codigoTipoMulta;
    /**
     * The dataMultaTitulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $dataMultaTitulo;
    /**
     * The percentualMultaTitulo
     * Meta informations extracted from the WSDL
     * - default: 0.0
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 5
     * @var float
     */
    public $percentualMultaTitulo;
    /**
     * The valorMultaTitulo
     * Meta informations extracted from the WSDL
     * - default: 0.0
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $valorMultaTitulo;
    /**
     * The codigoAceiteTitulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $codigoAceiteTitulo;
    /**
     * The codigoTipoTitulo
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $codigoTipoTitulo;
    /**
     * The textoDescricaoTipoTitulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $textoDescricaoTipoTitulo;
    /**
     * The indicadorPermissaoRecebimentoParcial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $indicadorPermissaoRecebimentoParcial;
    /**
     * The textoNumeroTituloBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $textoNumeroTituloBeneficiario;
    /**
     * The textoCampoUtilizacaoBeneficiario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 25
     * @var string
     */
    public $textoCampoUtilizacaoBeneficiario;
    /**
     * The codigoTipoContaCaucao
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - totalDigits: 1
     * @var int
     */
    public $codigoTipoContaCaucao;
    /**
     * The textoNumeroTituloCliente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $textoNumeroTituloCliente;
    /**
     * The textoMensagemBloquetoOcorrencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 220
     * @var string
     */
    public $textoMensagemBloquetoOcorrencia;
    /**
     * The codigoTipoInscricaoPagador
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - totalDigits: 1
     * @var int
     */
    public $codigoTipoInscricaoPagador;
    /**
     * The numeroInscricaoPagador
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $numeroInscricaoPagador;
    /**
     * The nomePagador
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $nomePagador;
    /**
     * The textoEnderecoPagador
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $textoEnderecoPagador;
    /**
     * The numeroCepPagador
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - totalDigits: 8
     * @var int
     */
    public $numeroCepPagador;
    /**
     * The nomeMunicipioPagador
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $nomeMunicipioPagador;
    /**
     * The nomeBairroPagador
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $nomeBairroPagador;
    /**
     * The siglaUfPagador
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $siglaUfPagador;
    /**
     * The textoNumeroTelefonePagador
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 12
     * @var string
     */
    public $textoNumeroTelefonePagador;
    /**
     * The codigoTipoInscricaoAvalista
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - totalDigits: 1
     * @var int
     */
    public $codigoTipoInscricaoAvalista;
    /**
     * The numeroInscricaoAvalista
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $numeroInscricaoAvalista;
    /**
     * The nomeAvalistaTitulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $nomeAvalistaTitulo;
    /**
     * The codigoChaveUsuario
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $codigoChaveUsuario;
    /**
     * The codigoTipoCanalSolicitacao
     * Meta informations extracted from the WSDL
     * - default: 5
     * - minOccurs: 0
     * - totalDigits: 1
     * @var int
     */
    public $codigoTipoCanalSolicitacao;
    /**
     * Constructor method for requisicao
     * @uses Requisicao::setNumeroConvenio()
     * @uses Requisicao::setNumeroCarteira()
     * @uses Requisicao::setNumeroVariacaoCarteira()
     * @uses Requisicao::setCodigoModalidadeTitulo()
     * @uses Requisicao::setDataEmissaoTitulo()
     * @uses Requisicao::setDataVencimentoTitulo()
     * @uses Requisicao::setValorOriginalTitulo()
     * @uses Requisicao::setCodigoTipoDesconto()
     * @uses Requisicao::setDataDescontoTitulo()
     * @uses Requisicao::setPercentualDescontoTitulo()
     * @uses Requisicao::setValorDescontoTitulo()
     * @uses Requisicao::setValorAbatimentoTitulo()
     * @uses Requisicao::setQuantidadeDiaProtesto()
     * @uses Requisicao::setCodigoTipoJuroMora()
     * @uses Requisicao::setPercentualJuroMoraTitulo()
     * @uses Requisicao::setValorJuroMoraTitulo()
     * @uses Requisicao::setCodigoTipoMulta()
     * @uses Requisicao::setDataMultaTitulo()
     * @uses Requisicao::setPercentualMultaTitulo()
     * @uses Requisicao::setValorMultaTitulo()
     * @uses Requisicao::setCodigoAceiteTitulo()
     * @uses Requisicao::setCodigoTipoTitulo()
     * @uses Requisicao::setTextoDescricaoTipoTitulo()
     * @uses Requisicao::setIndicadorPermissaoRecebimentoParcial()
     * @uses Requisicao::setTextoNumeroTituloBeneficiario()
     * @uses Requisicao::setTextoCampoUtilizacaoBeneficiario()
     * @uses Requisicao::setCodigoTipoContaCaucao()
     * @uses Requisicao::setTextoNumeroTituloCliente()
     * @uses Requisicao::setTextoMensagemBloquetoOcorrencia()
     * @uses Requisicao::setCodigoTipoInscricaoPagador()
     * @uses Requisicao::setNumeroInscricaoPagador()
     * @uses Requisicao::setNomePagador()
     * @uses Requisicao::setTextoEnderecoPagador()
     * @uses Requisicao::setNumeroCepPagador()
     * @uses Requisicao::setNomeMunicipioPagador()
     * @uses Requisicao::setNomeBairroPagador()
     * @uses Requisicao::setSiglaUfPagador()
     * @uses Requisicao::setTextoNumeroTelefonePagador()
     * @uses Requisicao::setCodigoTipoInscricaoAvalista()
     * @uses Requisicao::setNumeroInscricaoAvalista()
     * @uses Requisicao::setNomeAvalistaTitulo()
     * @uses Requisicao::setCodigoChaveUsuario()
     * @uses Requisicao::setCodigoTipoCanalSolicitacao()
     * @param int $numeroConvenio
     * @param int $numeroCarteira
     * @param int $numeroVariacaoCarteira
     * @param int $codigoModalidadeTitulo
     * @param string $dataEmissaoTitulo
     * @param string $dataVencimentoTitulo
     * @param float $valorOriginalTitulo
     * @param int $codigoTipoDesconto
     * @param string $dataDescontoTitulo
     * @param float $percentualDescontoTitulo
     * @param float $valorDescontoTitulo
     * @param float $valorAbatimentoTitulo
     * @param int $quantidadeDiaProtesto
     * @param int $codigoTipoJuroMora
     * @param float $percentualJuroMoraTitulo
     * @param float $valorJuroMoraTitulo
     * @param int $codigoTipoMulta
     * @param string $dataMultaTitulo
     * @param float $percentualMultaTitulo
     * @param float $valorMultaTitulo
     * @param string $codigoAceiteTitulo
     * @param int $codigoTipoTitulo
     * @param string $textoDescricaoTipoTitulo
     * @param string $indicadorPermissaoRecebimentoParcial
     * @param string $textoNumeroTituloBeneficiario
     * @param string $textoCampoUtilizacaoBeneficiario
     * @param int $codigoTipoContaCaucao
     * @param string $textoNumeroTituloCliente
     * @param string $textoMensagemBloquetoOcorrencia
     * @param int $codigoTipoInscricaoPagador
     * @param int $numeroInscricaoPagador
     * @param string $nomePagador
     * @param string $textoEnderecoPagador
     * @param int $numeroCepPagador
     * @param string $nomeMunicipioPagador
     * @param string $nomeBairroPagador
     * @param string $siglaUfPagador
     * @param string $textoNumeroTelefonePagador
     * @param int $codigoTipoInscricaoAvalista
     * @param int $numeroInscricaoAvalista
     * @param string $nomeAvalistaTitulo
     * @param string $codigoChaveUsuario
     * @param int $codigoTipoCanalSolicitacao
     */
    public function __construct($numeroConvenio = null, $numeroCarteira = null, $numeroVariacaoCarteira = null, $codigoModalidadeTitulo = null, $dataEmissaoTitulo = null, $dataVencimentoTitulo = null, $valorOriginalTitulo = 0, $codigoTipoDesconto = null, $dataDescontoTitulo = null, $percentualDescontoTitulo = 0, $valorDescontoTitulo = 0, $valorAbatimentoTitulo = 0, $quantidadeDiaProtesto = 0, $codigoTipoJuroMora = null, $percentualJuroMoraTitulo = 0, $valorJuroMoraTitulo = 0, $codigoTipoMulta = null, $dataMultaTitulo = null, $percentualMultaTitulo = 0, $valorMultaTitulo = 0, $codigoAceiteTitulo = null, $codigoTipoTitulo = 0, $textoDescricaoTipoTitulo = null, $indicadorPermissaoRecebimentoParcial = null, $textoNumeroTituloBeneficiario = null, $textoCampoUtilizacaoBeneficiario = null, $codigoTipoContaCaucao = 0, $textoNumeroTituloCliente = null, $textoMensagemBloquetoOcorrencia = null, $codigoTipoInscricaoPagador = 0, $numeroInscricaoPagador = 0, $nomePagador = null, $textoEnderecoPagador = null, $numeroCepPagador = 0, $nomeMunicipioPagador = null, $nomeBairroPagador = null, $siglaUfPagador = null, $textoNumeroTelefonePagador = null, $codigoTipoInscricaoAvalista = 0, $numeroInscricaoAvalista = 0, $nomeAvalistaTitulo = null, $codigoChaveUsuario = null, $codigoTipoCanalSolicitacao = 5)
    {
        $this
            ->setNumeroConvenio($numeroConvenio)
            ->setNumeroCarteira($numeroCarteira)
            ->setNumeroVariacaoCarteira($numeroVariacaoCarteira)
            ->setCodigoModalidadeTitulo($codigoModalidadeTitulo)
            ->setDataEmissaoTitulo($dataEmissaoTitulo)
            ->setDataVencimentoTitulo($dataVencimentoTitulo)
            ->setValorOriginalTitulo($valorOriginalTitulo)
            ->setCodigoTipoDesconto($codigoTipoDesconto)
            ->setDataDescontoTitulo($dataDescontoTitulo)
            ->setPercentualDescontoTitulo($percentualDescontoTitulo)
            ->setValorDescontoTitulo($valorDescontoTitulo)
            ->setValorAbatimentoTitulo($valorAbatimentoTitulo)
            ->setQuantidadeDiaProtesto($quantidadeDiaProtesto)
            ->setCodigoTipoJuroMora($codigoTipoJuroMora)
            ->setPercentualJuroMoraTitulo($percentualJuroMoraTitulo)
            ->setValorJuroMoraTitulo($valorJuroMoraTitulo)
            ->setCodigoTipoMulta($codigoTipoMulta)
            ->setDataMultaTitulo($dataMultaTitulo)
            ->setPercentualMultaTitulo($percentualMultaTitulo)
            ->setValorMultaTitulo($valorMultaTitulo)
            ->setCodigoAceiteTitulo($codigoAceiteTitulo)
            ->setCodigoTipoTitulo($codigoTipoTitulo)
            ->setTextoDescricaoTipoTitulo($textoDescricaoTipoTitulo)
            ->setIndicadorPermissaoRecebimentoParcial($indicadorPermissaoRecebimentoParcial)
            ->setTextoNumeroTituloBeneficiario($textoNumeroTituloBeneficiario)
            ->setTextoCampoUtilizacaoBeneficiario($textoCampoUtilizacaoBeneficiario)
            ->setCodigoTipoContaCaucao($codigoTipoContaCaucao)
            ->setTextoNumeroTituloCliente($textoNumeroTituloCliente)
            ->setTextoMensagemBloquetoOcorrencia($textoMensagemBloquetoOcorrencia)
            ->setCodigoTipoInscricaoPagador($codigoTipoInscricaoPagador)
            ->setNumeroInscricaoPagador($numeroInscricaoPagador)
            ->setNomePagador($nomePagador)
            ->setTextoEnderecoPagador($textoEnderecoPagador)
            ->setNumeroCepPagador($numeroCepPagador)
            ->setNomeMunicipioPagador($nomeMunicipioPagador)
            ->setNomeBairroPagador($nomeBairroPagador)
            ->setSiglaUfPagador($siglaUfPagador)
            ->setTextoNumeroTelefonePagador($textoNumeroTelefonePagador)
            ->setCodigoTipoInscricaoAvalista($codigoTipoInscricaoAvalista)
            ->setNumeroInscricaoAvalista($numeroInscricaoAvalista)
            ->setNomeAvalistaTitulo($nomeAvalistaTitulo)
            ->setCodigoChaveUsuario($codigoChaveUsuario)
            ->setCodigoTipoCanalSolicitacao($codigoTipoCanalSolicitacao);
    }
    /**
     * Get numeroConvenio value
     * @return int|null
     */
    public function getNumeroConvenio()
    {
        return $this->numeroConvenio;
    }
    /**
     * Set numeroConvenio value
     * @param int $numeroConvenio
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setNumeroConvenio($numeroConvenio = null)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroConvenio) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroConvenio)) !== 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 9 digits, "%d" given', strlen(substr($numeroConvenio, strpos($numeroConvenio, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroConvenio) && !is_numeric($numeroConvenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroConvenio)), __LINE__);
        }
        $this->numeroConvenio = $numeroConvenio;
        return $this;
    }
    /**
     * Get numeroCarteira value
     * @return int|null
     */
    public function getNumeroCarteira()
    {
        return $this->numeroCarteira;
    }
    /**
     * Set numeroCarteira value
     * @param int $numeroCarteira
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setNumeroCarteira($numeroCarteira = null)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroCarteira) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroCarteira)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 digits, "%d" given', strlen(substr($numeroCarteira, strpos($numeroCarteira, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroCarteira) && !is_numeric($numeroCarteira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroCarteira)), __LINE__);
        }
        $this->numeroCarteira = $numeroCarteira;
        return $this;
    }
    /**
     * Get numeroVariacaoCarteira value
     * @return int|null
     */
    public function getNumeroVariacaoCarteira()
    {
        return $this->numeroVariacaoCarteira;
    }
    /**
     * Set numeroVariacaoCarteira value
     * @param int $numeroVariacaoCarteira
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setNumeroVariacaoCarteira($numeroVariacaoCarteira = null)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroVariacaoCarteira) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroVariacaoCarteira)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 digits, "%d" given', strlen(substr($numeroVariacaoCarteira, strpos($numeroVariacaoCarteira, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroVariacaoCarteira) && !is_numeric($numeroVariacaoCarteira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroVariacaoCarteira)), __LINE__);
        }
        $this->numeroVariacaoCarteira = $numeroVariacaoCarteira;
        return $this;
    }
    /**
     * Get codigoModalidadeTitulo value
     * @return int|null
     */
    public function getCodigoModalidadeTitulo()
    {
        return $this->codigoModalidadeTitulo;
    }
    /**
     * Set codigoModalidadeTitulo value
     * @param int $codigoModalidadeTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoModalidadeTitulo($codigoModalidadeTitulo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoModalidadeTitulo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoModalidadeTitulo)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 digits, "%d" given', strlen(substr($codigoModalidadeTitulo, strpos($codigoModalidadeTitulo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoModalidadeTitulo) && !is_numeric($codigoModalidadeTitulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoModalidadeTitulo)), __LINE__);
        }
        $this->codigoModalidadeTitulo = $codigoModalidadeTitulo;
        return $this;
    }
    /**
     * Get dataEmissaoTitulo value
     * @return string|null
     */
    public function getDataEmissaoTitulo()
    {
        return $this->dataEmissaoTitulo;
    }
    /**
     * Set dataEmissaoTitulo value
     * @param string $dataEmissaoTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setDataEmissaoTitulo($dataEmissaoTitulo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dataEmissaoTitulo) && strlen($dataEmissaoTitulo) > 10) || (is_array($dataEmissaoTitulo) && count($dataEmissaoTitulo) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($dataEmissaoTitulo) ? strlen($dataEmissaoTitulo) : count($dataEmissaoTitulo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dataEmissaoTitulo) && !is_string($dataEmissaoTitulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataEmissaoTitulo)), __LINE__);
        }
        $this->dataEmissaoTitulo = $dataEmissaoTitulo;
        return $this;
    }
    /**
     * Get dataVencimentoTitulo value
     * @return string|null
     */
    public function getDataVencimentoTitulo()
    {
        return $this->dataVencimentoTitulo;
    }
    /**
     * Set dataVencimentoTitulo value
     * @param string $dataVencimentoTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setDataVencimentoTitulo($dataVencimentoTitulo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dataVencimentoTitulo) && strlen($dataVencimentoTitulo) > 10) || (is_array($dataVencimentoTitulo) && count($dataVencimentoTitulo) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($dataVencimentoTitulo) ? strlen($dataVencimentoTitulo) : count($dataVencimentoTitulo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dataVencimentoTitulo) && !is_string($dataVencimentoTitulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataVencimentoTitulo)), __LINE__);
        }
        $this->dataVencimentoTitulo = $dataVencimentoTitulo;
        return $this;
    }
    /**
     * Get valorOriginalTitulo value
     * @return float|null
     */
    public function getValorOriginalTitulo()
    {
        return $this->valorOriginalTitulo;
    }
    /**
     * Set valorOriginalTitulo value
     * @param float $valorOriginalTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setValorOriginalTitulo($valorOriginalTitulo = 0)
    {
        // validation for constraint: fractionDigits
        if (is_float($valorOriginalTitulo) && strlen(substr($valorOriginalTitulo, strpos($valorOriginalTitulo, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($valorOriginalTitulo, strpos($valorOriginalTitulo, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($valorOriginalTitulo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $valorOriginalTitulo)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($valorOriginalTitulo, strpos($valorOriginalTitulo, '.')))), __LINE__);
        }
        $this->valorOriginalTitulo = $valorOriginalTitulo;
        return $this;
    }
    /**
     * Get codigoTipoDesconto value
     * @return int|null
     */
    public function getCodigoTipoDesconto()
    {
        return $this->codigoTipoDesconto;
    }
    /**
     * Set codigoTipoDesconto value
     * @param int $codigoTipoDesconto
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoTipoDesconto($codigoTipoDesconto = null)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoTipoDesconto) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoTipoDesconto)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($codigoTipoDesconto, strpos($codigoTipoDesconto, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoTipoDesconto) && !is_numeric($codigoTipoDesconto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoTipoDesconto)), __LINE__);
        }
        $this->codigoTipoDesconto = $codigoTipoDesconto;
        return $this;
    }
    /**
     * Get dataDescontoTitulo value
     * @return string|null
     */
    public function getDataDescontoTitulo()
    {
        return $this->dataDescontoTitulo;
    }
    /**
     * Set dataDescontoTitulo value
     * @param string $dataDescontoTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setDataDescontoTitulo($dataDescontoTitulo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dataDescontoTitulo) && strlen($dataDescontoTitulo) > 10) || (is_array($dataDescontoTitulo) && count($dataDescontoTitulo) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($dataDescontoTitulo) ? strlen($dataDescontoTitulo) : count($dataDescontoTitulo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dataDescontoTitulo) && !is_string($dataDescontoTitulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataDescontoTitulo)), __LINE__);
        }
        $this->dataDescontoTitulo = $dataDescontoTitulo;
        return $this;
    }
    /**
     * Get percentualDescontoTitulo value
     * @return float|null
     */
    public function getPercentualDescontoTitulo()
    {
        return $this->percentualDescontoTitulo;
    }
    /**
     * Set percentualDescontoTitulo value
     * @param float $percentualDescontoTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setPercentualDescontoTitulo($percentualDescontoTitulo = 0)
    {
        // validation for constraint: fractionDigits
        if (is_float($percentualDescontoTitulo) && strlen(substr($percentualDescontoTitulo, strpos($percentualDescontoTitulo, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($percentualDescontoTitulo, strpos($percentualDescontoTitulo, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($percentualDescontoTitulo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $percentualDescontoTitulo)) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 5 digits, "%d" given', strlen(substr($percentualDescontoTitulo, strpos($percentualDescontoTitulo, '.')))), __LINE__);
        }
        $this->percentualDescontoTitulo = $percentualDescontoTitulo;
        return $this;
    }
    /**
     * Get valorDescontoTitulo value
     * @return float|null
     */
    public function getValorDescontoTitulo()
    {
        return $this->valorDescontoTitulo;
    }
    /**
     * Set valorDescontoTitulo value
     * @param float $valorDescontoTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setValorDescontoTitulo($valorDescontoTitulo = 0)
    {
        // validation for constraint: fractionDigits
        if (is_float($valorDescontoTitulo) && strlen(substr($valorDescontoTitulo, strpos($valorDescontoTitulo, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($valorDescontoTitulo, strpos($valorDescontoTitulo, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($valorDescontoTitulo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $valorDescontoTitulo)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($valorDescontoTitulo, strpos($valorDescontoTitulo, '.')))), __LINE__);
        }
        $this->valorDescontoTitulo = $valorDescontoTitulo;
        return $this;
    }
    /**
     * Get valorAbatimentoTitulo value
     * @return float|null
     */
    public function getValorAbatimentoTitulo()
    {
        return $this->valorAbatimentoTitulo;
    }
    /**
     * Set valorAbatimentoTitulo value
     * @param float $valorAbatimentoTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setValorAbatimentoTitulo($valorAbatimentoTitulo = 0)
    {
        // validation for constraint: fractionDigits
        if (is_float($valorAbatimentoTitulo) && strlen(substr($valorAbatimentoTitulo, strpos($valorAbatimentoTitulo, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($valorAbatimentoTitulo, strpos($valorAbatimentoTitulo, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($valorAbatimentoTitulo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $valorAbatimentoTitulo)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($valorAbatimentoTitulo, strpos($valorAbatimentoTitulo, '.')))), __LINE__);
        }
        $this->valorAbatimentoTitulo = $valorAbatimentoTitulo;
        return $this;
    }
    /**
     * Get quantidadeDiaProtesto value
     * @return int|null
     */
    public function getQuantidadeDiaProtesto()
    {
        return $this->quantidadeDiaProtesto;
    }
    /**
     * Set quantidadeDiaProtesto value
     * @param int $quantidadeDiaProtesto
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setQuantidadeDiaProtesto($quantidadeDiaProtesto = 0)
    {
        // validation for constraint: totalDigits
        if (is_float($quantidadeDiaProtesto) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $quantidadeDiaProtesto)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 digits, "%d" given', strlen(substr($quantidadeDiaProtesto, strpos($quantidadeDiaProtesto, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($quantidadeDiaProtesto) && !is_numeric($quantidadeDiaProtesto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantidadeDiaProtesto)), __LINE__);
        }
        $this->quantidadeDiaProtesto = $quantidadeDiaProtesto;
        return $this;
    }
    /**
     * Get codigoTipoJuroMora value
     * @return int|null
     */
    public function getCodigoTipoJuroMora()
    {
        return $this->codigoTipoJuroMora;
    }
    /**
     * Set codigoTipoJuroMora value
     * @param int $codigoTipoJuroMora
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoTipoJuroMora($codigoTipoJuroMora = null)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoTipoJuroMora) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoTipoJuroMora)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($codigoTipoJuroMora, strpos($codigoTipoJuroMora, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoTipoJuroMora) && !is_numeric($codigoTipoJuroMora)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoTipoJuroMora)), __LINE__);
        }
        $this->codigoTipoJuroMora = $codigoTipoJuroMora;
        return $this;
    }
    /**
     * Get percentualJuroMoraTitulo value
     * @return float|null
     */
    public function getPercentualJuroMoraTitulo()
    {
        return $this->percentualJuroMoraTitulo;
    }
    /**
     * Set percentualJuroMoraTitulo value
     * @param float $percentualJuroMoraTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setPercentualJuroMoraTitulo($percentualJuroMoraTitulo = 0)
    {
        // validation for constraint: fractionDigits
        if (is_float($percentualJuroMoraTitulo) && strlen(substr($percentualJuroMoraTitulo, strpos($percentualJuroMoraTitulo, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($percentualJuroMoraTitulo, strpos($percentualJuroMoraTitulo, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($percentualJuroMoraTitulo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $percentualJuroMoraTitulo)) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 5 digits, "%d" given', strlen(substr($percentualJuroMoraTitulo, strpos($percentualJuroMoraTitulo, '.')))), __LINE__);
        }
        $this->percentualJuroMoraTitulo = $percentualJuroMoraTitulo;
        return $this;
    }
    /**
     * Get valorJuroMoraTitulo value
     * @return float|null
     */
    public function getValorJuroMoraTitulo()
    {
        return $this->valorJuroMoraTitulo;
    }
    /**
     * Set valorJuroMoraTitulo value
     * @param float $valorJuroMoraTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setValorJuroMoraTitulo($valorJuroMoraTitulo = 0)
    {
        // validation for constraint: fractionDigits
        if (is_float($valorJuroMoraTitulo) && strlen(substr($valorJuroMoraTitulo, strpos($valorJuroMoraTitulo, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($valorJuroMoraTitulo, strpos($valorJuroMoraTitulo, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($valorJuroMoraTitulo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $valorJuroMoraTitulo)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($valorJuroMoraTitulo, strpos($valorJuroMoraTitulo, '.')))), __LINE__);
        }
        $this->valorJuroMoraTitulo = $valorJuroMoraTitulo;
        return $this;
    }
    /**
     * Get codigoTipoMulta value
     * @return int|null
     */
    public function getCodigoTipoMulta()
    {
        return $this->codigoTipoMulta;
    }
    /**
     * Set codigoTipoMulta value
     * @param int $codigoTipoMulta
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoTipoMulta($codigoTipoMulta = null)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoTipoMulta) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoTipoMulta)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($codigoTipoMulta, strpos($codigoTipoMulta, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoTipoMulta) && !is_numeric($codigoTipoMulta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoTipoMulta)), __LINE__);
        }
        $this->codigoTipoMulta = $codigoTipoMulta;
        return $this;
    }
    /**
     * Get dataMultaTitulo value
     * @return string|null
     */
    public function getDataMultaTitulo()
    {
        return $this->dataMultaTitulo;
    }
    /**
     * Set dataMultaTitulo value
     * @param string $dataMultaTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setDataMultaTitulo($dataMultaTitulo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dataMultaTitulo) && strlen($dataMultaTitulo) > 10) || (is_array($dataMultaTitulo) && count($dataMultaTitulo) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($dataMultaTitulo) ? strlen($dataMultaTitulo) : count($dataMultaTitulo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dataMultaTitulo) && !is_string($dataMultaTitulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataMultaTitulo)), __LINE__);
        }
        $this->dataMultaTitulo = $dataMultaTitulo;
        return $this;
    }
    /**
     * Get percentualMultaTitulo value
     * @return float|null
     */
    public function getPercentualMultaTitulo()
    {
        return $this->percentualMultaTitulo;
    }
    /**
     * Set percentualMultaTitulo value
     * @param float $percentualMultaTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setPercentualMultaTitulo($percentualMultaTitulo = 0)
    {
        // validation for constraint: fractionDigits
        if (is_float($percentualMultaTitulo) && strlen(substr($percentualMultaTitulo, strpos($percentualMultaTitulo, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($percentualMultaTitulo, strpos($percentualMultaTitulo, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($percentualMultaTitulo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $percentualMultaTitulo)) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 5 digits, "%d" given', strlen(substr($percentualMultaTitulo, strpos($percentualMultaTitulo, '.')))), __LINE__);
        }
        $this->percentualMultaTitulo = $percentualMultaTitulo;
        return $this;
    }
    /**
     * Get valorMultaTitulo value
     * @return float|null
     */
    public function getValorMultaTitulo()
    {
        return $this->valorMultaTitulo;
    }
    /**
     * Set valorMultaTitulo value
     * @param float $valorMultaTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setValorMultaTitulo($valorMultaTitulo = 0)
    {
        // validation for constraint: fractionDigits
        if (is_float($valorMultaTitulo) && strlen(substr($valorMultaTitulo, strpos($valorMultaTitulo, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($valorMultaTitulo, strpos($valorMultaTitulo, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($valorMultaTitulo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $valorMultaTitulo)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($valorMultaTitulo, strpos($valorMultaTitulo, '.')))), __LINE__);
        }
        $this->valorMultaTitulo = $valorMultaTitulo;
        return $this;
    }
    /**
     * Get codigoAceiteTitulo value
     * @return string|null
     */
    public function getCodigoAceiteTitulo()
    {
        return $this->codigoAceiteTitulo;
    }
    /**
     * Set codigoAceiteTitulo value
     * @param string $codigoAceiteTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoAceiteTitulo($codigoAceiteTitulo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codigoAceiteTitulo) && strlen($codigoAceiteTitulo) > 1) || (is_array($codigoAceiteTitulo) && count($codigoAceiteTitulo) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($codigoAceiteTitulo) ? strlen($codigoAceiteTitulo) : count($codigoAceiteTitulo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoAceiteTitulo) && !is_string($codigoAceiteTitulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoAceiteTitulo)), __LINE__);
        }
        $this->codigoAceiteTitulo = $codigoAceiteTitulo;
        return $this;
    }
    /**
     * Get codigoTipoTitulo value
     * @return int|null
     */
    public function getCodigoTipoTitulo()
    {
        return $this->codigoTipoTitulo;
    }
    /**
     * Set codigoTipoTitulo value
     * @param int $codigoTipoTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoTipoTitulo($codigoTipoTitulo = 0)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoTipoTitulo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoTipoTitulo)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 digits, "%d" given', strlen(substr($codigoTipoTitulo, strpos($codigoTipoTitulo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoTipoTitulo) && !is_numeric($codigoTipoTitulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoTipoTitulo)), __LINE__);
        }
        $this->codigoTipoTitulo = $codigoTipoTitulo;
        return $this;
    }
    /**
     * Get textoDescricaoTipoTitulo value
     * @return string|null
     */
    public function getTextoDescricaoTipoTitulo()
    {
        return $this->textoDescricaoTipoTitulo;
    }
    /**
     * Set textoDescricaoTipoTitulo value
     * @param string $textoDescricaoTipoTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setTextoDescricaoTipoTitulo($textoDescricaoTipoTitulo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textoDescricaoTipoTitulo) && strlen($textoDescricaoTipoTitulo) > 30) || (is_array($textoDescricaoTipoTitulo) && count($textoDescricaoTipoTitulo) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($textoDescricaoTipoTitulo) ? strlen($textoDescricaoTipoTitulo) : count($textoDescricaoTipoTitulo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textoDescricaoTipoTitulo) && !is_string($textoDescricaoTipoTitulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textoDescricaoTipoTitulo)), __LINE__);
        }
        $this->textoDescricaoTipoTitulo = $textoDescricaoTipoTitulo;
        return $this;
    }
    /**
     * Get indicadorPermissaoRecebimentoParcial value
     * @return string|null
     */
    public function getIndicadorPermissaoRecebimentoParcial()
    {
        return $this->indicadorPermissaoRecebimentoParcial;
    }
    /**
     * Set indicadorPermissaoRecebimentoParcial value
     * @param string $indicadorPermissaoRecebimentoParcial
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setIndicadorPermissaoRecebimentoParcial($indicadorPermissaoRecebimentoParcial = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($indicadorPermissaoRecebimentoParcial) && strlen($indicadorPermissaoRecebimentoParcial) > 1) || (is_array($indicadorPermissaoRecebimentoParcial) && count($indicadorPermissaoRecebimentoParcial) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($indicadorPermissaoRecebimentoParcial) ? strlen($indicadorPermissaoRecebimentoParcial) : count($indicadorPermissaoRecebimentoParcial)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($indicadorPermissaoRecebimentoParcial) && !is_string($indicadorPermissaoRecebimentoParcial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indicadorPermissaoRecebimentoParcial)), __LINE__);
        }
        $this->indicadorPermissaoRecebimentoParcial = $indicadorPermissaoRecebimentoParcial;
        return $this;
    }
    /**
     * Get textoNumeroTituloBeneficiario value
     * @return string|null
     */
    public function getTextoNumeroTituloBeneficiario()
    {
        return $this->textoNumeroTituloBeneficiario;
    }
    /**
     * Set textoNumeroTituloBeneficiario value
     * @param string $textoNumeroTituloBeneficiario
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setTextoNumeroTituloBeneficiario($textoNumeroTituloBeneficiario = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textoNumeroTituloBeneficiario) && strlen($textoNumeroTituloBeneficiario) > 15) || (is_array($textoNumeroTituloBeneficiario) && count($textoNumeroTituloBeneficiario) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($textoNumeroTituloBeneficiario) ? strlen($textoNumeroTituloBeneficiario) : count($textoNumeroTituloBeneficiario)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textoNumeroTituloBeneficiario) && !is_string($textoNumeroTituloBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textoNumeroTituloBeneficiario)), __LINE__);
        }
        $this->textoNumeroTituloBeneficiario = $textoNumeroTituloBeneficiario;
        return $this;
    }
    /**
     * Get textoCampoUtilizacaoBeneficiario value
     * @return string|null
     */
    public function getTextoCampoUtilizacaoBeneficiario()
    {
        return $this->textoCampoUtilizacaoBeneficiario;
    }
    /**
     * Set textoCampoUtilizacaoBeneficiario value
     * @param string $textoCampoUtilizacaoBeneficiario
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setTextoCampoUtilizacaoBeneficiario($textoCampoUtilizacaoBeneficiario = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textoCampoUtilizacaoBeneficiario) && strlen($textoCampoUtilizacaoBeneficiario) > 25) || (is_array($textoCampoUtilizacaoBeneficiario) && count($textoCampoUtilizacaoBeneficiario) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($textoCampoUtilizacaoBeneficiario) ? strlen($textoCampoUtilizacaoBeneficiario) : count($textoCampoUtilizacaoBeneficiario)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textoCampoUtilizacaoBeneficiario) && !is_string($textoCampoUtilizacaoBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textoCampoUtilizacaoBeneficiario)), __LINE__);
        }
        $this->textoCampoUtilizacaoBeneficiario = $textoCampoUtilizacaoBeneficiario;
        return $this;
    }
    /**
     * Get codigoTipoContaCaucao value
     * @return int|null
     */
    public function getCodigoTipoContaCaucao()
    {
        return $this->codigoTipoContaCaucao;
    }
    /**
     * Set codigoTipoContaCaucao value
     * @param int $codigoTipoContaCaucao
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoTipoContaCaucao($codigoTipoContaCaucao = 0)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoTipoContaCaucao) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoTipoContaCaucao)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($codigoTipoContaCaucao, strpos($codigoTipoContaCaucao, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoTipoContaCaucao) && !is_numeric($codigoTipoContaCaucao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoTipoContaCaucao)), __LINE__);
        }
        $this->codigoTipoContaCaucao = $codigoTipoContaCaucao;
        return $this;
    }
    /**
     * Get textoNumeroTituloCliente value
     * @return string|null
     */
    public function getTextoNumeroTituloCliente()
    {
        return $this->textoNumeroTituloCliente;
    }
    /**
     * Set textoNumeroTituloCliente value
     * @param string $textoNumeroTituloCliente
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setTextoNumeroTituloCliente($textoNumeroTituloCliente = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textoNumeroTituloCliente) && strlen($textoNumeroTituloCliente) > 20) || (is_array($textoNumeroTituloCliente) && count($textoNumeroTituloCliente) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($textoNumeroTituloCliente) ? strlen($textoNumeroTituloCliente) : count($textoNumeroTituloCliente)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textoNumeroTituloCliente) && !is_string($textoNumeroTituloCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textoNumeroTituloCliente)), __LINE__);
        }
        $this->textoNumeroTituloCliente = $textoNumeroTituloCliente;
        return $this;
    }
    /**
     * Get textoMensagemBloquetoOcorrencia value
     * @return string|null
     */
    public function getTextoMensagemBloquetoOcorrencia()
    {
        return $this->textoMensagemBloquetoOcorrencia;
    }
    /**
     * Set textoMensagemBloquetoOcorrencia value
     * @param string $textoMensagemBloquetoOcorrencia
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setTextoMensagemBloquetoOcorrencia($textoMensagemBloquetoOcorrencia = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textoMensagemBloquetoOcorrencia) && strlen($textoMensagemBloquetoOcorrencia) > 220) || (is_array($textoMensagemBloquetoOcorrencia) && count($textoMensagemBloquetoOcorrencia) > 220)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 220 element(s) or a scalar of 220 character(s) at most, "%d" length given', is_scalar($textoMensagemBloquetoOcorrencia) ? strlen($textoMensagemBloquetoOcorrencia) : count($textoMensagemBloquetoOcorrencia)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textoMensagemBloquetoOcorrencia) && !is_string($textoMensagemBloquetoOcorrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textoMensagemBloquetoOcorrencia)), __LINE__);
        }
        $this->textoMensagemBloquetoOcorrencia = $textoMensagemBloquetoOcorrencia;
        return $this;
    }
    /**
     * Get codigoTipoInscricaoPagador value
     * @return int|null
     */
    public function getCodigoTipoInscricaoPagador()
    {
        return $this->codigoTipoInscricaoPagador;
    }
    /**
     * Set codigoTipoInscricaoPagador value
     * @param int $codigoTipoInscricaoPagador
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoTipoInscricaoPagador($codigoTipoInscricaoPagador = 0)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoTipoInscricaoPagador) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoTipoInscricaoPagador)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($codigoTipoInscricaoPagador, strpos($codigoTipoInscricaoPagador, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoTipoInscricaoPagador) && !is_numeric($codigoTipoInscricaoPagador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoTipoInscricaoPagador)), __LINE__);
        }
        $this->codigoTipoInscricaoPagador = $codigoTipoInscricaoPagador;
        return $this;
    }
    /**
     * Get numeroInscricaoPagador value
     * @return int|null
     */
    public function getNumeroInscricaoPagador()
    {
        return $this->numeroInscricaoPagador;
    }
    /**
     * Set numeroInscricaoPagador value
     * @param int $numeroInscricaoPagador
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setNumeroInscricaoPagador($numeroInscricaoPagador = 0)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroInscricaoPagador) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroInscricaoPagador)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($numeroInscricaoPagador, strpos($numeroInscricaoPagador, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroInscricaoPagador) && !is_numeric($numeroInscricaoPagador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroInscricaoPagador)), __LINE__);
        }
        $this->numeroInscricaoPagador = $numeroInscricaoPagador;
        return $this;
    }
    /**
     * Get nomePagador value
     * @return string|null
     */
    public function getNomePagador()
    {
        return $this->nomePagador;
    }
    /**
     * Set nomePagador value
     * @param string $nomePagador
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setNomePagador($nomePagador = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nomePagador) && strlen($nomePagador) > 60) || (is_array($nomePagador) && count($nomePagador) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($nomePagador) ? strlen($nomePagador) : count($nomePagador)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nomePagador) && !is_string($nomePagador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomePagador)), __LINE__);
        }
        $this->nomePagador = $nomePagador;
        return $this;
    }
    /**
     * Get textoEnderecoPagador value
     * @return string|null
     */
    public function getTextoEnderecoPagador()
    {
        return $this->textoEnderecoPagador;
    }
    /**
     * Set textoEnderecoPagador value
     * @param string $textoEnderecoPagador
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setTextoEnderecoPagador($textoEnderecoPagador = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textoEnderecoPagador) && strlen($textoEnderecoPagador) > 60) || (is_array($textoEnderecoPagador) && count($textoEnderecoPagador) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($textoEnderecoPagador) ? strlen($textoEnderecoPagador) : count($textoEnderecoPagador)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textoEnderecoPagador) && !is_string($textoEnderecoPagador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textoEnderecoPagador)), __LINE__);
        }
        $this->textoEnderecoPagador = $textoEnderecoPagador;
        return $this;
    }
    /**
     * Get numeroCepPagador value
     * @return int|null
     */
    public function getNumeroCepPagador()
    {
        return $this->numeroCepPagador;
    }
    /**
     * Set numeroCepPagador value
     * @param int $numeroCepPagador
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setNumeroCepPagador($numeroCepPagador = 0)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroCepPagador) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroCepPagador)) !== 8) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 8 digits, "%d" given', strlen(substr($numeroCepPagador, strpos($numeroCepPagador, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroCepPagador) && !is_numeric($numeroCepPagador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroCepPagador)), __LINE__);
        }
        $this->numeroCepPagador = $numeroCepPagador;
        return $this;
    }
    /**
     * Get nomeMunicipioPagador value
     * @return string|null
     */
    public function getNomeMunicipioPagador()
    {
        return $this->nomeMunicipioPagador;
    }
    /**
     * Set nomeMunicipioPagador value
     * @param string $nomeMunicipioPagador
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setNomeMunicipioPagador($nomeMunicipioPagador = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nomeMunicipioPagador) && strlen($nomeMunicipioPagador) > 20) || (is_array($nomeMunicipioPagador) && count($nomeMunicipioPagador) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($nomeMunicipioPagador) ? strlen($nomeMunicipioPagador) : count($nomeMunicipioPagador)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nomeMunicipioPagador) && !is_string($nomeMunicipioPagador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeMunicipioPagador)), __LINE__);
        }
        $this->nomeMunicipioPagador = $nomeMunicipioPagador;
        return $this;
    }
    /**
     * Get nomeBairroPagador value
     * @return string|null
     */
    public function getNomeBairroPagador()
    {
        return $this->nomeBairroPagador;
    }
    /**
     * Set nomeBairroPagador value
     * @param string $nomeBairroPagador
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setNomeBairroPagador($nomeBairroPagador = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nomeBairroPagador) && strlen($nomeBairroPagador) > 20) || (is_array($nomeBairroPagador) && count($nomeBairroPagador) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($nomeBairroPagador) ? strlen($nomeBairroPagador) : count($nomeBairroPagador)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nomeBairroPagador) && !is_string($nomeBairroPagador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeBairroPagador)), __LINE__);
        }
        $this->nomeBairroPagador = $nomeBairroPagador;
        return $this;
    }
    /**
     * Get siglaUfPagador value
     * @return string|null
     */
    public function getSiglaUfPagador()
    {
        return $this->siglaUfPagador;
    }
    /**
     * Set siglaUfPagador value
     * @param string $siglaUfPagador
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setSiglaUfPagador($siglaUfPagador = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($siglaUfPagador) && strlen($siglaUfPagador) > 2) || (is_array($siglaUfPagador) && count($siglaUfPagador) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($siglaUfPagador) ? strlen($siglaUfPagador) : count($siglaUfPagador)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($siglaUfPagador) && !is_string($siglaUfPagador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siglaUfPagador)), __LINE__);
        }
        $this->siglaUfPagador = $siglaUfPagador;
        return $this;
    }
    /**
     * Get textoNumeroTelefonePagador value
     * @return string|null
     */
    public function getTextoNumeroTelefonePagador()
    {
        return $this->textoNumeroTelefonePagador;
    }
    /**
     * Set textoNumeroTelefonePagador value
     * @param string $textoNumeroTelefonePagador
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setTextoNumeroTelefonePagador($textoNumeroTelefonePagador = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textoNumeroTelefonePagador) && strlen($textoNumeroTelefonePagador) > 12) || (is_array($textoNumeroTelefonePagador) && count($textoNumeroTelefonePagador) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($textoNumeroTelefonePagador) ? strlen($textoNumeroTelefonePagador) : count($textoNumeroTelefonePagador)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textoNumeroTelefonePagador) && !is_string($textoNumeroTelefonePagador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textoNumeroTelefonePagador)), __LINE__);
        }
        $this->textoNumeroTelefonePagador = $textoNumeroTelefonePagador;
        return $this;
    }
    /**
     * Get codigoTipoInscricaoAvalista value
     * @return int|null
     */
    public function getCodigoTipoInscricaoAvalista()
    {
        return $this->codigoTipoInscricaoAvalista;
    }
    /**
     * Set codigoTipoInscricaoAvalista value
     * @param int $codigoTipoInscricaoAvalista
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoTipoInscricaoAvalista($codigoTipoInscricaoAvalista = 0)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoTipoInscricaoAvalista) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoTipoInscricaoAvalista)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($codigoTipoInscricaoAvalista, strpos($codigoTipoInscricaoAvalista, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoTipoInscricaoAvalista) && !is_numeric($codigoTipoInscricaoAvalista)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoTipoInscricaoAvalista)), __LINE__);
        }
        $this->codigoTipoInscricaoAvalista = $codigoTipoInscricaoAvalista;
        return $this;
    }
    /**
     * Get numeroInscricaoAvalista value
     * @return int|null
     */
    public function getNumeroInscricaoAvalista()
    {
        return $this->numeroInscricaoAvalista;
    }
    /**
     * Set numeroInscricaoAvalista value
     * @param int $numeroInscricaoAvalista
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setNumeroInscricaoAvalista($numeroInscricaoAvalista = 0)
    {
        // validation for constraint: totalDigits
        if (is_float($numeroInscricaoAvalista) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $numeroInscricaoAvalista)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($numeroInscricaoAvalista, strpos($numeroInscricaoAvalista, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numeroInscricaoAvalista) && !is_numeric($numeroInscricaoAvalista)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroInscricaoAvalista)), __LINE__);
        }
        $this->numeroInscricaoAvalista = $numeroInscricaoAvalista;
        return $this;
    }
    /**
     * Get nomeAvalistaTitulo value
     * @return string|null
     */
    public function getNomeAvalistaTitulo()
    {
        return $this->nomeAvalistaTitulo;
    }
    /**
     * Set nomeAvalistaTitulo value
     * @param string $nomeAvalistaTitulo
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setNomeAvalistaTitulo($nomeAvalistaTitulo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nomeAvalistaTitulo) && strlen($nomeAvalistaTitulo) > 60) || (is_array($nomeAvalistaTitulo) && count($nomeAvalistaTitulo) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($nomeAvalistaTitulo) ? strlen($nomeAvalistaTitulo) : count($nomeAvalistaTitulo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nomeAvalistaTitulo) && !is_string($nomeAvalistaTitulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeAvalistaTitulo)), __LINE__);
        }
        $this->nomeAvalistaTitulo = $nomeAvalistaTitulo;
        return $this;
    }
    /**
     * Get codigoChaveUsuario value
     * @return string|null
     */
    public function getCodigoChaveUsuario()
    {
        return $this->codigoChaveUsuario;
    }
    /**
     * Set codigoChaveUsuario value
     * @param string $codigoChaveUsuario
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoChaveUsuario($codigoChaveUsuario = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codigoChaveUsuario) && strlen($codigoChaveUsuario) > 8) || (is_array($codigoChaveUsuario) && count($codigoChaveUsuario) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($codigoChaveUsuario) ? strlen($codigoChaveUsuario) : count($codigoChaveUsuario)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoChaveUsuario) && !is_string($codigoChaveUsuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoChaveUsuario)), __LINE__);
        }
        $this->codigoChaveUsuario = $codigoChaveUsuario;
        return $this;
    }
    /**
     * Get codigoTipoCanalSolicitacao value
     * @return int|null
     */
    public function getCodigoTipoCanalSolicitacao()
    {
        return $this->codigoTipoCanalSolicitacao;
    }
    /**
     * Set codigoTipoCanalSolicitacao value
     * @param int $codigoTipoCanalSolicitacao
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public function setCodigoTipoCanalSolicitacao($codigoTipoCanalSolicitacao = 5)
    {
        // validation for constraint: totalDigits
        if (is_float($codigoTipoCanalSolicitacao) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $codigoTipoCanalSolicitacao)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($codigoTipoCanalSolicitacao, strpos($codigoTipoCanalSolicitacao, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($codigoTipoCanalSolicitacao) && !is_numeric($codigoTipoCanalSolicitacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoTipoCanalSolicitacao)), __LINE__);
        }
        $this->codigoTipoCanalSolicitacao = $codigoTipoCanalSolicitacao;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \/meuapp/teste\StructType\Requisicao
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
