<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Client StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Client
 * @subpackage Structs
 */
class Client extends AbstractStructBase
{
    /**
     * The ClientCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCode;
    /**
     * The ClientDesignation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientDesignation;
    /**
     * The PersonneNom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonneNom;
    /**
     * The PersonnePrenom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonnePrenom;
    /**
     * The RelationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationCode;
    /**
     * Constructor method for Client
     * @uses Client::setClientCode()
     * @uses Client::setClientDesignation()
     * @uses Client::setPersonneNom()
     * @uses Client::setPersonnePrenom()
     * @uses Client::setRelationCode()
     * @param string $clientCode
     * @param string $clientDesignation
     * @param string $personneNom
     * @param string $personnePrenom
     * @param string $relationCode
     */
    public function __construct($clientCode = null, $clientDesignation = null, $personneNom = null, $personnePrenom = null, $relationCode = null)
    {
        $this
            ->setClientCode($clientCode)
            ->setClientDesignation($clientDesignation)
            ->setPersonneNom($personneNom)
            ->setPersonnePrenom($personnePrenom)
            ->setRelationCode($relationCode);
    }
    /**
     * Get ClientCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCode()
    {
        return isset($this->ClientCode) ? $this->ClientCode : null;
    }
    /**
     * Set ClientCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCode
     * @return \StructType\Client
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientCode)), __LINE__);
        }
        if (is_null($clientCode) || (is_array($clientCode) && empty($clientCode))) {
            unset($this->ClientCode);
        } else {
            $this->ClientCode = $clientCode;
        }
        return $this;
    }
    /**
     * Get ClientDesignation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientDesignation()
    {
        return isset($this->ClientDesignation) ? $this->ClientDesignation : null;
    }
    /**
     * Set ClientDesignation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientDesignation
     * @return \StructType\Client
     */
    public function setClientDesignation($clientDesignation = null)
    {
        // validation for constraint: string
        if (!is_null($clientDesignation) && !is_string($clientDesignation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientDesignation)), __LINE__);
        }
        if (is_null($clientDesignation) || (is_array($clientDesignation) && empty($clientDesignation))) {
            unset($this->ClientDesignation);
        } else {
            $this->ClientDesignation = $clientDesignation;
        }
        return $this;
    }
    /**
     * Get PersonneNom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonneNom()
    {
        return isset($this->PersonneNom) ? $this->PersonneNom : null;
    }
    /**
     * Set PersonneNom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personneNom
     * @return \StructType\Client
     */
    public function setPersonneNom($personneNom = null)
    {
        // validation for constraint: string
        if (!is_null($personneNom) && !is_string($personneNom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personneNom)), __LINE__);
        }
        if (is_null($personneNom) || (is_array($personneNom) && empty($personneNom))) {
            unset($this->PersonneNom);
        } else {
            $this->PersonneNom = $personneNom;
        }
        return $this;
    }
    /**
     * Get PersonnePrenom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonnePrenom()
    {
        return isset($this->PersonnePrenom) ? $this->PersonnePrenom : null;
    }
    /**
     * Set PersonnePrenom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personnePrenom
     * @return \StructType\Client
     */
    public function setPersonnePrenom($personnePrenom = null)
    {
        // validation for constraint: string
        if (!is_null($personnePrenom) && !is_string($personnePrenom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personnePrenom)), __LINE__);
        }
        if (is_null($personnePrenom) || (is_array($personnePrenom) && empty($personnePrenom))) {
            unset($this->PersonnePrenom);
        } else {
            $this->PersonnePrenom = $personnePrenom;
        }
        return $this;
    }
    /**
     * Get RelationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationCode()
    {
        return isset($this->RelationCode) ? $this->RelationCode : null;
    }
    /**
     * Set RelationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationCode
     * @return \StructType\Client
     */
    public function setRelationCode($relationCode = null)
    {
        // validation for constraint: string
        if (!is_null($relationCode) && !is_string($relationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relationCode)), __LINE__);
        }
        if (is_null($relationCode) || (is_array($relationCode) && empty($relationCode))) {
            unset($this->RelationCode);
        } else {
            $this->RelationCode = $relationCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Client
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
