<?php

namespace Geissweb\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkVat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geissweb\StructType\CheckVat $parameters
     * @return \Geissweb\StructType\CheckVatResponse|bool
     */
    public function checkVat(\Geissweb\StructType\CheckVat $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkVat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkVatApprox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geissweb\StructType\CheckVatApprox $parameters
     * @return \Geissweb\StructType\CheckVatApproxResponse|bool
     */
    public function checkVatApprox(\Geissweb\StructType\CheckVatApprox $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkVatApprox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geissweb\StructType\CheckVatApproxResponse|\Geissweb\StructType\CheckVatResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
