<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VirtualPos StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:VirtualPos
 * @subpackage Structs
 */
class VirtualPos extends AbstractStructBase
{
    /**
     * The ComissionRates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfComissionRate
     */
    public $ComissionRates;
    /**
     * The DefaultPosComissionRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ComissionRate
     */
    public $DefaultPosComissionRate;
    /**
     * The IsDefaultPos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDefaultPos;
    /**
     * The VPosId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VPosId;
    /**
     * The VPosName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VPosName;
    /**
     * Constructor method for VirtualPos
     * @uses VirtualPos::setComissionRates()
     * @uses VirtualPos::setDefaultPosComissionRate()
     * @uses VirtualPos::setIsDefaultPos()
     * @uses VirtualPos::setVPosId()
     * @uses VirtualPos::setVPosName()
     * @param \ArrayType\ArrayOfComissionRate $comissionRates
     * @param \StructType\ComissionRate $defaultPosComissionRate
     * @param bool $isDefaultPos
     * @param int $vPosId
     * @param string $vPosName
     */
    public function __construct(\ArrayType\ArrayOfComissionRate $comissionRates = null, \StructType\ComissionRate $defaultPosComissionRate = null, $isDefaultPos = null, $vPosId = null, $vPosName = null)
    {
        $this
            ->setComissionRates($comissionRates)
            ->setDefaultPosComissionRate($defaultPosComissionRate)
            ->setIsDefaultPos($isDefaultPos)
            ->setVPosId($vPosId)
            ->setVPosName($vPosName);
    }
    /**
     * Get ComissionRates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfComissionRate|null
     */
    public function getComissionRates()
    {
        return isset($this->ComissionRates) ? $this->ComissionRates : null;
    }
    /**
     * Set ComissionRates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfComissionRate $comissionRates
     * @return \StructType\VirtualPos
     */
    public function setComissionRates(\ArrayType\ArrayOfComissionRate $comissionRates = null)
    {
        if (is_null($comissionRates) || (is_array($comissionRates) && empty($comissionRates))) {
            unset($this->ComissionRates);
        } else {
            $this->ComissionRates = $comissionRates;
        }
        return $this;
    }
    /**
     * Get DefaultPosComissionRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ComissionRate|null
     */
    public function getDefaultPosComissionRate()
    {
        return isset($this->DefaultPosComissionRate) ? $this->DefaultPosComissionRate : null;
    }
    /**
     * Set DefaultPosComissionRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ComissionRate $defaultPosComissionRate
     * @return \StructType\VirtualPos
     */
    public function setDefaultPosComissionRate(\StructType\ComissionRate $defaultPosComissionRate = null)
    {
        if (is_null($defaultPosComissionRate) || (is_array($defaultPosComissionRate) && empty($defaultPosComissionRate))) {
            unset($this->DefaultPosComissionRate);
        } else {
            $this->DefaultPosComissionRate = $defaultPosComissionRate;
        }
        return $this;
    }
    /**
     * Get IsDefaultPos value
     * @return bool|null
     */
    public function getIsDefaultPos()
    {
        return $this->IsDefaultPos;
    }
    /**
     * Set IsDefaultPos value
     * @param bool $isDefaultPos
     * @return \StructType\VirtualPos
     */
    public function setIsDefaultPos($isDefaultPos = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefaultPos) && !is_bool($isDefaultPos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDefaultPos)), __LINE__);
        }
        $this->IsDefaultPos = $isDefaultPos;
        return $this;
    }
    /**
     * Get VPosId value
     * @return int|null
     */
    public function getVPosId()
    {
        return $this->VPosId;
    }
    /**
     * Set VPosId value
     * @param int $vPosId
     * @return \StructType\VirtualPos
     */
    public function setVPosId($vPosId = null)
    {
        // validation for constraint: int
        if (!is_null($vPosId) && !is_numeric($vPosId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vPosId)), __LINE__);
        }
        $this->VPosId = $vPosId;
        return $this;
    }
    /**
     * Get VPosName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVPosName()
    {
        return isset($this->VPosName) ? $this->VPosName : null;
    }
    /**
     * Set VPosName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vPosName
     * @return \StructType\VirtualPos
     */
    public function setVPosName($vPosName = null)
    {
        // validation for constraint: string
        if (!is_null($vPosName) && !is_string($vPosName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vPosName)), __LINE__);
        }
        if (is_null($vPosName) || (is_array($vPosName) && empty($vPosName))) {
            unset($this->VPosName);
        } else {
            $this->VPosName = $vPosName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VirtualPos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
