<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusInquiryTransaction StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StatusInquiryTransaction
 * @subpackage Structs
 */
class StatusInquiryTransaction extends AbstractStructBase
{
    /**
     * The AuthCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthCode;
    /**
     * The ClientReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientReferenceCode;
    /**
     * The HostKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HostKey;
    /**
     * The Is3D
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Is3D;
    /**
     * The IsSuccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSuccess;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentDate;
    /**
     * The ProvisionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProvisionNumber;
    /**
     * The ReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceCode;
    /**
     * The TransactionStatusId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionStatusId;
    /**
     * Constructor method for StatusInquiryTransaction
     * @uses StatusInquiryTransaction::setAuthCode()
     * @uses StatusInquiryTransaction::setClientReferenceCode()
     * @uses StatusInquiryTransaction::setHostKey()
     * @uses StatusInquiryTransaction::setIs3D()
     * @uses StatusInquiryTransaction::setIsSuccess()
     * @uses StatusInquiryTransaction::setPaymentDate()
     * @uses StatusInquiryTransaction::setProvisionNumber()
     * @uses StatusInquiryTransaction::setReferenceCode()
     * @uses StatusInquiryTransaction::setTransactionStatusId()
     * @param string $authCode
     * @param string $clientReferenceCode
     * @param string $hostKey
     * @param bool $is3D
     * @param bool $isSuccess
     * @param string $paymentDate
     * @param string $provisionNumber
     * @param string $referenceCode
     * @param int $transactionStatusId
     */
    public function __construct($authCode = null, $clientReferenceCode = null, $hostKey = null, $is3D = null, $isSuccess = null, $paymentDate = null, $provisionNumber = null, $referenceCode = null, $transactionStatusId = null)
    {
        $this
            ->setAuthCode($authCode)
            ->setClientReferenceCode($clientReferenceCode)
            ->setHostKey($hostKey)
            ->setIs3D($is3D)
            ->setIsSuccess($isSuccess)
            ->setPaymentDate($paymentDate)
            ->setProvisionNumber($provisionNumber)
            ->setReferenceCode($referenceCode)
            ->setTransactionStatusId($transactionStatusId);
    }
    /**
     * Get AuthCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthCode()
    {
        return isset($this->AuthCode) ? $this->AuthCode : null;
    }
    /**
     * Set AuthCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authCode
     * @return \StructType\StatusInquiryTransaction
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authCode)), __LINE__);
        }
        if (is_null($authCode) || (is_array($authCode) && empty($authCode))) {
            unset($this->AuthCode);
        } else {
            $this->AuthCode = $authCode;
        }
        return $this;
    }
    /**
     * Get ClientReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReferenceCode()
    {
        return isset($this->ClientReferenceCode) ? $this->ClientReferenceCode : null;
    }
    /**
     * Set ClientReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReferenceCode
     * @return \StructType\StatusInquiryTransaction
     */
    public function setClientReferenceCode($clientReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientReferenceCode) && !is_string($clientReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReferenceCode)), __LINE__);
        }
        if (is_null($clientReferenceCode) || (is_array($clientReferenceCode) && empty($clientReferenceCode))) {
            unset($this->ClientReferenceCode);
        } else {
            $this->ClientReferenceCode = $clientReferenceCode;
        }
        return $this;
    }
    /**
     * Get HostKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHostKey()
    {
        return isset($this->HostKey) ? $this->HostKey : null;
    }
    /**
     * Set HostKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hostKey
     * @return \StructType\StatusInquiryTransaction
     */
    public function setHostKey($hostKey = null)
    {
        // validation for constraint: string
        if (!is_null($hostKey) && !is_string($hostKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostKey)), __LINE__);
        }
        if (is_null($hostKey) || (is_array($hostKey) && empty($hostKey))) {
            unset($this->HostKey);
        } else {
            $this->HostKey = $hostKey;
        }
        return $this;
    }
    /**
     * Get Is3D value
     * @return bool|null
     */
    public function getIs3D()
    {
        return $this->Is3D;
    }
    /**
     * Set Is3D value
     * @param bool $is3D
     * @return \StructType\StatusInquiryTransaction
     */
    public function setIs3D($is3D = null)
    {
        // validation for constraint: boolean
        if (!is_null($is3D) && !is_bool($is3D)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($is3D)), __LINE__);
        }
        $this->Is3D = $is3D;
        return $this;
    }
    /**
     * Get IsSuccess value
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return $this->IsSuccess;
    }
    /**
     * Set IsSuccess value
     * @param bool $isSuccess
     * @return \StructType\StatusInquiryTransaction
     */
    public function setIsSuccess($isSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccess) && !is_bool($isSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSuccess)), __LINE__);
        }
        $this->IsSuccess = $isSuccess;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\StatusInquiryTransaction
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get ProvisionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvisionNumber()
    {
        return isset($this->ProvisionNumber) ? $this->ProvisionNumber : null;
    }
    /**
     * Set ProvisionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provisionNumber
     * @return \StructType\StatusInquiryTransaction
     */
    public function setProvisionNumber($provisionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($provisionNumber) && !is_string($provisionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provisionNumber)), __LINE__);
        }
        if (is_null($provisionNumber) || (is_array($provisionNumber) && empty($provisionNumber))) {
            unset($this->ProvisionNumber);
        } else {
            $this->ProvisionNumber = $provisionNumber;
        }
        return $this;
    }
    /**
     * Get ReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceCode()
    {
        return isset($this->ReferenceCode) ? $this->ReferenceCode : null;
    }
    /**
     * Set ReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceCode
     * @return \StructType\StatusInquiryTransaction
     */
    public function setReferenceCode($referenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($referenceCode) && !is_string($referenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceCode)), __LINE__);
        }
        if (is_null($referenceCode) || (is_array($referenceCode) && empty($referenceCode))) {
            unset($this->ReferenceCode);
        } else {
            $this->ReferenceCode = $referenceCode;
        }
        return $this;
    }
    /**
     * Get TransactionStatusId value
     * @return int|null
     */
    public function getTransactionStatusId()
    {
        return $this->TransactionStatusId;
    }
    /**
     * Set TransactionStatusId value
     * @param int $transactionStatusId
     * @return \StructType\StatusInquiryTransaction
     */
    public function setTransactionStatusId($transactionStatusId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionStatusId) && !is_numeric($transactionStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionStatusId)), __LINE__);
        }
        $this->TransactionStatusId = $transactionStatusId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatusInquiryTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
