<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendApproved3DResultPro StructType
 * @subpackage Structs
 */
class SendApproved3DResultPro extends AbstractStructBase
{
    /**
     * The authInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationInfo
     */
    public $authInfo;
    /**
     * The requestForm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNameValue
     */
    public $requestForm;
    /**
     * The orderReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderReference;
    /**
     * Constructor method for SendApproved3DResultPro
     * @uses SendApproved3DResultPro::setAuthInfo()
     * @uses SendApproved3DResultPro::setRequestForm()
     * @uses SendApproved3DResultPro::setOrderReference()
     * @param \StructType\AuthenticationInfo $authInfo
     * @param \ArrayType\ArrayOfNameValue $requestForm
     * @param string $orderReference
     */
    public function __construct(\StructType\AuthenticationInfo $authInfo = null, \ArrayType\ArrayOfNameValue $requestForm = null, $orderReference = null)
    {
        $this
            ->setAuthInfo($authInfo)
            ->setRequestForm($requestForm)
            ->setOrderReference($orderReference);
    }
    /**
     * Get authInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationInfo|null
     */
    public function getAuthInfo()
    {
        return isset($this->authInfo) ? $this->authInfo : null;
    }
    /**
     * Set authInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationInfo $authInfo
     * @return \StructType\SendApproved3DResultPro
     */
    public function setAuthInfo(\StructType\AuthenticationInfo $authInfo = null)
    {
        if (is_null($authInfo) || (is_array($authInfo) && empty($authInfo))) {
            unset($this->authInfo);
        } else {
            $this->authInfo = $authInfo;
        }
        return $this;
    }
    /**
     * Get requestForm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNameValue|null
     */
    public function getRequestForm()
    {
        return isset($this->requestForm) ? $this->requestForm : null;
    }
    /**
     * Set requestForm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNameValue $requestForm
     * @return \StructType\SendApproved3DResultPro
     */
    public function setRequestForm(\ArrayType\ArrayOfNameValue $requestForm = null)
    {
        if (is_null($requestForm) || (is_array($requestForm) && empty($requestForm))) {
            unset($this->requestForm);
        } else {
            $this->requestForm = $requestForm;
        }
        return $this;
    }
    /**
     * Get orderReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderReference()
    {
        return isset($this->orderReference) ? $this->orderReference : null;
    }
    /**
     * Set orderReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderReference
     * @return \StructType\SendApproved3DResultPro
     */
    public function setOrderReference($orderReference = null)
    {
        // validation for constraint: string
        if (!is_null($orderReference) && !is_string($orderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderReference)), __LINE__);
        }
        if (is_null($orderReference) || (is_array($orderReference) && empty($orderReference))) {
            unset($this->orderReference);
        } else {
            $this->orderReference = $orderReference;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendApproved3DResultPro
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
