<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveCreditCard StructType
 * @subpackage Structs
 */
class SaveCreditCard extends AbstractStructBase
{
    /**
     * The authInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationInfo
     */
    public $authInfo;
    /**
     * The request
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SaveCreditCardRequest
     */
    public $request;
    /**
     * The userCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userCode;
    /**
     * The useForAutomaticPayments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useForAutomaticPayments;
    /**
     * Constructor method for SaveCreditCard
     * @uses SaveCreditCard::setAuthInfo()
     * @uses SaveCreditCard::setRequest()
     * @uses SaveCreditCard::setUserCode()
     * @uses SaveCreditCard::setUseForAutomaticPayments()
     * @param \StructType\AuthenticationInfo $authInfo
     * @param \StructType\SaveCreditCardRequest $request
     * @param string $userCode
     * @param bool $useForAutomaticPayments
     */
    public function __construct(\StructType\AuthenticationInfo $authInfo = null, \StructType\SaveCreditCardRequest $request = null, $userCode = null, $useForAutomaticPayments = null)
    {
        $this
            ->setAuthInfo($authInfo)
            ->setRequest($request)
            ->setUserCode($userCode)
            ->setUseForAutomaticPayments($useForAutomaticPayments);
    }
    /**
     * Get authInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationInfo|null
     */
    public function getAuthInfo()
    {
        return isset($this->authInfo) ? $this->authInfo : null;
    }
    /**
     * Set authInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationInfo $authInfo
     * @return \StructType\SaveCreditCard
     */
    public function setAuthInfo(\StructType\AuthenticationInfo $authInfo = null)
    {
        if (is_null($authInfo) || (is_array($authInfo) && empty($authInfo))) {
            unset($this->authInfo);
        } else {
            $this->authInfo = $authInfo;
        }
        return $this;
    }
    /**
     * Get request value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SaveCreditCardRequest|null
     */
    public function getRequest()
    {
        return isset($this->request) ? $this->request : null;
    }
    /**
     * Set request value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SaveCreditCardRequest $request
     * @return \StructType\SaveCreditCard
     */
    public function setRequest(\StructType\SaveCreditCardRequest $request = null)
    {
        if (is_null($request) || (is_array($request) && empty($request))) {
            unset($this->request);
        } else {
            $this->request = $request;
        }
        return $this;
    }
    /**
     * Get userCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserCode()
    {
        return isset($this->userCode) ? $this->userCode : null;
    }
    /**
     * Set userCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userCode
     * @return \StructType\SaveCreditCard
     */
    public function setUserCode($userCode = null)
    {
        // validation for constraint: string
        if (!is_null($userCode) && !is_string($userCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userCode)), __LINE__);
        }
        if (is_null($userCode) || (is_array($userCode) && empty($userCode))) {
            unset($this->userCode);
        } else {
            $this->userCode = $userCode;
        }
        return $this;
    }
    /**
     * Get useForAutomaticPayments value
     * @return bool|null
     */
    public function getUseForAutomaticPayments()
    {
        return $this->useForAutomaticPayments;
    }
    /**
     * Set useForAutomaticPayments value
     * @param bool $useForAutomaticPayments
     * @return \StructType\SaveCreditCard
     */
    public function setUseForAutomaticPayments($useForAutomaticPayments = null)
    {
        // validation for constraint: boolean
        if (!is_null($useForAutomaticPayments) && !is_bool($useForAutomaticPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useForAutomaticPayments)), __LINE__);
        }
        $this->useForAutomaticPayments = $useForAutomaticPayments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaveCreditCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
