<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SaleResult
 * @subpackage Structs
 */
class SaleResult extends AbstractStructBase
{
    /**
     * The AuthCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthCode;
    /**
     * The BankErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankErrorCode;
    /**
     * The BankMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankMessage;
    /**
     * The BankResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankResult;
    /**
     * The CardBin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CardBinInfo
     */
    public $CardBin;
    /**
     * The ClientReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientReferenceCode;
    /**
     * The HostKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HostKey;
    /**
     * The InternalMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalMessage;
    /**
     * The IsSuccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSuccess;
    /**
     * The ReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceCode;
    /**
     * The ThreeDUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThreeDUrl;
    /**
     * The TokenResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreditCardSaveResult
     */
    public $TokenResult;
    /**
     * The TransactionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionId;
    /**
     * The TransactionStatusId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionStatusId;
    /**
     * Constructor method for SaleResult
     * @uses SaleResult::setAuthCode()
     * @uses SaleResult::setBankErrorCode()
     * @uses SaleResult::setBankMessage()
     * @uses SaleResult::setBankResult()
     * @uses SaleResult::setCardBin()
     * @uses SaleResult::setClientReferenceCode()
     * @uses SaleResult::setHostKey()
     * @uses SaleResult::setInternalMessage()
     * @uses SaleResult::setIsSuccess()
     * @uses SaleResult::setReferenceCode()
     * @uses SaleResult::setThreeDUrl()
     * @uses SaleResult::setTokenResult()
     * @uses SaleResult::setTransactionId()
     * @uses SaleResult::setTransactionStatusId()
     * @param string $authCode
     * @param string $bankErrorCode
     * @param string $bankMessage
     * @param string $bankResult
     * @param \StructType\CardBinInfo $cardBin
     * @param string $clientReferenceCode
     * @param string $hostKey
     * @param string $internalMessage
     * @param bool $isSuccess
     * @param string $referenceCode
     * @param string $threeDUrl
     * @param \StructType\CreditCardSaveResult $tokenResult
     * @param int $transactionId
     * @param int $transactionStatusId
     */
    public function __construct($authCode = null, $bankErrorCode = null, $bankMessage = null, $bankResult = null, \StructType\CardBinInfo $cardBin = null, $clientReferenceCode = null, $hostKey = null, $internalMessage = null, $isSuccess = null, $referenceCode = null, $threeDUrl = null, \StructType\CreditCardSaveResult $tokenResult = null, $transactionId = null, $transactionStatusId = null)
    {
        $this
            ->setAuthCode($authCode)
            ->setBankErrorCode($bankErrorCode)
            ->setBankMessage($bankMessage)
            ->setBankResult($bankResult)
            ->setCardBin($cardBin)
            ->setClientReferenceCode($clientReferenceCode)
            ->setHostKey($hostKey)
            ->setInternalMessage($internalMessage)
            ->setIsSuccess($isSuccess)
            ->setReferenceCode($referenceCode)
            ->setThreeDUrl($threeDUrl)
            ->setTokenResult($tokenResult)
            ->setTransactionId($transactionId)
            ->setTransactionStatusId($transactionStatusId);
    }
    /**
     * Get AuthCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthCode()
    {
        return isset($this->AuthCode) ? $this->AuthCode : null;
    }
    /**
     * Set AuthCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authCode
     * @return \StructType\SaleResult
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authCode)), __LINE__);
        }
        if (is_null($authCode) || (is_array($authCode) && empty($authCode))) {
            unset($this->AuthCode);
        } else {
            $this->AuthCode = $authCode;
        }
        return $this;
    }
    /**
     * Get BankErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankErrorCode()
    {
        return isset($this->BankErrorCode) ? $this->BankErrorCode : null;
    }
    /**
     * Set BankErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankErrorCode
     * @return \StructType\SaleResult
     */
    public function setBankErrorCode($bankErrorCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankErrorCode) && !is_string($bankErrorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankErrorCode)), __LINE__);
        }
        if (is_null($bankErrorCode) || (is_array($bankErrorCode) && empty($bankErrorCode))) {
            unset($this->BankErrorCode);
        } else {
            $this->BankErrorCode = $bankErrorCode;
        }
        return $this;
    }
    /**
     * Get BankMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankMessage()
    {
        return isset($this->BankMessage) ? $this->BankMessage : null;
    }
    /**
     * Set BankMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankMessage
     * @return \StructType\SaleResult
     */
    public function setBankMessage($bankMessage = null)
    {
        // validation for constraint: string
        if (!is_null($bankMessage) && !is_string($bankMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankMessage)), __LINE__);
        }
        if (is_null($bankMessage) || (is_array($bankMessage) && empty($bankMessage))) {
            unset($this->BankMessage);
        } else {
            $this->BankMessage = $bankMessage;
        }
        return $this;
    }
    /**
     * Get BankResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankResult()
    {
        return isset($this->BankResult) ? $this->BankResult : null;
    }
    /**
     * Set BankResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankResult
     * @return \StructType\SaleResult
     */
    public function setBankResult($bankResult = null)
    {
        // validation for constraint: string
        if (!is_null($bankResult) && !is_string($bankResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankResult)), __LINE__);
        }
        if (is_null($bankResult) || (is_array($bankResult) && empty($bankResult))) {
            unset($this->BankResult);
        } else {
            $this->BankResult = $bankResult;
        }
        return $this;
    }
    /**
     * Get CardBin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CardBinInfo|null
     */
    public function getCardBin()
    {
        return isset($this->CardBin) ? $this->CardBin : null;
    }
    /**
     * Set CardBin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CardBinInfo $cardBin
     * @return \StructType\SaleResult
     */
    public function setCardBin(\StructType\CardBinInfo $cardBin = null)
    {
        if (is_null($cardBin) || (is_array($cardBin) && empty($cardBin))) {
            unset($this->CardBin);
        } else {
            $this->CardBin = $cardBin;
        }
        return $this;
    }
    /**
     * Get ClientReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReferenceCode()
    {
        return isset($this->ClientReferenceCode) ? $this->ClientReferenceCode : null;
    }
    /**
     * Set ClientReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReferenceCode
     * @return \StructType\SaleResult
     */
    public function setClientReferenceCode($clientReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientReferenceCode) && !is_string($clientReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReferenceCode)), __LINE__);
        }
        if (is_null($clientReferenceCode) || (is_array($clientReferenceCode) && empty($clientReferenceCode))) {
            unset($this->ClientReferenceCode);
        } else {
            $this->ClientReferenceCode = $clientReferenceCode;
        }
        return $this;
    }
    /**
     * Get HostKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHostKey()
    {
        return isset($this->HostKey) ? $this->HostKey : null;
    }
    /**
     * Set HostKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hostKey
     * @return \StructType\SaleResult
     */
    public function setHostKey($hostKey = null)
    {
        // validation for constraint: string
        if (!is_null($hostKey) && !is_string($hostKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostKey)), __LINE__);
        }
        if (is_null($hostKey) || (is_array($hostKey) && empty($hostKey))) {
            unset($this->HostKey);
        } else {
            $this->HostKey = $hostKey;
        }
        return $this;
    }
    /**
     * Get InternalMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalMessage()
    {
        return isset($this->InternalMessage) ? $this->InternalMessage : null;
    }
    /**
     * Set InternalMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalMessage
     * @return \StructType\SaleResult
     */
    public function setInternalMessage($internalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($internalMessage) && !is_string($internalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalMessage)), __LINE__);
        }
        if (is_null($internalMessage) || (is_array($internalMessage) && empty($internalMessage))) {
            unset($this->InternalMessage);
        } else {
            $this->InternalMessage = $internalMessage;
        }
        return $this;
    }
    /**
     * Get IsSuccess value
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return $this->IsSuccess;
    }
    /**
     * Set IsSuccess value
     * @param bool $isSuccess
     * @return \StructType\SaleResult
     */
    public function setIsSuccess($isSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccess) && !is_bool($isSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSuccess)), __LINE__);
        }
        $this->IsSuccess = $isSuccess;
        return $this;
    }
    /**
     * Get ReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceCode()
    {
        return isset($this->ReferenceCode) ? $this->ReferenceCode : null;
    }
    /**
     * Set ReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceCode
     * @return \StructType\SaleResult
     */
    public function setReferenceCode($referenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($referenceCode) && !is_string($referenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceCode)), __LINE__);
        }
        if (is_null($referenceCode) || (is_array($referenceCode) && empty($referenceCode))) {
            unset($this->ReferenceCode);
        } else {
            $this->ReferenceCode = $referenceCode;
        }
        return $this;
    }
    /**
     * Get ThreeDUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThreeDUrl()
    {
        return isset($this->ThreeDUrl) ? $this->ThreeDUrl : null;
    }
    /**
     * Set ThreeDUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $threeDUrl
     * @return \StructType\SaleResult
     */
    public function setThreeDUrl($threeDUrl = null)
    {
        // validation for constraint: string
        if (!is_null($threeDUrl) && !is_string($threeDUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($threeDUrl)), __LINE__);
        }
        if (is_null($threeDUrl) || (is_array($threeDUrl) && empty($threeDUrl))) {
            unset($this->ThreeDUrl);
        } else {
            $this->ThreeDUrl = $threeDUrl;
        }
        return $this;
    }
    /**
     * Get TokenResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreditCardSaveResult|null
     */
    public function getTokenResult()
    {
        return isset($this->TokenResult) ? $this->TokenResult : null;
    }
    /**
     * Set TokenResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreditCardSaveResult $tokenResult
     * @return \StructType\SaleResult
     */
    public function setTokenResult(\StructType\CreditCardSaveResult $tokenResult = null)
    {
        if (is_null($tokenResult) || (is_array($tokenResult) && empty($tokenResult))) {
            unset($this->TokenResult);
        } else {
            $this->TokenResult = $tokenResult;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param int $transactionId
     * @return \StructType\SaleResult
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !is_numeric($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get TransactionStatusId value
     * @return int|null
     */
    public function getTransactionStatusId()
    {
        return $this->TransactionStatusId;
    }
    /**
     * Set TransactionStatusId value
     * @param int $transactionStatusId
     * @return \StructType\SaleResult
     */
    public function setTransactionStatusId($transactionStatusId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionStatusId) && !is_numeric($transactionStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionStatusId)), __LINE__);
        }
        $this->TransactionStatusId = $transactionStatusId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
