<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleParameters StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SaleParameters
 * @subpackage Structs
 */
class SaleParameters extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The ClientReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientReferenceCode;
    /**
     * The CreditCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreditCard
     */
    public $CreditCard;
    /**
     * The CustomData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCustomDynamicData
     */
    public $CustomData;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Installment
     * @var int
     */
    public $Installment;
    /**
     * The ReturnUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturnUrl;
    /**
     * The Use3d
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Use3d;
    /**
     * The UseSafeKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseSafeKey;
    /**
     * The VirtualPosId
     * @var int
     */
    public $VirtualPosId;
    /**
     * Constructor method for SaleParameters
     * @uses SaleParameters::setAmount()
     * @uses SaleParameters::setClientReferenceCode()
     * @uses SaleParameters::setCreditCard()
     * @uses SaleParameters::setCustomData()
     * @uses SaleParameters::setEmail()
     * @uses SaleParameters::setInstallment()
     * @uses SaleParameters::setReturnUrl()
     * @uses SaleParameters::setUse3d()
     * @uses SaleParameters::setUseSafeKey()
     * @uses SaleParameters::setVirtualPosId()
     * @param float $amount
     * @param string $clientReferenceCode
     * @param \StructType\CreditCard $creditCard
     * @param \ArrayType\ArrayOfCustomDynamicData $customData
     * @param string $email
     * @param int $installment
     * @param string $returnUrl
     * @param bool $use3d
     * @param bool $useSafeKey
     * @param int $virtualPosId
     */
    public function __construct($amount = null, $clientReferenceCode = null, \StructType\CreditCard $creditCard = null, \ArrayType\ArrayOfCustomDynamicData $customData = null, $email = null, $installment = null, $returnUrl = null, $use3d = null, $useSafeKey = null, $virtualPosId = null)
    {
        $this
            ->setAmount($amount)
            ->setClientReferenceCode($clientReferenceCode)
            ->setCreditCard($creditCard)
            ->setCustomData($customData)
            ->setEmail($email)
            ->setInstallment($installment)
            ->setReturnUrl($returnUrl)
            ->setUse3d($use3d)
            ->setUseSafeKey($useSafeKey)
            ->setVirtualPosId($virtualPosId);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SaleParameters
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ClientReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReferenceCode()
    {
        return isset($this->ClientReferenceCode) ? $this->ClientReferenceCode : null;
    }
    /**
     * Set ClientReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReferenceCode
     * @return \StructType\SaleParameters
     */
    public function setClientReferenceCode($clientReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientReferenceCode) && !is_string($clientReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReferenceCode)), __LINE__);
        }
        if (is_null($clientReferenceCode) || (is_array($clientReferenceCode) && empty($clientReferenceCode))) {
            unset($this->ClientReferenceCode);
        } else {
            $this->ClientReferenceCode = $clientReferenceCode;
        }
        return $this;
    }
    /**
     * Get CreditCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreditCard|null
     */
    public function getCreditCard()
    {
        return isset($this->CreditCard) ? $this->CreditCard : null;
    }
    /**
     * Set CreditCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreditCard $creditCard
     * @return \StructType\SaleParameters
     */
    public function setCreditCard(\StructType\CreditCard $creditCard = null)
    {
        if (is_null($creditCard) || (is_array($creditCard) && empty($creditCard))) {
            unset($this->CreditCard);
        } else {
            $this->CreditCard = $creditCard;
        }
        return $this;
    }
    /**
     * Get CustomData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCustomDynamicData|null
     */
    public function getCustomData()
    {
        return isset($this->CustomData) ? $this->CustomData : null;
    }
    /**
     * Set CustomData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCustomDynamicData $customData
     * @return \StructType\SaleParameters
     */
    public function setCustomData(\ArrayType\ArrayOfCustomDynamicData $customData = null)
    {
        if (is_null($customData) || (is_array($customData) && empty($customData))) {
            unset($this->CustomData);
        } else {
            $this->CustomData = $customData;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\SaleParameters
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Installment value
     * @return int|null
     */
    public function getInstallment()
    {
        return $this->Installment;
    }
    /**
     * Set Installment value
     * @param int $installment
     * @return \StructType\SaleParameters
     */
    public function setInstallment($installment = null)
    {
        // validation for constraint: int
        if (!is_null($installment) && !is_numeric($installment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($installment)), __LINE__);
        }
        $this->Installment = $installment;
        return $this;
    }
    /**
     * Get ReturnUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnUrl()
    {
        return isset($this->ReturnUrl) ? $this->ReturnUrl : null;
    }
    /**
     * Set ReturnUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnUrl
     * @return \StructType\SaleParameters
     */
    public function setReturnUrl($returnUrl = null)
    {
        // validation for constraint: string
        if (!is_null($returnUrl) && !is_string($returnUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnUrl)), __LINE__);
        }
        if (is_null($returnUrl) || (is_array($returnUrl) && empty($returnUrl))) {
            unset($this->ReturnUrl);
        } else {
            $this->ReturnUrl = $returnUrl;
        }
        return $this;
    }
    /**
     * Get Use3d value
     * @return bool|null
     */
    public function getUse3d()
    {
        return $this->Use3d;
    }
    /**
     * Set Use3d value
     * @param bool $use3d
     * @return \StructType\SaleParameters
     */
    public function setUse3d($use3d = null)
    {
        // validation for constraint: boolean
        if (!is_null($use3d) && !is_bool($use3d)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($use3d)), __LINE__);
        }
        $this->Use3d = $use3d;
        return $this;
    }
    /**
     * Get UseSafeKey value
     * @return bool|null
     */
    public function getUseSafeKey()
    {
        return $this->UseSafeKey;
    }
    /**
     * Set UseSafeKey value
     * @param bool $useSafeKey
     * @return \StructType\SaleParameters
     */
    public function setUseSafeKey($useSafeKey = null)
    {
        // validation for constraint: boolean
        if (!is_null($useSafeKey) && !is_bool($useSafeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useSafeKey)), __LINE__);
        }
        $this->UseSafeKey = $useSafeKey;
        return $this;
    }
    /**
     * Get VirtualPosId value
     * @return int|null
     */
    public function getVirtualPosId()
    {
        return $this->VirtualPosId;
    }
    /**
     * Set VirtualPosId value
     * @param int $virtualPosId
     * @return \StructType\SaleParameters
     */
    public function setVirtualPosId($virtualPosId = null)
    {
        // validation for constraint: int
        if (!is_null($virtualPosId) && !is_numeric($virtualPosId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($virtualPosId)), __LINE__);
        }
        $this->VirtualPosId = $virtualPosId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
