<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurringQueryResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RecurringQueryResponse
 * @subpackage Structs
 */
class RecurringQueryResponse extends AbstractStructBase
{
    /**
     * The ExecuteStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExecuteStatus;
    /**
     * The PaymentResponse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RecurringPaymentResponseBase
     */
    public $PaymentResponse;
    /**
     * The RecurringPaymentDetailId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecurringPaymentDetailId;
    /**
     * The RecurringPaymentDetailStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecurringPaymentDetailStatus;
    /**
     * Constructor method for RecurringQueryResponse
     * @uses RecurringQueryResponse::setExecuteStatus()
     * @uses RecurringQueryResponse::setPaymentResponse()
     * @uses RecurringQueryResponse::setRecurringPaymentDetailId()
     * @uses RecurringQueryResponse::setRecurringPaymentDetailStatus()
     * @param int $executeStatus
     * @param \StructType\RecurringPaymentResponseBase $paymentResponse
     * @param int $recurringPaymentDetailId
     * @param int $recurringPaymentDetailStatus
     */
    public function __construct($executeStatus = null, \StructType\RecurringPaymentResponseBase $paymentResponse = null, $recurringPaymentDetailId = null, $recurringPaymentDetailStatus = null)
    {
        $this
            ->setExecuteStatus($executeStatus)
            ->setPaymentResponse($paymentResponse)
            ->setRecurringPaymentDetailId($recurringPaymentDetailId)
            ->setRecurringPaymentDetailStatus($recurringPaymentDetailStatus);
    }
    /**
     * Get ExecuteStatus value
     * @return int|null
     */
    public function getExecuteStatus()
    {
        return $this->ExecuteStatus;
    }
    /**
     * Set ExecuteStatus value
     * @param int $executeStatus
     * @return \StructType\RecurringQueryResponse
     */
    public function setExecuteStatus($executeStatus = null)
    {
        // validation for constraint: int
        if (!is_null($executeStatus) && !is_numeric($executeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($executeStatus)), __LINE__);
        }
        $this->ExecuteStatus = $executeStatus;
        return $this;
    }
    /**
     * Get PaymentResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RecurringPaymentResponseBase|null
     */
    public function getPaymentResponse()
    {
        return isset($this->PaymentResponse) ? $this->PaymentResponse : null;
    }
    /**
     * Set PaymentResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RecurringPaymentResponseBase $paymentResponse
     * @return \StructType\RecurringQueryResponse
     */
    public function setPaymentResponse(\StructType\RecurringPaymentResponseBase $paymentResponse = null)
    {
        if (is_null($paymentResponse) || (is_array($paymentResponse) && empty($paymentResponse))) {
            unset($this->PaymentResponse);
        } else {
            $this->PaymentResponse = $paymentResponse;
        }
        return $this;
    }
    /**
     * Get RecurringPaymentDetailId value
     * @return int|null
     */
    public function getRecurringPaymentDetailId()
    {
        return $this->RecurringPaymentDetailId;
    }
    /**
     * Set RecurringPaymentDetailId value
     * @param int $recurringPaymentDetailId
     * @return \StructType\RecurringQueryResponse
     */
    public function setRecurringPaymentDetailId($recurringPaymentDetailId = null)
    {
        // validation for constraint: int
        if (!is_null($recurringPaymentDetailId) && !is_numeric($recurringPaymentDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurringPaymentDetailId)), __LINE__);
        }
        $this->RecurringPaymentDetailId = $recurringPaymentDetailId;
        return $this;
    }
    /**
     * Get RecurringPaymentDetailStatus value
     * @return int|null
     */
    public function getRecurringPaymentDetailStatus()
    {
        return $this->RecurringPaymentDetailStatus;
    }
    /**
     * Set RecurringPaymentDetailStatus value
     * @param int $recurringPaymentDetailStatus
     * @return \StructType\RecurringQueryResponse
     */
    public function setRecurringPaymentDetailStatus($recurringPaymentDetailStatus = null)
    {
        // validation for constraint: int
        if (!is_null($recurringPaymentDetailStatus) && !is_numeric($recurringPaymentDetailStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurringPaymentDetailStatus)), __LINE__);
        }
        $this->RecurringPaymentDetailStatus = $recurringPaymentDetailStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecurringQueryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
