<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurringPaymentResponseBase StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RecurringPaymentResponseBase
 * @subpackage Structs
 */
class RecurringPaymentResponseBase extends AbstractStructBase
{
    /**
     * The ActualPaymentDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActualPaymentDate;
    /**
     * The Appr
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Appr;
    /**
     * The AutCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AutCode;
    /**
     * The ErrMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrMessage;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorCode;
    /**
     * The HostKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HostKey;
    /**
     * The OrderId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderId;
    /**
     * The ReceivedValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceivedValue;
    /**
     * The ResultType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResultType;
    /**
     * The SendValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SendValue;
    /**
     * Constructor method for RecurringPaymentResponseBase
     * @uses RecurringPaymentResponseBase::setActualPaymentDate()
     * @uses RecurringPaymentResponseBase::setAppr()
     * @uses RecurringPaymentResponseBase::setAutCode()
     * @uses RecurringPaymentResponseBase::setErrMessage()
     * @uses RecurringPaymentResponseBase::setErrorCode()
     * @uses RecurringPaymentResponseBase::setHostKey()
     * @uses RecurringPaymentResponseBase::setOrderId()
     * @uses RecurringPaymentResponseBase::setReceivedValue()
     * @uses RecurringPaymentResponseBase::setResultType()
     * @uses RecurringPaymentResponseBase::setSendValue()
     * @param string $actualPaymentDate
     * @param string $appr
     * @param string $autCode
     * @param string $errMessage
     * @param string $errorCode
     * @param string $hostKey
     * @param string $orderId
     * @param string $receivedValue
     * @param string $resultType
     * @param string $sendValue
     */
    public function __construct($actualPaymentDate = null, $appr = null, $autCode = null, $errMessage = null, $errorCode = null, $hostKey = null, $orderId = null, $receivedValue = null, $resultType = null, $sendValue = null)
    {
        $this
            ->setActualPaymentDate($actualPaymentDate)
            ->setAppr($appr)
            ->setAutCode($autCode)
            ->setErrMessage($errMessage)
            ->setErrorCode($errorCode)
            ->setHostKey($hostKey)
            ->setOrderId($orderId)
            ->setReceivedValue($receivedValue)
            ->setResultType($resultType)
            ->setSendValue($sendValue);
    }
    /**
     * Get ActualPaymentDate value
     * @return string|null
     */
    public function getActualPaymentDate()
    {
        return $this->ActualPaymentDate;
    }
    /**
     * Set ActualPaymentDate value
     * @param string $actualPaymentDate
     * @return \StructType\RecurringPaymentResponseBase
     */
    public function setActualPaymentDate($actualPaymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($actualPaymentDate) && !is_string($actualPaymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualPaymentDate)), __LINE__);
        }
        $this->ActualPaymentDate = $actualPaymentDate;
        return $this;
    }
    /**
     * Get Appr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppr()
    {
        return isset($this->Appr) ? $this->Appr : null;
    }
    /**
     * Set Appr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appr
     * @return \StructType\RecurringPaymentResponseBase
     */
    public function setAppr($appr = null)
    {
        // validation for constraint: string
        if (!is_null($appr) && !is_string($appr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appr)), __LINE__);
        }
        if (is_null($appr) || (is_array($appr) && empty($appr))) {
            unset($this->Appr);
        } else {
            $this->Appr = $appr;
        }
        return $this;
    }
    /**
     * Get AutCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAutCode()
    {
        return isset($this->AutCode) ? $this->AutCode : null;
    }
    /**
     * Set AutCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $autCode
     * @return \StructType\RecurringPaymentResponseBase
     */
    public function setAutCode($autCode = null)
    {
        // validation for constraint: string
        if (!is_null($autCode) && !is_string($autCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autCode)), __LINE__);
        }
        if (is_null($autCode) || (is_array($autCode) && empty($autCode))) {
            unset($this->AutCode);
        } else {
            $this->AutCode = $autCode;
        }
        return $this;
    }
    /**
     * Get ErrMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrMessage()
    {
        return isset($this->ErrMessage) ? $this->ErrMessage : null;
    }
    /**
     * Set ErrMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errMessage
     * @return \StructType\RecurringPaymentResponseBase
     */
    public function setErrMessage($errMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errMessage) && !is_string($errMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errMessage)), __LINE__);
        }
        if (is_null($errMessage) || (is_array($errMessage) && empty($errMessage))) {
            unset($this->ErrMessage);
        } else {
            $this->ErrMessage = $errMessage;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->ErrorCode) ? $this->ErrorCode : null;
    }
    /**
     * Set ErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \StructType\RecurringPaymentResponseBase
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->ErrorCode);
        } else {
            $this->ErrorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get HostKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHostKey()
    {
        return isset($this->HostKey) ? $this->HostKey : null;
    }
    /**
     * Set HostKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hostKey
     * @return \StructType\RecurringPaymentResponseBase
     */
    public function setHostKey($hostKey = null)
    {
        // validation for constraint: string
        if (!is_null($hostKey) && !is_string($hostKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostKey)), __LINE__);
        }
        if (is_null($hostKey) || (is_array($hostKey) && empty($hostKey))) {
            unset($this->HostKey);
        } else {
            $this->HostKey = $hostKey;
        }
        return $this;
    }
    /**
     * Get OrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderId()
    {
        return isset($this->OrderId) ? $this->OrderId : null;
    }
    /**
     * Set OrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderId
     * @return \StructType\RecurringPaymentResponseBase
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderId)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->OrderId);
        } else {
            $this->OrderId = $orderId;
        }
        return $this;
    }
    /**
     * Get ReceivedValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceivedValue()
    {
        return isset($this->ReceivedValue) ? $this->ReceivedValue : null;
    }
    /**
     * Set ReceivedValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receivedValue
     * @return \StructType\RecurringPaymentResponseBase
     */
    public function setReceivedValue($receivedValue = null)
    {
        // validation for constraint: string
        if (!is_null($receivedValue) && !is_string($receivedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receivedValue)), __LINE__);
        }
        if (is_null($receivedValue) || (is_array($receivedValue) && empty($receivedValue))) {
            unset($this->ReceivedValue);
        } else {
            $this->ReceivedValue = $receivedValue;
        }
        return $this;
    }
    /**
     * Get ResultType value
     * @return string|null
     */
    public function getResultType()
    {
        return $this->ResultType;
    }
    /**
     * Set ResultType value
     * @uses \EnumType\ResultType::valueIsValid()
     * @uses \EnumType\ResultType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultType
     * @return \StructType\RecurringPaymentResponseBase
     */
    public function setResultType($resultType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResultType::valueIsValid($resultType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resultType, implode(', ', \EnumType\ResultType::getValidValues())), __LINE__);
        }
        $this->ResultType = $resultType;
        return $this;
    }
    /**
     * Get SendValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSendValue()
    {
        return isset($this->SendValue) ? $this->SendValue : null;
    }
    /**
     * Set SendValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sendValue
     * @return \StructType\RecurringPaymentResponseBase
     */
    public function setSendValue($sendValue = null)
    {
        // validation for constraint: string
        if (!is_null($sendValue) && !is_string($sendValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendValue)), __LINE__);
        }
        if (is_null($sendValue) || (is_array($sendValue) && empty($sendValue))) {
            unset($this->SendValue);
        } else {
            $this->SendValue = $sendValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecurringPaymentResponseBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
