<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurringPaymentQuery StructType
 * @subpackage Structs
 */
class RecurringPaymentQuery extends AbstractStructBase
{
    /**
     * The authInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationInfo
     */
    public $authInfo;
    /**
     * The orderId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderId;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ipAddress;
    /**
     * The paymentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $paymentNumber;
    /**
     * Constructor method for RecurringPaymentQuery
     * @uses RecurringPaymentQuery::setAuthInfo()
     * @uses RecurringPaymentQuery::setOrderId()
     * @uses RecurringPaymentQuery::setEmail()
     * @uses RecurringPaymentQuery::setIpAddress()
     * @uses RecurringPaymentQuery::setPaymentNumber()
     * @param \StructType\AuthenticationInfo $authInfo
     * @param string $orderId
     * @param string $email
     * @param string $ipAddress
     * @param int $paymentNumber
     */
    public function __construct(\StructType\AuthenticationInfo $authInfo = null, $orderId = null, $email = null, $ipAddress = null, $paymentNumber = null)
    {
        $this
            ->setAuthInfo($authInfo)
            ->setOrderId($orderId)
            ->setEmail($email)
            ->setIpAddress($ipAddress)
            ->setPaymentNumber($paymentNumber);
    }
    /**
     * Get authInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationInfo|null
     */
    public function getAuthInfo()
    {
        return isset($this->authInfo) ? $this->authInfo : null;
    }
    /**
     * Set authInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationInfo $authInfo
     * @return \StructType\RecurringPaymentQuery
     */
    public function setAuthInfo(\StructType\AuthenticationInfo $authInfo = null)
    {
        if (is_null($authInfo) || (is_array($authInfo) && empty($authInfo))) {
            unset($this->authInfo);
        } else {
            $this->authInfo = $authInfo;
        }
        return $this;
    }
    /**
     * Get orderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderId()
    {
        return isset($this->orderId) ? $this->orderId : null;
    }
    /**
     * Set orderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderId
     * @return \StructType\RecurringPaymentQuery
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderId)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->orderId);
        } else {
            $this->orderId = $orderId;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\RecurringPaymentQuery
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get ipAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIpAddress()
    {
        return isset($this->ipAddress) ? $this->ipAddress : null;
    }
    /**
     * Set ipAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ipAddress
     * @return \StructType\RecurringPaymentQuery
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        if (is_null($ipAddress) || (is_array($ipAddress) && empty($ipAddress))) {
            unset($this->ipAddress);
        } else {
            $this->ipAddress = $ipAddress;
        }
        return $this;
    }
    /**
     * Get paymentNumber value
     * @return int|null
     */
    public function getPaymentNumber()
    {
        return $this->paymentNumber;
    }
    /**
     * Set paymentNumber value
     * @param int $paymentNumber
     * @return \StructType\RecurringPaymentQuery
     */
    public function setPaymentNumber($paymentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($paymentNumber) && !is_numeric($paymentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentNumber)), __LINE__);
        }
        $this->paymentNumber = $paymentNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecurringPaymentQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
